/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.URLUtil;
import com.tencent.cos.xml.common.Range;
import com.tencent.cos.xml.model.tag.UrlUploadPolicy;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class UrlUtil {
    public static boolean isUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return Patterns.WEB_URL.matcher(url).matches() && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    public static UrlUploadPolicy getUrlUploadPolicy(String url) {
        if (!UrlUtil.isUrl(url)) {
            return new UrlUploadPolicy(UrlUploadPolicy.Type.NOTSUPPORT, 0L);
        }
        URL url1 = null;
        try {
            url1 = new URL(url);
        }
        catch (MalformedURLException e) {
            return new UrlUploadPolicy(UrlUploadPolicy.Type.NOTSUPPORT, 0L);
        }
        Range range = new Range(0L, 1L);
        HttpRequest request = new HttpRequest.Builder().url(url1).method("GET").addHeader("Range", range.getRange()).build();
        HttpResult result = null;
        QCloudHttpClient defaultClient = QCloudHttpClient.getDefault();
        try {
            result = (HttpResult)defaultClient.resolveRequest(request).executeNow();
        }
        catch (QCloudClientException | QCloudServiceException e) {
            return new UrlUploadPolicy(UrlUploadPolicy.Type.NOTSUPPORT, 0L);
        }
        if (result != null && result.isSuccessful() && result.headers() != null && result.headers().size() > 0) {
            String acceptRanges = result.header("Accept-Ranges");
            String contentRange = result.header("Content-Range");
            if ("bytes".equals(acceptRanges) && !TextUtils.isEmpty((CharSequence)contentRange)) {
                long[] contentRanges = QCloudHttpUtils.parseContentRange((String)contentRange);
                if (contentRanges != null) {
                    return new UrlUploadPolicy(UrlUploadPolicy.Type.RANGE, contentRanges[2]);
                }
            } else {
                String contentLength = result.header("Content-Length");
                if (!TextUtils.isEmpty((CharSequence)contentLength)) {
                    return new UrlUploadPolicy(UrlUploadPolicy.Type.ENTIRETY, Long.parseLong(contentLength));
                }
            }
        }
        return new UrlUploadPolicy(UrlUploadPolicy.Type.NOTSUPPORT, 0L);
    }
}

