/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.qcloud.core.http.HttpResponse;
import java.util.Arrays;
import java.util.List;

public final class OptionObjectResult
extends CosXmlResult {
    public String accessControlAllowOrigin;
    public List<String> accessControlAllowMethods;
    public List<String> accessControlAllowHeaders;
    public List<String> accessControlExposeHeaders;
    public long accessControlMaxAge;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        this.accessControlAllowOrigin = response.header("Access-Control-Allow-Origin");
        if (response.header("Access-Control-Max-Age") != null) {
            this.accessControlMaxAge = Long.parseLong(response.header("Access-Control-Max-Age"));
        }
        if (response.header("Access-Control-Allow-Methods") != null) {
            this.accessControlAllowMethods = Arrays.asList(response.header("Access-Control-Allow-Methods").split(","));
        }
        if (response.header("Access-Control-Allow-Headers") != null) {
            this.accessControlAllowHeaders = Arrays.asList(response.header("Access-Control-Allow-Headers").split(","));
        }
        if (response.header("Access-Control-Expose-Headers") != null) {
            this.accessControlExposeHeaders = Arrays.asList(response.header("Access-Control-Expose-Headers").split(","));
        }
    }

    @Override
    public String printResult() {
        return super.printResult() + "\n" + this.accessControlAllowOrigin + "\n" + this.accessControlMaxAge + "\n";
    }
}

