/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tencent.cos.xml.BeaconService;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class TaskStateMonitor
implements Runnable {
    private static final String TAG = "TaskStateMonitor";
    private static TaskStateMonitor monitor;
    private static Handler taskHandler;
    private Looper looper;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private volatile boolean isRunning = false;
    public static final int MESSAGE_TASK_RESULT = 1;
    public static final int MESSAGE_TASK_MANUAL = 2;
    public static final int MESSAGE_RELEASE_LOOP = 3;
    public static final int MESSAGE_TASK_INIT = 4;
    public static final int MESSAGE_TASK_CONSTRAINT = 5;

    private TaskStateMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskStateMonitor getInstance() {
        Class<TaskStateMonitor> clazz = TaskStateMonitor.class;
        synchronized (TaskStateMonitor.class) {
            if (monitor == null) {
                monitor = new TaskStateMonitor();
            }
            monitor.monitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitor;
        }
    }

    private void monitor() {
        if (this.isRunning) {
            return;
        }
        this.executorService.submit(this);
        this.isRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskStateMonitor taskStateMonitor = this;
        synchronized (taskStateMonitor) {
            this.looper = Looper.myLooper();
            if (this.looper != null) {
                this.notifyAll();
            }
        }
        if (this.looper == null) {
            Looper.prepare();
            taskStateMonitor = this;
            synchronized (taskStateMonitor) {
                this.looper = Looper.myLooper();
                this.notifyAll();
            }
        }
        try {
            this.setMessageQueue();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            BeaconService.getInstance().reportError(TAG, e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            BeaconService.getInstance().reportError(TAG, e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            BeaconService.getInstance().reportError(TAG, e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            BeaconService.getInstance().reportError(TAG, e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            BeaconService.getInstance().reportError(TAG, e);
        }
        taskHandler = new Handler(this.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        StructMsg structMsg = (StructMsg)msg.obj;
                        TaskStateMonitor.this.stateTransform(structMsg.cosxmlTask, structMsg.transferState, structMsg.exception, structMsg.result, false);
                        break;
                    }
                    case 2: {
                        StructMsg manualMsg = (StructMsg)msg.obj;
                        TaskStateMonitor.this.stateTransform(manualMsg.cosxmlTask, manualMsg.transferState, manualMsg.exception, null, false);
                        break;
                    }
                    case 4: {
                        StructMsg initMsg = (StructMsg)msg.obj;
                        TaskStateMonitor.this.stateTransform(initMsg.cosxmlTask, initMsg.transferState, initMsg.exception, initMsg.result, true);
                        break;
                    }
                    case 5: {
                        StructMsg constraintMsg = (StructMsg)msg.obj;
                        TaskStateMonitor.this.stateTransform(constraintMsg.cosxmlTask, constraintMsg.transferState, constraintMsg.exception, constraintMsg.result, false);
                        break;
                    }
                    case 3: {
                        TaskStateMonitor.this.releaseLooper();
                    }
                }
            }
        };
        Looper.loop();
    }

    private void setMessageQueue() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, InstantiationException {
        Constructor<?>[] messageQueueConstructor;
        Field messageQueueField = Looper.class.getDeclaredField("mQueue");
        messageQueueField.setAccessible(true);
        Class<?> messageQueueClass = Class.forName("android.os.MessageQueue");
        block0: for (Constructor<?> constructor : messageQueueConstructor = messageQueueClass.getDeclaredConstructors()) {
            Class<?>[] types;
            constructor.setAccessible(true);
            for (Class<?> clazz : types = constructor.getParameterTypes()) {
                if (!clazz.getName().equalsIgnoreCase("boolean")) continue;
                messageQueueField.set(this.looper, constructor.newInstance(true));
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!Thread.currentThread().isAlive()) {
            return null;
        }
        TaskStateMonitor taskStateMonitor = this;
        synchronized (taskStateMonitor) {
            while (Thread.currentThread().isAlive() && this.looper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.looper;
    }

    public void quitSafely() {
        taskHandler.removeCallbacksAndMessages(null);
        Looper looper = this.getLooper();
        if (looper != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                looper.quitSafely();
            } else {
                looper.quit();
            }
        }
        this.isRunning = false;
    }

    protected void stateTransform(COSXMLTask cosxmlTask, TransferState newState, Exception exception, CosXmlResult result, boolean isInit) {
        cosxmlTask.updateState(newState, exception, result, isInit);
    }

    protected void sendStateMessage(COSXMLTask cosxmlTask, TransferState newState, Exception exception, CosXmlResult cosXmlResult, int what) {
        if (taskHandler == null) {
            return;
        }
        Message message = taskHandler.obtainMessage();
        message.what = what;
        StructMsg structMsg = new StructMsg();
        structMsg.cosxmlTask = cosxmlTask;
        structMsg.transferState = newState;
        structMsg.exception = exception;
        structMsg.result = cosXmlResult;
        message.obj = structMsg;
        taskHandler.sendMessage(message);
    }

    private void releaseLooper() {
        this.quitSafely();
    }

    private class StructMsg {
        COSXMLTask cosxmlTask;
        volatile TransferState transferState;
        Exception exception;
        CosXmlResult result;

        private StructMsg() {
        }
    }
}

