/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.cos.xml.BeaconService;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.LogServerProxy;
import com.tencent.cos.xml.SimpleCosXml;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.BaseMultipartUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.GetObjectBytesRequest;
import com.tencent.cos.xml.model.object.GetObjectBytesResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PostObjectRequest;
import com.tencent.cos.xml.model.object.PostObjectResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartCopyRequest;
import com.tencent.cos.xml.model.object.UploadPartCopyResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.ResponseBytesConverter;
import com.tencent.cos.xml.transfer.ResponseFileBodySerializer;
import com.tencent.cos.xml.transfer.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.utils.StringUtils;
import com.tencent.cos.xml.utils.TimeUtils;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.SignerFactory;
import com.tencent.qcloud.core.auth.StaticCredentialProvider;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.OkHttpClientImpl;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.LogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.qcloud.core.util.ContextHolder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;

public class CosXmlSimpleService
implements SimpleCosXml {
    private static final String TAG = "CosXmlSimpleService";
    protected static volatile QCloudHttpClient client;
    protected QCloudCredentialProvider credentialProvider;
    protected String tag = "CosXml";
    protected String signerType = "CosXmlSigner";
    protected CosXmlServiceConfig config;
    public static String appCachePath;
    private String requestDomain;

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        this(context, configuration);
        this.credentialProvider = qCloudCredentialProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration) {
        if (configuration.isDebuggable()) {
            FileLogAdapter fileLogAdapter = FileLogAdapter.getInstance((Context)context, (String)"QLog");
            LogServerProxy.init(context, fileLogAdapter);
            QCloudLogger.addAdapter((LogAdapter)fileLogAdapter);
        }
        BeaconService.init(context.getApplicationContext(), configuration);
        appCachePath = context.getApplicationContext().getFilesDir().getPath();
        if (client == null) {
            Class<CosXmlSimpleService> clazz = CosXmlSimpleService.class;
            // MONITORENTER : com.tencent.cos.xml.CosXmlSimpleService.class
            if (client == null) {
                QCloudHttpClient.Builder builder = new QCloudHttpClient.Builder();
                this.init(builder, configuration);
                client = builder.build();
            }
            // MONITOREXIT : clazz
        }
        this.config = configuration;
        client.addVerifiedHost("*." + configuration.getEndpointSuffix());
        client.addVerifiedHost("*." + configuration.getEndpointSuffix(configuration.getRegion(), true));
        client.setDebuggable(configuration.isDebuggable());
        ContextHolder.setContext((Context)context);
    }

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudSigner qCloudSigner) {
        this(context, configuration);
        this.credentialProvider = new StaticCredentialProvider(null);
        this.signerType = "UserCosXmlSigner";
        SignerFactory.registerSigner((String)this.signerType, (QCloudSigner)qCloudSigner);
    }

    private void init(QCloudHttpClient.Builder builder, CosXmlServiceConfig configuration) {
        QCloudHttpRetryHandler qCloudHttpRetryHandler;
        builder.setConnectionTimeout(configuration.getConnectionTimeout()).setSocketTimeout(configuration.getSocketTimeout());
        RetryStrategy retryStrategy = configuration.getRetryStrategy();
        if (retryStrategy != null) {
            builder.setRetryStrategy(retryStrategy);
        }
        if ((qCloudHttpRetryHandler = configuration.getQCloudHttpRetryHandler()) != null) {
            builder.setQCloudHttpRetryHandler(qCloudHttpRetryHandler);
        }
        builder.enableDebugLog(configuration.isDebuggable());
        if (configuration.isEnableQuic()) {
            try {
                Class<?> clazz = Class.forName("com.tencent.qcloud.quic.QuicClientImpl");
                builder.setNetworkClient((NetworkClient)clazz.newInstance());
            }
            catch (Exception e) {
                IllegalStateException illegalStateException = new IllegalStateException(e.getMessage(), e);
                BeaconService.getInstance().reportError(TAG, illegalStateException);
                throw illegalStateException;
            }
        } else {
            builder.setNetworkClient((NetworkClient)new OkHttpClientImpl());
        }
        builder.dnsCache(configuration.isDnsCache());
        builder.addPrefetchHost(configuration.getEndpointSuffix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkClient(CosXmlServiceConfig configuration) {
        Class<CosXmlSimpleService> clazz = CosXmlSimpleService.class;
        synchronized (CosXmlSimpleService.class) {
            QCloudHttpClient.Builder builder = new QCloudHttpClient.Builder();
            this.init(builder, configuration);
            client.setNetworkClientType(builder);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.config = configuration;
            client.addVerifiedHost("*." + configuration.getEndpointSuffix());
            client.addVerifiedHost("*." + configuration.getEndpointSuffix(configuration.getRegion(), true));
            client.setDebuggable(configuration.isDebuggable());
            return;
        }
    }

    public void addCustomerDNS(String domainName, String[] ipList) throws CosXmlClientException {
        try {
            client.addDnsRecord(domainName, ipList);
        }
        catch (UnknownHostException e) {
            throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
        }
    }

    @Deprecated
    public void addVerifiedHost(String hostName) {
        client.addVerifiedHost(hostName);
    }

    public void setDomain(String domain) {
        this.requestDomain = domain;
    }

    protected String getRequestHostHeader(CosXmlRequest request) {
        String bucket = this.config.getBucket(request.getBucket());
        String region = !TextUtils.isEmpty((CharSequence)request.getRegion()) ? request.getRegion() : this.config.getRegion();
        return String.format(Locale.ENGLISH, "%s.cos.%s.myqcloud.com", bucket, region);
    }

    protected String getRequestHost(CosXmlRequest request) throws CosXmlClientException {
        if (!TextUtils.isEmpty((CharSequence)this.requestDomain)) {
            return this.requestDomain;
        }
        return request.getRequestHost(this.config);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> QCloudHttpRequest buildHttpRequest(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException {
        QCloudHttpRequest.Builder httpRequestBuilder = new QCloudHttpRequest.Builder().method(cosXmlRequest.getMethod()).userAgent(this.config.getUserAgent()).tag((Object)this.tag);
        httpRequestBuilder.addNoSignHeaderKeys(this.config.getNoSignHeaders());
        httpRequestBuilder.addNoSignHeaderKeys(cosXmlRequest.getNoSignHeaders());
        String requestURL = cosXmlRequest.getRequestURL();
        String host = this.getRequestHost(cosXmlRequest);
        if (requestURL != null) {
            try {
                httpRequestBuilder.url(new URL(requestURL));
            }
            catch (MalformedURLException e) {
                throw new CosXmlClientException(ClientErrorCode.BAD_REQUEST.getCode(), e);
            }
        } else {
            cosXmlRequest.checkParameters();
            httpRequestBuilder.scheme(this.config.getProtocol()).host(host).path(cosXmlRequest.getPath(this.config));
            if (this.config.getPort() != -1) {
                httpRequestBuilder.port(this.config.getPort());
            }
            httpRequestBuilder.query(cosXmlRequest.getQueryString());
        }
        if (cosXmlRequest instanceof CopyObjectRequest) {
            ((CopyObjectRequest)cosXmlRequest).setCopySource(((CopyObjectRequest)cosXmlRequest).getCopySource(), this.config);
        }
        HashSet<String> headerKeys = new HashSet<String>();
        headerKeys.addAll(this.config.getCommonHeaders().keySet());
        headerKeys.addAll(cosXmlRequest.getRequestHeaders().keySet());
        HashMap<String, List<String>> extraHeaders = new HashMap<String, List<String>>();
        for (String headerKey : headerKeys) {
            List<String> headerValue = cosXmlRequest.getRequestHeaders().get(headerKey);
            if (headerValue == null) {
                headerValue = this.config.getCommonHeaders().get(headerKey);
            }
            if (headerValue == null) continue;
            extraHeaders.put(headerKey, headerValue);
        }
        if (!extraHeaders.containsKey("Host")) {
            LinkedList<String> hostHeaderValue = new LinkedList<String>();
            hostHeaderValue.add(host);
            extraHeaders.put("Host", hostHeaderValue);
        }
        httpRequestBuilder.addHeaders(extraHeaders);
        if (cosXmlRequest.isNeedMD5()) {
            httpRequestBuilder.contentMD5();
        }
        if (this.credentialProvider == null) {
            httpRequestBuilder.signer(null, null);
        } else {
            httpRequestBuilder.signer(this.signerType, cosXmlRequest.getSignSourceProvider());
        }
        httpRequestBuilder.credentialScope(cosXmlRequest.getSTSCredentialScope(this.config));
        if (cosXmlRequest.getRequestBody() != null) {
            httpRequestBuilder.body(cosXmlRequest.getRequestBody());
        }
        if (cosXmlRequest instanceof GetObjectRequest) {
            String absolutePath = ((GetObjectRequest)cosXmlRequest).getDownloadPath();
            httpRequestBuilder.converter(new ResponseFileBodySerializer((GetObjectResult)cosXmlResult, absolutePath, ((GetObjectRequest)cosXmlRequest).getFileOffset()));
        } else if (cosXmlRequest instanceof GetObjectBytesRequest) {
            httpRequestBuilder.converter(new ResponseBytesConverter((GetObjectBytesResult)cosXmlResult));
        } else if (!this.buildHttpRequestBodyConverter(cosXmlRequest, cosXmlResult, httpRequestBuilder)) {
            httpRequestBuilder.converter(new ResponseXmlS3BodySerializer(cosXmlResult));
        }
        httpRequestBuilder.signInUrl(cosXmlRequest.isSignInUrl() || this.config.isSignInUrl());
        QCloudHttpRequest httpRequest = httpRequestBuilder.build();
        return httpRequest;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> boolean buildHttpRequestBodyConverter(T1 cosXmlRequest, T2 cosXmlResult, QCloudHttpRequest.Builder<T2> httpRequestBuilder) {
        return false;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException, CosXmlServiceException {
        long start = System.nanoTime();
        try {
            cosXmlRequest.attachMetrics(new HttpTaskMetrics());
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            HttpResult httpResult = (HttpResult)httpTask.executeNow();
            BeaconService.getInstance().reportBaseService(cosXmlRequest, TimeUtils.getTookTime(start));
            return (T2)(httpResult != null ? (CosXmlResult)httpResult.content() : null);
        }
        catch (QCloudServiceException e) {
            throw BeaconService.getInstance().reportBaseService(cosXmlRequest, TimeUtils.getTookTime(start), e);
        }
        catch (QCloudClientException e) {
            throw BeaconService.getInstance().reportBaseService(cosXmlRequest, TimeUtils.getTookTime(start), e);
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(final T1 cosXmlRequest, T2 cosXmlResult, final CosXmlResultListener cosXmlResultListener) {
        final long start = System.nanoTime();
        QCloudResultListener qCloudResultListener = new QCloudResultListener<HttpResult<T2>>(){

            public void onSuccess(HttpResult<T2> result) {
                BeaconService.getInstance().reportBaseService(cosXmlRequest, TimeUtils.getTookTime(start));
                cosXmlResultListener.onSuccess(cosXmlRequest, (CosXmlResult)result.content());
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                long tookTime = TimeUtils.getTookTime(start);
                if (clientException != null) {
                    CosXmlClientException xmlClientException = BeaconService.getInstance().reportBaseService(cosXmlRequest, tookTime, clientException);
                    cosXmlResultListener.onFail(cosXmlRequest, xmlClientException, null);
                } else if (serviceException != null) {
                    CosXmlServiceException xmlServiceException = BeaconService.getInstance().reportBaseService(cosXmlRequest, tookTime, serviceException);
                    cosXmlResultListener.onFail(cosXmlRequest, null, xmlServiceException);
                } else {
                    CosXmlClientException xmlClientException = BeaconService.getInstance().reportBaseService(cosXmlRequest, tookTime, new CosXmlClientException(ClientErrorCode.UNKNOWN.getCode(), "Unknown Error"));
                    cosXmlResultListener.onFail(cosXmlRequest, xmlClientException, null);
                }
            }
        };
        try {
            cosXmlRequest.attachMetrics(new HttpTaskMetrics());
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = cosXmlRequest instanceof PostObjectRequest ? client.resolveRequest(httpRequest, null) : client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
                httpTask.setOnRequestWeightListener(new QCloudTask.OnRequestWeightListener(){

                    public int onWeight() {
                        return cosXmlRequest.getWeight();
                    }
                });
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            Executor executor = this.config.getExecutor();
            Executor observeExecutor = this.config.getObserveExecutor();
            if (observeExecutor != null) {
                httpTask.observeOn(observeExecutor);
            }
            if (executor != null) {
                httpTask.scheduleOn(executor);
            } else if (cosXmlRequest instanceof BaseMultipartUploadRequest) {
                httpTask.scheduleOn((Executor)TaskExecutors.UPLOAD_EXECUTOR, cosXmlRequest.getPriority());
            } else {
                httpTask.schedule();
            }
            httpTask.addResultListener(qCloudResultListener);
        }
        catch (QCloudClientException e) {
            CosXmlClientException clientException = BeaconService.getInstance().reportBaseService(cosXmlRequest, TimeUtils.getTookTime(start), e);
            cosXmlResultListener.onFail(cosXmlRequest, clientException, null);
        }
    }

    public String getAccessUrl(CosXmlRequest cosXmlRequest) {
        String requestURL = cosXmlRequest.getRequestURL();
        if (requestURL != null) {
            int index = requestURL.indexOf("?");
            return index > 0 ? requestURL.substring(0, index) : requestURL;
        }
        String host = null;
        try {
            host = this.getRequestHost(cosXmlRequest);
        }
        catch (CosXmlClientException e) {
            BeaconService.getInstance().reportError(TAG, (Exception)((Object)e));
            e.printStackTrace();
        }
        String path = "/";
        try {
            path = URLEncodeUtils.cosPathEncode(cosXmlRequest.getPath(this.config));
        }
        catch (CosXmlClientException e) {
            BeaconService.getInstance().reportError(TAG, (Exception)((Object)e));
            e.printStackTrace();
        }
        return this.config.getProtocol() + "://" + host + path;
    }

    public String getPresignedURL(CosXmlRequest cosXmlRequest) throws CosXmlClientException {
        try {
            QCloudLifecycleCredentials qCloudLifecycleCredentials = (QCloudLifecycleCredentials)this.credentialProvider.getCredentials();
            QCloudSigner signer = SignerFactory.getSigner((String)this.signerType);
            QCloudHttpRequest request = this.buildHttpRequest(cosXmlRequest, null);
            signer.sign(request, (QCloudCredentials)qCloudLifecycleCredentials);
            String sign = request.header("Authorization");
            String token = request.header("x-cos-security-token");
            if (!TextUtils.isEmpty((CharSequence)token)) {
                sign = sign + "&x-cos-security-token=" + token;
            }
            String url = this.getAccessUrl(cosXmlRequest);
            String query = StringUtils.flat(cosXmlRequest.getQueryString());
            return TextUtils.isEmpty((CharSequence)query) ? url + "?" + sign : url + "?" + query + "&" + sign;
        }
        catch (QCloudClientException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), e);
        }
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetObjectResult());
    }

    @Override
    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectResult(), cosXmlResultListener);
    }

    @Override
    public byte[] getObject(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        GetObjectBytesRequest getObjectBytesRequest = new GetObjectBytesRequest(bucketName, objectName);
        GetObjectBytesResult getObjectBytesResult = this.execute(getObjectBytesRequest, new GetObjectBytesResult());
        return getObjectBytesResult != null ? getObjectBytesResult.data : new byte[]{};
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, putObjectResult);
    }

    @Override
    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, putObjectResult, cosXmlResultListener);
    }

    @Override
    public PostObjectResult postObject(PostObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PostObjectResult postObjectResult = new PostObjectResult();
        return this.execute(request, postObjectResult);
    }

    @Override
    public void postObjectAsync(PostObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PostObjectResult postObjectResult = new PostObjectResult();
        this.schedule(request, postObjectResult, cosXmlResultListener);
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteObjectResult());
    }

    @Override
    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteObjectResult(), cosXmlResultListener);
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new HeadObjectResult());
    }

    @Override
    public void headObjectAsync(HeadObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new HeadObjectResult(), cosXmlResultListener);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new CopyObjectResult());
    }

    @Override
    public void copyObjectAsync(CopyObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new CopyObjectResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartCopyResult copyObject(UploadPartCopyRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartCopyResult());
    }

    @Override
    public void copyObjectAsync(UploadPartCopyRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartCopyResult(), cosXmlResultListener);
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new InitMultipartUploadResult());
    }

    @Override
    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new InitMultipartUploadResult(), cosXmlResultListener);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new ListPartsResult());
    }

    @Override
    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListPartsResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartResult());
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartResult(), cosXmlResultListener);
    }

    @Override
    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new AbortMultiUploadResult());
    }

    @Override
    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new AbortMultiUploadResult(), cosXmlResultListener);
    }

    @Override
    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, completeMultiUploadResult);
    }

    @Override
    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, completeMultiUploadResult, cosXmlResultListener);
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && cosXmlRequest.getHttpTask() != null) {
            cosXmlRequest.getHttpTask().cancel();
        }
    }

    @Override
    public void cancelAll() {
        List tasks = client.getTasksByTag(this.tag);
        for (HttpTask task : tasks) {
            task.cancel();
        }
    }

    @Override
    public void release() {
        this.cancelAll();
    }

    @Deprecated
    public String getAppid() {
        return this.config.getAppid();
    }

    @Deprecated
    public String getRegion() {
        return this.config.getRegion();
    }

    @Deprecated
    public String getRegion(CosXmlRequest cosXmlRequest) {
        return cosXmlRequest.getRegion() == null ? this.config.getRegion() : cosXmlRequest.getRegion();
    }

    public CosXmlServiceConfig getConfig() {
        return this.config;
    }

    public File[] getLogFiles(int limit) {
        FileLogAdapter fileLogAdapter;
        LogServerProxy logServerProxy = LogServerProxy.getInstance();
        if (logServerProxy != null && (fileLogAdapter = logServerProxy.getFileLogAdapter()) != null) {
            return fileLogAdapter.getLogFilesDesc(limit);
        }
        return null;
    }

    private boolean isRequestHasHeader(CosXmlRequest request, String key) {
        if (request == null || request.getRequestHeaders() == null) {
            return false;
        }
        return request.getRequestHeaders().containsKey(key);
    }
}

