/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class COSXMLUploadTask
extends COSXMLTask {
    protected long multiUploadSizeDivision;
    String srcPath;
    private long fileLength;
    private byte[] bytes;
    private InputStream inputStream;
    private Uri uri;
    private PutObjectRequest putObjectRequest;
    private boolean isSliceUpload = false;
    protected long sliceSize;
    private String uploadId;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private Object SYNC_UPLOAD_PART = new Object();
    private AtomicBoolean sendingCompleteRequest = new AtomicBoolean(false);
    private WeightStrategy weightStrategy = new WeightStrategy();
    private MultiUploadsStateListener multiUploadsStateListenerHandler = new MultiUploadsStateListener(){

        @Override
        public void onInit() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onListParts() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onUploadParts() {
            COSXMLUploadTask.this.completeMultiUpload(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onCompleted(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
            COSXMLUploadTask.this.updateState(TransferState.COMPLETED, null, cosXmlResult, false);
        }

        @Override
        public void onFailed(CosXmlRequest cosXmlRequest, CosXmlClientException exception, CosXmlServiceException serviceException) {
            Object causeException = exception == null ? serviceException : exception;
            COSXMLUploadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
        }
    };

    private COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath) {
        this.cosXmlService = cosXmlService;
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String srcPath, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.srcPath = srcPath;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, Uri uri, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.uri = uri;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, byte[] bytes) {
        this(cosXmlService, region, bucket, cosPath);
        this.bytes = bytes;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, InputStream inputStream) {
        this(cosXmlService, region, bucket, cosPath);
        this.inputStream = inputStream;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, PutObjectRequest putObjectRequest, String uploadId) {
        this(cosXmlService, putObjectRequest.getRegion(), putObjectRequest.getBucket(), putObjectRequest.getPath(cosXmlService.getConfig()));
        this.uri = putObjectRequest.getUri();
        this.srcPath = putObjectRequest.getSrcPath();
        this.bytes = putObjectRequest.getData();
        this.inputStream = putObjectRequest.getInputStream();
        this.queries = putObjectRequest.getQueryString();
        this.headers = putObjectRequest.getRequestHeaders();
        this.isNeedMd5 = putObjectRequest.isNeedMD5();
        this.uploadId = uploadId;
    }

    protected boolean checkParameter() {
        Context context;
        if (this.bytes == null && this.inputStream == null && this.srcPath == null && this.uri == null) {
            if (this.IS_EXIT.get()) {
                return false;
            }
            monitor.sendStateMessage(this, TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "source is is invalid: nulll")), null, 1);
            this.IS_EXIT.set(true);
            return false;
        }
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            if (!file.exists() || file.isDirectory() || !file.canRead()) {
                if (this.IS_EXIT.get()) {
                    return false;
                }
                monitor.sendStateMessage(this, TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "srcPath is is invalid: " + this.srcPath)), null, 1);
                this.IS_EXIT.set(true);
                return false;
            }
            this.fileLength = file.length();
        }
        if (this.uri != null && (context = ContextHolder.getAppContext()) != null) {
            this.fileLength = QCloudUtils.getUriContentLength((Uri)this.uri, (ContentResolver)context.getContentResolver());
        }
        return true;
    }

    protected void upload() {
        if (!this.checkParameter()) {
            return;
        }
        this.run();
    }

    private void dispatchProgressChange(long complete, long target) {
        if (this.cosXmlProgressListener != null) {
            this.cosXmlProgressListener.onProgress(complete, target);
        }
        if (this.internalProgressListener != null) {
            this.internalProgressListener.onProgress(complete, target);
        }
    }

    private void simpleUpload(CosXmlSimpleService cosXmlService) {
        this.putObjectRequest = this.bytes != null ? new PutObjectRequest(this.bucket, this.cosPath, this.bytes) : (this.inputStream != null ? new PutObjectRequest(this.bucket, this.cosPath, this.inputStream) : (this.uri != null ? new PutObjectRequest(this.bucket, this.cosPath, this.uri) : new PutObjectRequest(this.bucket, this.cosPath, this.srcPath)));
        this.putObjectRequest.setRegion(this.region);
        this.putObjectRequest.setNeedMD5(this.isNeedMd5);
        this.putObjectRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.putObjectRequest.setSign(this.onSignatureListener.onGetSign(this.putObjectRequest));
        }
        this.getHttpMetrics(this.putObjectRequest, "PutObjectRequest");
        this.putObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
            }
        });
        this.putObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                COSXMLUploadTask.this.dispatchProgressChange(complete, target);
            }
        });
        cosXmlService.putObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.putObjectRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.updateState(TransferState.COMPLETED, null, result, false);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.putObjectRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                Object causeException = exception == null ? serviceException : exception;
                COSXMLUploadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
            }
        });
    }

    private void multiUpload(CosXmlSimpleService cosXmlService) {
        this.initSlicePart(0L, this.fileLength, 1);
        if (!TextUtils.isEmpty((CharSequence)this.uploadId)) {
            this.listMultiUpload(cosXmlService);
        } else {
            this.initMultiUpload(cosXmlService);
        }
    }

    private void initMultiUpload(CosXmlSimpleService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        this.initMultipartUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.initMultipartUploadRequest.setSign(this.onSignatureListener.onGetSign(this.initMultipartUploadRequest));
        }
        this.getHttpMetrics(this.initMultipartUploadRequest, "InitMultipartUploadRequest");
        this.initMultipartUploadRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
            }
        });
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.initMultipartUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.uploadId = ((InitMultipartUploadResult)result).initMultipartUpload.uploadId;
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onInit();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.initMultipartUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void listMultiUpload(CosXmlSimpleService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        this.listPartsRequest.setRegion(this.region);
        this.listPartsRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.listPartsRequest.setSign(this.onSignatureListener.onGetSign(this.listPartsRequest));
        }
        this.getHttpMetrics(this.listPartsRequest, "ListPartsRequest");
        this.listPartsRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
            }
        });
        cosXmlService.listPartsAsync(this.listPartsRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.listPartsRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.updateSlicePart((ListPartsResult)result);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onListParts();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.listPartsRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void multiUploadPart(CosXmlSimpleService cosXmlService) {
        boolean isUploadFinished = true;
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = entry.getValue();
            if (slicePartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isUploadFinished = false;
            final UploadPartRequest uploadPartRequest = this.srcPath != null ? new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.srcPath, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId) : new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.uri, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            uploadPartRequest.setRegion(this.region);
            uploadPartRequest.setNeedMD5(this.isNeedMd5);
            uploadPartRequest.setRequestHeaders(this.headers);
            uploadPartRequest.setOnRequestWeightListener(new CosXmlRequest.OnRequestWeightListener(){

                @Override
                public int onWeight() {
                    return COSXMLUploadTask.this.weightStrategy.getWeight(COSXMLUploadTask.this.ALREADY_SEND_DATA_LEN.get());
                }
            });
            if (this.onSignatureListener != null) {
                uploadPartRequest.setSign(this.onSignatureListener.onGetSign(uploadPartRequest));
            }
            this.getHttpMetrics(uploadPartRequest, "UploadPartRequest");
            this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    try {
                        long dataLen = COSXMLUploadTask.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)COSXMLUploadTask.this.uploadPartRequestLongMap.get(uploadPartRequest));
                        COSXMLUploadTask.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                        COSXMLUploadTask.this.dispatchProgressChange(dataLen, COSXMLUploadTask.this.fileLength);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            cosXmlService.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    if (request != uploadPartRequest) {
                        return;
                    }
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    Object object = COSXMLUploadTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        COSXMLUploadTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (COSXMLUploadTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            COSXMLUploadTask.this.multiUploadsStateListenerHandler.onUploadParts();
                        }
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (request != uploadPartRequest) {
                        return;
                    }
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    COSXMLUploadTask.this.IS_EXIT.set(true);
                    COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
                }
            });
        }
        if (isUploadFinished && !this.IS_EXIT.get()) {
            this.dispatchProgressChange(this.fileLength, this.fileLength);
            this.multiUploadsStateListenerHandler.onUploadParts();
        }
    }

    private void completeMultiUpload(CosXmlSimpleService cosXmlService) {
        this.sendingCompleteRequest.set(true);
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        this.completeMultiUploadRequest.setRegion(this.region);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        this.completeMultiUploadRequest.setNeedMD5(this.isNeedMd5);
        this.completeMultiUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.completeMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(this.completeMultiUploadRequest));
        }
        this.getHttpMetrics(this.completeMultiUploadRequest, "CompleteMultiUploadRequest");
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.completeMultiUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onCompleted(request, result);
                COSXMLUploadTask.this.sendingCompleteRequest.set(false);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.completeMultiUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
                COSXMLUploadTask.this.sendingCompleteRequest.set(false);
            }
        });
    }

    @Override
    protected void internalCompleted() {
        this.clear();
    }

    @Override
    protected void internalFailed() {
        this.cancelAllRequest(this.cosXmlService);
    }

    @Override
    protected void internalPause() {
        this.cancelAllRequest(this.cosXmlService);
    }

    public boolean pauseSafely() {
        if (this.sendingCompleteRequest.get()) {
            return false;
        }
        this.pause();
        return true;
    }

    @Override
    protected void internalCancel() {
        this.cancelAllRequest(this.cosXmlService);
        if (this.isSliceUpload) {
            this.abortMultiUpload(this.cosXmlService);
        }
        this.clear();
    }

    @Override
    protected void internalResume() {
        this.taskState = TransferState.WAITING;
        this.IS_EXIT.set(false);
        this.upload();
    }

    void cancelAllRequest(CosXmlSimpleService cosXmlService) {
        CompleteMultiUploadRequest tempCompleteMultiUploadRequest;
        ListPartsRequest tempListPartsRequest;
        InitMultipartUploadRequest tempInitMultipartUploadRequest;
        PutObjectRequest tempPutObjectRequest = this.putObjectRequest;
        if (tempPutObjectRequest != null) {
            cosXmlService.cancel(tempPutObjectRequest);
        }
        if ((tempInitMultipartUploadRequest = this.initMultipartUploadRequest) != null) {
            cosXmlService.cancel(tempInitMultipartUploadRequest);
        }
        if ((tempListPartsRequest = this.listPartsRequest) != null) {
            cosXmlService.cancel(tempListPartsRequest);
        }
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                cosXmlService.cancel(iterator.next());
            }
        }
        if ((tempCompleteMultiUploadRequest = this.completeMultiUploadRequest) != null) {
            cosXmlService.cancel(tempCompleteMultiUploadRequest);
        }
    }

    private void abortMultiUpload(CosXmlSimpleService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        abortMultiUploadRequest.setRegion(this.region);
        if (this.onSignatureListener != null) {
            abortMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(abortMultiUploadRequest));
        }
        this.getHttpMetrics(abortMultiUploadRequest, "AbortMultiUploadRequest");
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    private void clear() {
        if (this.uploadPartRequestLongMap != null) {
            this.uploadPartRequestLongMap.clear();
        }
        if (this.partStructMap != null) {
            this.partStructMap.clear();
        }
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest() {
        COSXMLUploadTaskRequest cosxmlUploadTaskRequest = new COSXMLUploadTaskRequest(this.region, this.bucket, this.cosPath, this.srcPath, this.headers, this.queries);
        return cosxmlUploadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLUploadTaskResult cosxmlUploadTaskResult = new COSXMLUploadTaskResult();
        if (sourceResult != null && sourceResult instanceof PutObjectResult) {
            PutObjectResult putObjectResult = (PutObjectResult)sourceResult;
            cosxmlUploadTaskResult.httpCode = putObjectResult.httpCode;
            cosxmlUploadTaskResult.httpMessage = putObjectResult.httpMessage;
            cosxmlUploadTaskResult.headers = putObjectResult.headers;
            cosxmlUploadTaskResult.eTag = putObjectResult.eTag;
            cosxmlUploadTaskResult.accessUrl = putObjectResult.accessUrl;
        } else if (sourceResult != null && sourceResult instanceof CompleteMultiUploadResult) {
            CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)sourceResult;
            cosxmlUploadTaskResult.httpCode = completeMultiUploadResult.httpCode;
            cosxmlUploadTaskResult.httpMessage = completeMultiUploadResult.httpMessage;
            cosxmlUploadTaskResult.headers = completeMultiUploadResult.headers;
            cosxmlUploadTaskResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
            cosxmlUploadTaskResult.accessUrl = completeMultiUploadResult.accessUrl;
        }
        return cosxmlUploadTaskResult;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    private void initSlicePart(long fileOffset, long uploadSize, int startNumber) {
        int count = (int)(uploadSize / this.sliceSize);
        for (int numberOffset = 0; numberOffset < count; ++numberOffset) {
            SlicePartStruct slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = startNumber + numberOffset;
            slicePartStruct.offset = fileOffset + (long)numberOffset * this.sliceSize;
            slicePartStruct.sliceSize = this.sliceSize;
            this.partStructMap.put(slicePartStruct.partNumber, slicePartStruct);
        }
        if (uploadSize % this.sliceSize != 0L) {
            SlicePartStruct slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = startNumber + count;
            slicePartStruct.offset = fileOffset + (long)count * this.sliceSize;
            slicePartStruct.sliceSize = fileOffset + uploadSize - slicePartStruct.offset;
            this.partStructMap.put(slicePartStruct.partNumber, slicePartStruct);
            ++count;
        }
        this.UPLOAD_PART_COUNT.set(startNumber + count - 1);
        if (this.IS_EXIT.get()) {
            return;
        }
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        block6: {
            List<ListParts.Part> parts;
            if (listPartsResult == null || listPartsResult.listParts == null || (parts = listPartsResult.listParts.parts) == null || parts.size() <= 0) break block6;
            if (this.isFixSliceSize(parts)) {
                for (ListParts.Part part : parts) {
                    if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                    SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                    slicePartStruct.isAlreadyUpload = true;
                    slicePartStruct.eTag = part.eTag;
                    this.UPLOAD_PART_COUNT.decrementAndGet();
                    this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
                }
            } else {
                int i;
                Collections.sort(parts, new Comparator<ListParts.Part>(){

                    @Override
                    public int compare(ListParts.Part a, ListParts.Part b) {
                        int bNumb;
                        int aNumb = Integer.valueOf(a.partNumber);
                        if (aNumb > (bNumb = Integer.valueOf(b.partNumber).intValue())) {
                            return 1;
                        }
                        if (aNumb < bNumb) {
                            return -1;
                        }
                        return 0;
                    }
                });
                int index = this.getIndexOfParts(parts);
                if (index < 0) {
                    return;
                }
                this.partStructMap.clear();
                long completed = 0L;
                for (i = 0; i <= index; ++i) {
                    ListParts.Part part = parts.get(i);
                    SlicePartStruct slicePartStruct = new SlicePartStruct();
                    slicePartStruct.partNumber = i + 1;
                    slicePartStruct.offset = completed;
                    slicePartStruct.sliceSize = Long.parseLong(part.size);
                    slicePartStruct.eTag = part.eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    completed += slicePartStruct.sliceSize;
                    this.partStructMap.put(i + 1, slicePartStruct);
                }
                this.ALREADY_SEND_DATA_LEN.addAndGet(completed);
                this.initSlicePart(completed, this.fileLength - completed, index + 2);
                for (i = 0; i <= index; ++i) {
                    this.UPLOAD_PART_COUNT.decrementAndGet();
                }
            }
        }
    }

    private boolean isFixSliceSize(List<ListParts.Part> parts) {
        boolean isTrue = true;
        for (ListParts.Part part : parts) {
            if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
            SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
            if (slicePartStruct.sliceSize == Long.valueOf(part.size)) continue;
            isTrue = false;
            break;
        }
        return isTrue;
    }

    private int getIndexOfParts(List<ListParts.Part> parts) {
        int index = -1;
        int currentPartNumber = 1;
        ListParts.Part firstPart = parts.get(0);
        if (Integer.valueOf(firstPart.partNumber) != 1) {
            return index;
        }
        index = 0;
        int i = 1;
        int size = parts.size();
        while (i < size) {
            ListParts.Part tmp = parts.get(i);
            if (Integer.valueOf(tmp.partNumber) != currentPartNumber + 1) break;
            index = i++;
            currentPartNumber = Integer.valueOf(tmp.partNumber);
        }
        return index;
    }

    protected void run() {
        if (this.bytes != null || this.inputStream != null) {
            this.simpleUpload(this.cosXmlService);
            return;
        }
        if (this.fileLength < this.multiUploadSizeDivision) {
            this.simpleUpload(this.cosXmlService);
        } else {
            this.isSliceUpload = true;
            this.UPLOAD_PART_COUNT = new AtomicInteger(0);
            this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
            this.partStructMap = new LinkedHashMap<Integer, SlicePartStruct>();
            this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
            this.multiUpload(this.cosXmlService);
        }
    }

    @Override
    public void resume() {
        if (this.inputStream != null) {
            if (this.IS_EXIT.get()) {
                return;
            }
            this.IS_EXIT.set(true);
            this.multiUploadsStateListenerHandler.onFailed(this.buildCOSXMLTaskRequest(), new CosXmlClientException(ClientErrorCode.SINK_SOURCE_NOT_FOUND.getCode(), "inputStream closed"), null);
            return;
        }
        super.resume();
    }

    public boolean getSendingCompleteRequest() {
        return this.sendingCompleteRequest.get();
    }

    public static class COSXMLUploadTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLUploadTaskResult() {
        }
    }

    public static class COSXMLUploadTaskRequest
    extends PutObjectRequest {
        protected COSXMLUploadTaskRequest(String region, String bucket, String cosPath, String srcPath, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, srcPath);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }

    private static interface MultiUploadsStateListener {
        public void onInit();

        public void onListParts();

        public void onUploadParts();

        public void onCompleted(CosXmlRequest var1, CosXmlResult var2);

        public void onFailed(CosXmlRequest var1, CosXmlClientException var2, CosXmlServiceException var3);
    }

    private static class WeightStrategy {
        private final long DEFAULT_WEIGHT_NORMAL_SIZE = 0x5000000L;
        private final long DEFAULT_WEIGHT_HIGH_SIZE = 0x9600000L;
        private long normalSize = 0x5000000L;
        private long highSize = 0x9600000L;

        private WeightStrategy() {
        }

        private int getWeight(long size) {
            if (size > this.highSize) {
                return 2;
            }
            if (size > this.normalSize) {
                return 1;
            }
            return 0;
        }
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }
}

