/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tencent.cos.xml.common.VersionInfo;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.task.RetryStrategy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CosXmlServiceConfig
implements Parcelable {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String ACCELERATE_ENDPOINT_SUFFIX = "cos.accelerate";
    public static final String DEFAULT_HOST_FORMAT = "${bucket}.cos.${region}.myqcloud.com";
    public static final String ACCELERATE_HOST_FORMAT = "${bucket}.cos.accelerate.myqcloud.com";
    public static final String PATH_STYLE_HOST_FORMAT = "cos.${region}.myqcloud.com";
    public static final String CI_HOST_FORMAT = "${bucket}.ci.${region}.myqcloud.com";
    public static final String PIC_HOST_FORMAT = "${bucket}.pic.${region}.myqcloud.com";
    public static final String DEFAULT_USER_AGENT = VersionInfo.getUserAgent();
    private String protocol;
    private String userAgent;
    private String region;
    private String appid;
    private String host;
    private int port;
    private String endpointSuffix;
    private boolean isDebuggable;
    private RetryStrategy retryStrategy;
    private QCloudHttpRetryHandler qCloudHttpRetryHandler;
    private int connectionTimeout;
    private int socketTimeout;
    private Executor executor;
    private Executor observeExecutor;
    private boolean isQuic;
    private List<String> prefetchHosts;
    private Map<String, List<String>> commonHeaders;
    private List<String> noSignHeaders;
    private boolean dnsCache;
    private String hostFormat = "${bucket}.cos.${region}.myqcloud.com";
    private String hostHeaderFormat = null;
    private boolean bucketInPath;
    private boolean accelerate;
    private boolean signInUrl;
    public static final Parcelable.Creator<CosXmlServiceConfig> CREATOR = new Parcelable.Creator<CosXmlServiceConfig>(){

        public CosXmlServiceConfig createFromParcel(Parcel in) {
            return new CosXmlServiceConfig(in);
        }

        public CosXmlServiceConfig[] newArray(int size) {
            return new CosXmlServiceConfig[size];
        }
    };

    public CosXmlServiceConfig(Builder builder) {
        this.protocol = builder.protocol;
        this.userAgent = builder.userAgent;
        this.isDebuggable = builder.isDebuggable;
        this.appid = builder.appid;
        this.region = builder.region;
        this.host = builder.host;
        this.port = builder.port;
        this.endpointSuffix = builder.endpointSuffix;
        this.bucketInPath = builder.bucketInPath;
        this.commonHeaders = builder.commonHeaders;
        this.noSignHeaders = builder.noSignHeaders;
        if (TextUtils.isEmpty((CharSequence)this.hostFormat) && TextUtils.isEmpty((CharSequence)this.region) && TextUtils.isEmpty((CharSequence)this.host)) {
            throw new IllegalArgumentException("please set host or endpointSuffix or region !");
        }
        this.retryStrategy = builder.retryStrategy;
        this.qCloudHttpRetryHandler = builder.qCloudHttpRetryHandler;
        this.socketTimeout = builder.socketTimeout;
        this.connectionTimeout = builder.connectionTimeout;
        this.hostFormat = builder.hostFormat;
        this.hostHeaderFormat = builder.hostHeaderFormat;
        this.executor = builder.executor;
        this.observeExecutor = builder.observeExecutor;
        this.isQuic = builder.isQuic;
        this.accelerate = builder.accelerate;
        this.dnsCache = builder.dnsCache;
        this.signInUrl = builder.signInUrl;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket(String bucket) {
        return this.getBucket(bucket, this.appid);
    }

    public String getBucket(String bucket, String appid) {
        String myBucket = bucket;
        if (bucket != null && !bucket.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
            myBucket = bucket + "-" + appid;
        }
        return myBucket;
    }

    public List<String> getNoSignHeaders() {
        return this.noSignHeaders;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getRequestHost(String bucket, boolean accelerate) {
        return this.getRequestHost(null, bucket, accelerate);
    }

    public String getRequestHost(String region, String bucket, boolean accelerate) {
        accelerate = accelerate || this.accelerate;
        boolean pathStyle = this.bucketInPath;
        return this.getRequestHost(region, bucket, this.getHostFormat(accelerate, pathStyle));
    }

    public String getRequestHost(String region, String bucket, String hostFormat) {
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        region = TextUtils.isEmpty((CharSequence)region) ? this.region : region;
        bucket = this.getBucket(bucket, this.appid);
        return this.getFormatHost(hostFormat, region, bucket);
    }

    public String getHeaderHost(String region, String bucket) {
        if (this.hostHeaderFormat != null) {
            return this.getFormatHost(this.hostHeaderFormat, region, bucket);
        }
        return "";
    }

    public boolean isSignInUrl() {
        return this.signInUrl;
    }

    @Deprecated
    public String getDefaultRequestHost(String region, String bucket, String appid) {
        return this.getDefaultRequestHost(region, this.getBucket(bucket, appid));
    }

    public String getDefaultRequestHost(String region, String bucket) {
        return this.getFormatHost(DEFAULT_HOST_FORMAT, region, bucket);
    }

    private String getFormatHost(String hostFormat, String region, String bucket) {
        return hostFormat.replace("${bucket}", bucket).replace("${region}", region);
    }

    private String getHostFormat(boolean accelerate, boolean pathStyle) {
        if (!TextUtils.isEmpty((CharSequence)this.hostFormat)) {
            return this.hostFormat;
        }
        String hostFormat = DEFAULT_HOST_FORMAT;
        if (accelerate) {
            hostFormat = ACCELERATE_HOST_FORMAT;
        } else if (pathStyle) {
            hostFormat = PATH_STYLE_HOST_FORMAT;
        }
        if (this.endpointSuffix != null) {
            String string = hostFormat = this.bucketInPath ? this.endpointSuffix : "${bucket}.".concat(this.endpointSuffix);
            if (accelerate) {
                hostFormat = hostFormat.replace("cos.${region}", ACCELERATE_ENDPOINT_SUFFIX);
            }
        }
        return hostFormat;
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getHost(String bucket, boolean isSupportAccelerate) {
        return this.getHost(bucket, null, isSupportAccelerate);
    }

    @Deprecated
    public String getHost(String bucket, String region, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate);
    }

    @Deprecated
    public String getHost(String bucket, String region, boolean isSupportAccelerate, boolean isHeader) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate, isHeader);
    }

    @Deprecated
    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate, boolean isHeader) {
        if (!isHeader && !TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        String myBucket = this.getBucket(bucket, appId);
        String hostBuilder = "";
        if (!this.bucketInPath) {
            hostBuilder = hostBuilder + myBucket + ".";
        }
        hostBuilder = hostBuilder + this.getEndpointSuffix(region, isSupportAccelerate);
        return hostBuilder;
    }

    @Deprecated
    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, appId, isSupportAccelerate, false);
    }

    public boolean isDnsCache() {
        return this.dnsCache;
    }

    public Map<String, List<String>> getCommonHeaders() {
        return this.commonHeaders;
    }

    @Deprecated
    public String getEndpointSuffix() {
        return this.getEndpointSuffix(this.region, false);
    }

    @Deprecated
    public String getEndpointSuffix(String region, boolean isSupportAccelerate) {
        String myRegion = TextUtils.isEmpty((CharSequence)region) ? this.getRegion() : region;
        String myEndpointSuffix = this.endpointSuffix;
        if (this.endpointSuffix == null && myRegion != null) {
            myEndpointSuffix = "cos." + myRegion + ".myqcloud.com";
        }
        if ((myEndpointSuffix = this.substituteEndpointSuffix(myEndpointSuffix, myRegion)) != null && isSupportAccelerate) {
            myEndpointSuffix = myEndpointSuffix.replace("cos." + myRegion, ACCELERATE_ENDPOINT_SUFFIX);
        }
        return myEndpointSuffix;
    }

    private String substituteEndpointSuffix(String formatString, String region) {
        if (!TextUtils.isEmpty((CharSequence)formatString) && region != null) {
            return formatString.replace("${region}", region);
        }
        return formatString;
    }

    public String getUrlPath(String bucket, String cosPath) {
        StringBuilder path = new StringBuilder();
        if (this.bucketInPath) {
            String myBucket = bucket;
            if (!bucket.endsWith("-" + this.appid) && !TextUtils.isEmpty((CharSequence)this.appid)) {
                myBucket = bucket + "-" + this.appid;
            }
            path.append("/").append(myBucket);
        }
        if (cosPath != null && !cosPath.startsWith("/")) {
            path.append("/").append(cosPath);
        } else {
            path.append(cosPath);
        }
        return path.toString();
    }

    private boolean isEndWithV4Appid(String bucket) {
        String appid = this.extractAppidFromBucket(bucket);
        return this.isCosV4Appid(appid);
    }

    private String extractAppidFromBucket(String bucket) {
        if (bucket == null || !bucket.contains("-") || bucket.endsWith("-")) {
            return "";
        }
        int index = bucket.lastIndexOf("-");
        return bucket.substring(index + 1);
    }

    private boolean isCosV4Appid(String appid) {
        if (appid == null || appid.length() != 8 || !appid.startsWith("100")) {
            return false;
        }
        try {
            Long.valueOf(appid);
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public QCloudHttpRetryHandler getQCloudHttpRetryHandler() {
        return this.qCloudHttpRetryHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Executor getObserveExecutor() {
        return this.observeExecutor;
    }

    public boolean isEnableQuic() {
        return this.isQuic;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.protocol);
        dest.writeString(this.region);
        dest.writeInt(this.isDebuggable ? 1 : 0);
    }

    private CosXmlServiceConfig(Parcel in) {
        this(new Builder().isHttps(HTTPS_PROTOCOL.equals(in.readString())).setRegion(in.readString()).setDebuggable(in.readInt() == 1));
    }

    public static final class Builder {
        private String protocol;
        private String userAgent;
        private String region;
        private String appid;
        private String host;
        private int port = -1;
        private String endpointSuffix;
        private boolean bucketInPath;
        private boolean isDebuggable;
        private RetryStrategy retryStrategy;
        private QCloudHttpRetryHandler qCloudHttpRetryHandler;
        private int connectionTimeout = 15000;
        private int socketTimeout = 30000;
        private Executor executor;
        private Executor observeExecutor;
        private boolean isQuic = false;
        private boolean dnsCache = true;
        private Map<String, List<String>> commonHeaders = new HashMap<String, List<String>>();
        private List<String> noSignHeaders = new LinkedList<String>();
        private String hostFormat;
        private String hostHeaderFormat;
        private boolean accelerate;
        private boolean signInUrl;

        public Builder() {
            this.protocol = CosXmlServiceConfig.HTTPS_PROTOCOL;
            this.userAgent = DEFAULT_USER_AGENT;
            this.isDebuggable = false;
            this.retryStrategy = RetryStrategy.DEFAULT;
            this.bucketInPath = false;
        }

        public Builder(CosXmlServiceConfig config) {
            this.protocol = config.protocol;
            this.userAgent = DEFAULT_USER_AGENT;
            this.region = config.region;
            this.appid = config.appid;
            this.host = config.host;
            this.port = config.port;
            this.endpointSuffix = config.endpointSuffix;
            this.bucketInPath = config.bucketInPath;
            this.isDebuggable = config.isDebuggable;
            this.retryStrategy = config.retryStrategy;
            this.qCloudHttpRetryHandler = config.qCloudHttpRetryHandler;
            this.connectionTimeout = config.connectionTimeout;
            this.socketTimeout = config.socketTimeout;
            this.executor = config.executor;
            this.observeExecutor = config.observeExecutor;
            this.isQuic = config.isQuic;
            this.dnsCache = config.dnsCache;
            this.commonHeaders = config.commonHeaders;
            this.noSignHeaders = config.noSignHeaders;
            this.hostFormat = config.hostFormat;
            this.hostHeaderFormat = config.hostHeaderFormat;
            this.accelerate = config.accelerate;
            this.signInUrl = config.signInUrl;
        }

        public Builder setConnectionTimeout(int connectionTimeoutMills) {
            this.connectionTimeout = connectionTimeoutMills;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeoutMills) {
            this.socketTimeout = socketTimeoutMills;
            return this;
        }

        public Builder isHttps(boolean isHttps) {
            this.protocol = isHttps ? CosXmlServiceConfig.HTTPS_PROTOCOL : CosXmlServiceConfig.HTTP_PROTOCOL;
            return this;
        }

        public Builder setHostFormat(String hostFormat) {
            this.hostFormat = hostFormat;
            return this;
        }

        @Deprecated
        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        @Deprecated
        public Builder setEndpointSuffix(String endpointSuffix) {
            this.endpointSuffix = endpointSuffix;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setHost(Uri uri) {
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            this.protocol = uri.getScheme();
            return this;
        }

        public Builder setDebuggable(boolean isDebuggable) {
            this.isDebuggable = isDebuggable;
            return this;
        }

        public Builder setSignInUrl(boolean signInUrl) {
            this.signInUrl = signInUrl;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setRetryHandler(QCloudHttpRetryHandler qCloudHttpRetryHandler) {
            this.qCloudHttpRetryHandler = qCloudHttpRetryHandler;
            return this;
        }

        @Deprecated
        public Builder setBucketInPath(boolean bucketInPath) {
            this.bucketInPath = bucketInPath;
            return this;
        }

        public Builder setPathStyle(boolean pathStyle) {
            this.bucketInPath = pathStyle;
            return this;
        }

        public Builder setExecutor(Executor excutor) {
            this.executor = excutor;
            return this;
        }

        public Builder setObserveExecutor(Executor observeExecutor) {
            this.observeExecutor = observeExecutor;
            return this;
        }

        public Builder enableQuic(boolean isEnable) {
            this.isQuic = isEnable;
            this.userAgent = VersionInfo.getQuicUserAgent();
            return this;
        }

        public Builder dnsCache(boolean dnsCache) {
            this.dnsCache = dnsCache;
            return this;
        }

        public Builder setAccelerate(boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }

        public Builder addHeader(String key, String value) {
            List<String> values = this.commonHeaders.get(key);
            if (values == null) {
                values = new LinkedList<String>();
            }
            values.add(value);
            this.commonHeaders.put(key, values);
            return this;
        }

        public Builder addNoSignHeaders(String key) {
            this.noSignHeaders.add(key);
            return this;
        }
    }
}

