/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

public class MTAProxy {
    private static final String TAG = "MTAProxy";
    private final String className = "com.tencent.qcloud.mtaUtils.MTAServer";
    private Object mtaServer;
    private Method reportFailedEvent;
    private Method reportSendEvent;
    private Context applicationContext;
    private static MTAProxy instance;

    private MTAProxy(Context applicationContext) {
        this.applicationContext = applicationContext;
        try {
            Class<?> cls = Class.forName("com.tencent.qcloud.mtaUtils.MTAServer");
            Constructor<?> constructor = cls.getConstructor(Context.class, String.class);
            if (constructor != null) {
                this.mtaServer = constructor.newInstance(this.applicationContext, "5.5.5");
            }
            this.reportFailedEvent = cls.getDeclaredMethod("reportFailedEvent", String.class, String.class);
            if (this.reportFailedEvent != null) {
                this.reportFailedEvent.setAccessible(true);
            }
            this.reportSendEvent = cls.getDeclaredMethod("reportSendEvent", String.class);
            if (this.reportSendEvent != null) {
                this.reportSendEvent.setAccessible(true);
            }
        }
        catch (ClassNotFoundException e) {
            QCloudLogger.d((String)TAG, (String)"com.tencent.qcloud.mtaUtils.MTAServer : not found", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InstantiationException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext) {
        Class<MTAProxy> clazz = MTAProxy.class;
        synchronized (MTAProxy.class) {
            if (instance == null) {
                instance = new MTAProxy(applicationContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static MTAProxy getInstance() {
        return instance;
    }

    public CosXmlClientException reportXmlClientException(Object cosXmlRequest, QCloudClientException e) {
        CosXmlClientException xmlClientException;
        if (e instanceof CosXmlClientException) {
            xmlClientException = (CosXmlClientException)e;
        } else {
            Throwable causeException = e.getCause();
            if (causeException instanceof IllegalArgumentException) {
                xmlClientException = new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
            } else if (causeException instanceof QCloudAuthenticationException) {
                xmlClientException = new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), e);
            } else if (causeException instanceof IOException) {
                ClientErrorCode code = causeException instanceof FileNotFoundException ? ClientErrorCode.SINK_SOURCE_NOT_FOUND : (QCloudHttpUtils.isNetworkConditionException((Throwable)causeException) ? ClientErrorCode.POOR_NETWORK : ClientErrorCode.IO_ERROR);
                xmlClientException = new CosXmlClientException(code.getCode(), e);
            } else {
                xmlClientException = new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
            }
        }
        String reportMessage = String.format(Locale.ENGLISH, "%d %s", xmlClientException.errorCode, e.getCause() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getCause().getClass().getSimpleName());
        this.reportErrorAction(cosXmlRequest.getClass().getSimpleName(), reportMessage, (Exception)((Object)xmlClientException));
        return xmlClientException;
    }

    public CosXmlServiceException reportXmlServerException(Object cosXmlRequest, QCloudServiceException e) {
        CosXmlServiceException serviceException = e instanceof CosXmlServiceException ? (CosXmlServiceException)e : new CosXmlServiceException(e);
        this.reportErrorAction(cosXmlRequest.getClass().getSimpleName(), serviceException.getStatusCode() + " " + serviceException.getErrorCode(), (Exception)((Object)serviceException));
        return serviceException;
    }

    private void reportErrorAction(String requestClassName, String errorMsg, Exception ex) {
        if (this.mtaServer != null && this.reportFailedEvent != null && this.isRequestNeedReport(requestClassName) && this.isExceptionInterested(ex)) {
            try {
                this.reportFailedEvent.invoke(this.mtaServer, requestClassName, errorMsg);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportSendAction(String requestClassName) {
        if (this.mtaServer != null && this.reportSendEvent != null && this.isRequestNeedReport(requestClassName)) {
            try {
                this.reportSendEvent.invoke(this.mtaServer, requestClassName);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    private boolean isRequestNeedReport(String requestClassName) {
        return Arrays.asList("HeadObjectRequest", "PutObjectRequest", "GetObjectRequest", "UploadPartRequest", "UploadPartCopyRequest", "CopyObjectRequest").contains(requestClassName);
    }

    private boolean isExceptionInterested(Exception ex) {
        if (ex instanceof CosXmlClientException) {
            int errorCode = ((CosXmlClientException)((Object)ex)).errorCode;
            return errorCode == ClientErrorCode.POOR_NETWORK.getCode() || errorCode == ClientErrorCode.SERVERERROR.getCode() || errorCode == ClientErrorCode.INTERNAL_ERROR.getCode();
        }
        if (ex instanceof CosXmlServiceException) {
            String serverCode = ((CosXmlServiceException)((Object)ex)).getErrorCode();
            return Arrays.asList("InvalidDigest", "BadDigest", "InvalidSHA1Digest", "RequestTimeOut").contains(serverCode);
        }
        return false;
    }
}

