/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import com.tencent.cos.xml.CosXml;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.utils.SharePreferenceUtils;
import java.io.File;
import java.util.List;

@Deprecated
public class Downloader {
    private CosXml cosXmlServer;
    private String bucket;
    private String cosPath;
    private String localPath;
    private String localFileName;
    private long rangeStart = 0L;
    private ListenerHandler listenerHandler = new ListenerHandler();
    private GetObjectRequest getObjectRequest;
    private SharePreferenceUtils sharePreferedUtils;

    public Downloader(Context appContext, CosXml cosXmlServer) {
        this.sharePreferedUtils = SharePreferenceUtils.instance(appContext);
        this.cosXmlServer = cosXmlServer;
    }

    public void setProgress(CosXmlProgressListener cosXmlProgressListener) {
        this.listenerHandler.setCosXmlProgressListener(cosXmlProgressListener);
    }

    public GetObjectResult download(String bucket, String cosPath, String localPath, String localFileName) throws CosXmlClientException, CosXmlServiceException {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.localPath = localPath;
        this.localFileName = localFileName;
        this.checkParameters();
        HeadObjectRequest headObjectRequest = new HeadObjectRequest(bucket, cosPath);
        HeadObjectResult headObjectResult = this.cosXmlServer.headObject(headObjectRequest);
        List realEtags = (List)headObjectResult.headers.get("ETag");
        String realEtag = null;
        if (realEtags != null && realEtags.size() > 0) {
            realEtag = (String)realEtags.get(0);
        }
        this.getObjectRequest = new GetObjectRequest(bucket, cosPath, localPath, localFileName);
        this.rangeStart = 0L;
        String realLocalPath = this.getObjectRequest.getDownloadPath();
        if (realEtag != null) {
            String sourceEtag = this.sharePreferedUtils.getValue(realLocalPath);
            if (sourceEtag == null || !realEtag.equals(sourceEtag)) {
                this.sharePreferedUtils.updateValue(realLocalPath, realEtag);
            } else {
                this.rangeStart = this.getRange(realLocalPath);
            }
        }
        this.getObjectRequest.setRange(this.rangeStart);
        this.getObjectRequest.setProgressListener(this.listenerHandler);
        GetObjectResult getObjectResult = this.cosXmlServer.getObject(this.getObjectRequest);
        this.sharePreferedUtils.clear(realLocalPath);
        return getObjectResult;
    }

    public void download(String bucket, String cosPath, String localPath, String localFileName, CosXmlResultListener cosXmlResultListener) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.localPath = localPath;
        this.localFileName = localFileName;
        this.listenerHandler.setCosXmlResultListener(cosXmlResultListener);
        try {
            this.checkParameters();
        }
        catch (CosXmlClientException e) {
            this.listenerHandler.onFail(this.getObjectRequest, e, null);
            return;
        }
        this.getObjectRequest = new GetObjectRequest(bucket, cosPath, localPath, localFileName);
        HeadObjectRequest headObjectRequest = new HeadObjectRequest(bucket, cosPath);
        this.cosXmlServer.headObjectAsync(headObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                HeadObjectResult headObjectResult = (HeadObjectResult)result;
                List realEtags = (List)headObjectResult.headers.get("ETag");
                String realEtag = null;
                if (realEtags != null && realEtags.size() > 0) {
                    realEtag = (String)realEtags.get(0);
                }
                Downloader.this.rangeStart = 0L;
                String realLocalPath = Downloader.this.getObjectRequest.getDownloadPath();
                if (realEtag != null) {
                    String sourceEtag = Downloader.this.sharePreferedUtils.getValue(realLocalPath);
                    if (sourceEtag == null || !realEtag.equals(sourceEtag)) {
                        Downloader.this.sharePreferedUtils.updateValue(realLocalPath, realEtag);
                    } else {
                        Downloader.this.rangeStart = Downloader.this.getRange(realLocalPath);
                    }
                }
                Downloader.this.getObjectRequest.setRange(Downloader.this.rangeStart);
                Downloader.this.getObjectRequest.setProgressListener(Downloader.this.listenerHandler);
                Downloader.this.cosXmlServer.getObjectAsync(Downloader.this.getObjectRequest, Downloader.this.listenerHandler);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                Downloader.this.listenerHandler.onFail(Downloader.this.getObjectRequest, exception, serviceException);
            }
        });
    }

    public void cancel() {
        if (this.getObjectRequest != null && this.cosXmlServer != null) {
            this.cosXmlServer.cancel(this.getObjectRequest);
        }
    }

    private long getRange(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    private void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket must not be null ");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosPath must not be null ");
        }
        if (this.localPath == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "localPath must not be null ");
        }
    }

    private class ListenerHandler
    implements CosXmlProgressListener,
    CosXmlResultListener {
        private CosXmlProgressListener cosXmlProgressListener;
        private CosXmlResultListener cosXmlResultListener;

        public void setCosXmlProgressListener(CosXmlProgressListener cosXmlProgressListener) {
            this.cosXmlProgressListener = cosXmlProgressListener;
        }

        public void setCosXmlResultListener(CosXmlResultListener cosXmlResultListener) {
            this.cosXmlResultListener = cosXmlResultListener;
        }

        public void onProgress(long complete, long target) {
            if (this.cosXmlProgressListener != null) {
                this.cosXmlProgressListener.onProgress(Downloader.this.rangeStart + complete, Downloader.this.rangeStart + target);
            }
        }

        @Override
        public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            Downloader.this.sharePreferedUtils.clear(Downloader.this.getObjectRequest.getDownloadPath());
            if (this.cosXmlResultListener != null) {
                this.cosXmlResultListener.onSuccess(request, result);
            }
        }

        @Override
        public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            if (this.cosXmlResultListener != null) {
                this.cosXmlResultListener.onFail(request, exception, serviceException);
            }
        }
    }
}

