/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.pic.PicObject;
import com.tencent.cos.xml.model.tag.pic.PicOriginalInfo;
import com.tencent.cos.xml.model.tag.pic.PicUploadResult;
import com.tencent.qcloud.core.http.HttpResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class PutObjectResult
extends CosXmlResult {
    public String eTag;
    private String body;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        this.eTag = response.header("ETag");
        try {
            this.body = response.string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public PicUploadResult picUploadResult() {
        if (TextUtils.isEmpty((CharSequence)this.body)) {
            return null;
        }
        try {
            return this.parseUploadResult(new JSONObject(this.body));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private PicUploadResult parseUploadResult(JSONObject uploadResult) throws JSONException {
        if (uploadResult == null) {
            return null;
        }
        PicOriginalInfo originalInfo = this.parseOriginalInfo(uploadResult.getJSONObject("OriginalInfo"));
        List<PicObject> processResults = this.parseProcessResults(uploadResult.getJSONArray("ProcessResults"));
        return new PicUploadResult(originalInfo, processResults);
    }

    private PicOriginalInfo parseOriginalInfo(JSONObject originalInfo) {
        if (originalInfo == null) {
            return null;
        }
        try {
            String key = originalInfo.getString("Key");
            String location = originalInfo.getString("Location");
            return new PicOriginalInfo(key, location);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<PicObject> parseProcessResults(JSONArray processResults) {
        if (processResults == null) {
            return null;
        }
        LinkedList<PicObject> objects = new LinkedList<PicObject>();
        for (int i = 0; i < processResults.length(); ++i) {
            try {
                JSONObject result = processResults.getJSONObject(0);
                String key = result.getString("Key");
                String location = result.getString("Location");
                String format = result.getString("Format");
                int width = result.getInt("Width");
                int height = result.getInt("Height");
                int size = result.getInt("Size");
                int quality = result.getInt("Quality");
                objects.add(new PicObject(key, location, format, width, height, size, quality));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return objects;
    }
}

