/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import java.util.Map;

public class UploadPartCopyRequest
extends CopyObjectRequest {
    private int partNumber = -1;
    private String uploadId = null;

    public UploadPartCopyRequest(String bucket, String cosPath, int partNumber, String uploadId, CopyObjectRequest.CopySourceStruct copySourceStruct) throws CosXmlClientException {
        this(bucket, cosPath, partNumber, uploadId, copySourceStruct, -1L, -1L);
    }

    public UploadPartCopyRequest(String bucket, String cosPath, int partNumber, String uploadId, CopyObjectRequest.CopySourceStruct copySourceStruct, long start, long end) throws CosXmlClientException {
        super(bucket, cosPath, copySourceStruct);
        this.partNumber = partNumber;
        this.uploadId = uploadId;
        this.setCopyRange(start, end);
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("partNumber", String.valueOf(this.partNumber));
        this.queryParameters.put("uploadId", this.uploadId);
        return super.getQueryString();
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.partNumber <= 0) {
            throw new CosXmlClientException("partNumber must be >= 1");
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException("uploadID must not be null");
        }
    }

    public void setCopyRange(long start, long end) {
        if (start >= 0L && end >= start) {
            String bytes = "bytes=" + start + "-" + end;
            this.addHeader("x-cos-copy-source-range", bytes);
        }
    }
}

