/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import com.tencent.cos.xml.common.VersionInfo;

public class CosXmlServiceConfig {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_USER_AGENT = VersionInfo.getUserAgent();
    private String protocol;
    private String userAgent;
    private String region;
    private String appid;
    private String ip;
    private boolean isDebuggable;

    public CosXmlServiceConfig(Builder builder) {
        this.protocol = builder.protocol;
        this.userAgent = builder.userAgent;
        this.appid = builder.appid;
        this.region = builder.region;
        this.isDebuggable = builder.isDebuggable;
        this.ip = builder.ip;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public static final class Builder {
        private String protocol = "http";
        private String userAgent = DEFAULT_USER_AGENT;
        private String region;
        private String appid;
        private String ip;
        private boolean isDebuggable = false;

        public Builder isHttps(boolean isHttps) {
            this.protocol = isHttps ? "https" : CosXmlServiceConfig.DEFAULT_PROTOCOL;
            return this;
        }

        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            return this;
        }

        public Builder setHost(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder setDebuggable(boolean isDebuggable) {
            this.isDebuggable = isDebuggable;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }
    }
}

