/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.transfer.TransferObserver;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferStatusManager;
import com.tencent.cos.xml.transfer.UploadService;
import com.tencent.qcloud.core.logger.QCloudLogger;

public class TransferRunnable
implements Runnable {
    private TransferObserver transferObserver;
    private String id;
    private CosXmlProgressListener progressListener;
    private UploadService.ResumeData resumeData;
    private UploadService uploadService;
    private TransferStatusManager transferStatusManager;
    private CosXmlClientException clientException;
    private CosXmlServiceException serviceException;

    TransferRunnable(UploadService uploadService, String id, TransferStatusManager transferStatusManager) {
        this.uploadService = uploadService;
        this.id = id;
        this.transferObserver = new TransferObserver(id);
        this.progressListener = new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                TransferRunnable.this.notifyTransferProgress(complete, target);
            }
        };
        uploadService.setProgressListener(this.progressListener);
        this.transferStatusManager = transferStatusManager;
    }

    @Override
    public void run() {
        if (Thread.interrupted()) {
            return;
        }
        this.clientException = null;
        this.serviceException = null;
        try {
            if (this.resumeData != null) {
                this.uploadService.init(this.resumeData);
            }
            this.uploadService.upload();
        }
        catch (CosXmlClientException e) {
            this.clientException = e;
            if (!(this.isDetectNetworkDisconnectCauseClientException(e) || this.isInitiativePauseCauseClientException(e) || this.isInitiativeCancelCauseClientException(e))) {
                this.notifyTransferFailed();
                this.transferStatusManager.updateState(this.id, TransferState.FAILED);
            }
        }
        catch (CosXmlServiceException e) {
            this.serviceException = e;
            this.notifyTransferFailed();
            this.transferStatusManager.updateState(this.id, TransferState.FAILED);
        }
        if (this.serviceException == null && this.clientException == null) {
            this.transferStatusManager.updateState(this.id, TransferState.COMPLETED);
        }
    }

    void pause() {
        this.resumeData = this.uploadService.pause();
    }

    void cancel() {
        this.uploadService.abort(new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                QCloudLogger.i((String)"TransferUtility", (String)("cancel task(" + TransferRunnable.this.id + ") success"), (Object[])new Object[0]);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                QCloudLogger.w((String)"TransferUtility", (String)("cancel task(" + TransferRunnable.this.id + ") failed"), (Object[])new Object[0]);
            }
        });
    }

    TransferObserver getTransferObserver() {
        return this.transferObserver;
    }

    private void notifyTransferFailed() {
        if (this.transferObserver != null && this.transferObserver.getTransferListener() != null) {
            this.transferObserver.getTransferListener().onError(this.id, this.clientException, this.serviceException);
        }
    }

    void notifyTransferStateChange(TransferState state) {
        if (this.transferObserver != null && this.transferObserver.getTransferListener() != null) {
            this.transferObserver.getTransferListener().onStateChanged(this.id, state);
        }
    }

    private void notifyTransferProgress(long progress, long total) {
        if (this.transferObserver != null && this.transferObserver.getTransferListener() != null) {
            this.transferObserver.getTransferListener().onProgressChanged(this.id, progress, total);
        }
    }

    private boolean isDetectNetworkDisconnectCauseClientException(CosXmlClientException clientException) {
        return this.transferObserver.getTransferState() == TransferState.WAITING_FOR_NETWORK && clientException != null && clientException.getMessage().toLowerCase().contains("request is cancelled by manual pause");
    }

    private boolean isInitiativePauseCauseClientException(CosXmlClientException clientException) {
        return this.transferObserver.getTransferState() == TransferState.PAUSED && clientException != null && clientException.getMessage().toLowerCase().contains("request is cancelled by manual pause");
    }

    private boolean isInitiativeCancelCauseClientException(CosXmlClientException clientException) {
        return this.transferObserver.getTransferState() == TransferState.CANCELED && clientException != null && clientException.getMessage().toLowerCase().contains("request is cancelled by abort request");
    }
}

