/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CosXmlRequest {
    protected Map<String, String> queryParameters = new LinkedHashMap<String, String>();
    protected Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private QCloudSignSourceProvider signSourceProvider;
    private HttpTask httpTask;
    private boolean isNeedMD5 = false;

    public abstract String getMethod();

    protected abstract String getHostPrefix();

    public abstract String getPath();

    public Map<String, String> getQueryString() {
        return this.queryParameters;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public abstract RequestBodySerializer getRequestBody() throws CosXmlClientException;

    public abstract void checkParameters() throws CosXmlClientException;

    public boolean isNeedMD5() {
        return this.isNeedMD5;
    }

    public void setNeedMD5(boolean isNeedMD5) {
        this.isNeedMD5 = isNeedMD5;
    }

    public void setRequestHeaders(String key, String value) throws CosXmlClientException {
        if (key != null && value != null) {
            value = URLEncodeUtils.cosPathEncode(value);
            this.addHeader(key, value);
        }
    }

    protected void addHeader(String key, String value) {
        List<String> values = this.requestHeaders.containsKey(key) ? this.requestHeaders.get(key) : new ArrayList<String>();
        values.add(value);
        this.requestHeaders.put(key, values);
    }

    public String getHost(String appid, String region) {
        String suffix = "myqcloud.com";
        String bucket = this.getHostPrefix();
        if (!bucket.endsWith("-" + appid)) {
            bucket = bucket + "-" + appid;
        }
        return bucket + ".cos." + region + "." + suffix;
    }

    public void setSign(long signDuration) {
        this.signSourceProvider = new COSXmlSignSourceProvider().setDuration(signDuration);
    }

    public void setSign(long startTime, long endTime) {
        this.signSourceProvider = new COSXmlSignSourceProvider().setSignBeginTime(startTime).setSignExpiredTime(endTime);
    }

    public QCloudSignSourceProvider getSignSourceProvider() {
        if (this.signSourceProvider == null) {
            this.signSourceProvider = new COSXmlSignSourceProvider().setDuration(600L);
        }
        return this.signSourceProvider;
    }

    public void setSign(long signDuration, Set<String> parameters, Set<String> headers) {
        COSXmlSignSourceProvider cosXmlSignSourceProvider = new COSXmlSignSourceProvider().setDuration(signDuration);
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setSign(long startTime, long endTime, Set<String> parameters, Set<String> headers) {
        COSXmlSignSourceProvider cosXmlSignSourceProvider = new COSXmlSignSourceProvider().setSignBeginTime(startTime).setSignExpiredTime(endTime);
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setTask(HttpTask httpTask) {
        this.httpTask = httpTask;
    }

    public HttpTask getHttpTask() {
        return this.httpTask;
    }
}

