/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.SelectObjectContentListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.eventstreaming.InputSerialization;
import com.tencent.cos.xml.model.tag.eventstreaming.OutputSerialization;
import com.tencent.cos.xml.model.tag.eventstreaming.RequestProgress;
import com.tencent.cos.xml.model.tag.eventstreaming.ScanRange;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectRequest;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class SelectObjectContentRequest
extends ObjectRequest {
    public static final String EXPRESSION_TYPE_SQL = "SQL";
    private String expression;
    private String expressionType;
    private RequestProgress requestProgress;
    private InputSerialization inputSerialization;
    private OutputSerialization outputSerialization;
    private ScanRange scanRange;
    private SelectObjectContentListener selectObjectContentProgressListener;
    private String selectResponseFilePath;

    public SelectObjectContentRequest(String bucket, String cosPath, String expressionType, String expression, RequestProgress requestProgress, InputSerialization inputSerialization, OutputSerialization outputSerialization, ScanRange scanRange) {
        super(bucket, cosPath);
        this.expression = expression;
        this.expressionType = expressionType;
        this.requestProgress = requestProgress;
        this.inputSerialization = inputSerialization;
        this.outputSerialization = outputSerialization;
        this.scanRange = scanRange;
    }

    public SelectObjectContentRequest(String bucket, String cosPath, String sql, boolean requestProgress, InputSerialization inputSerialization, OutputSerialization outputSerialization) {
        this(bucket, cosPath, EXPRESSION_TYPE_SQL, sql, new RequestProgress(requestProgress), inputSerialization, outputSerialization, null);
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("select", null);
        this.queryParameters.put("select-type", "2");
        return this.queryParameters;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildSelectRequest(new SelectRequest(this.expressionType, this.expression, this.requestProgress, this.inputSerialization, this.outputSerialization, this.scanRange)));
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
        }
    }

    @Override
    public boolean isNeedMD5() {
        return true;
    }

    public void setSelectObjectContentProgressListener(SelectObjectContentListener selectObjectContentProgressListener) {
        this.selectObjectContentProgressListener = selectObjectContentProgressListener;
    }

    public SelectObjectContentListener getSelectObjectContentProgressListener() {
        return this.selectObjectContentProgressListener;
    }

    public void setSelectResponseFilePath(String selectResponseFilePath) {
        this.selectResponseFilePath = selectResponseFilePath;
    }

    public String getSelectResponseFilePath() {
        return this.selectResponseFilePath;
    }
}

