/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.net.Uri;
import android.text.TextUtils;
import com.tencent.cos.xml.common.VersionInfo;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.task.RetryStrategy;
import java.util.concurrent.Executor;

public class CosXmlServiceConfig {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String ACCELERATE_ENDPOINT_SUFFIX = "cos-accelerate";
    public static final String DEFAULT_USER_AGENT = VersionInfo.getUserAgent();
    private String protocol;
    private String userAgent;
    private String region;
    private String appid;
    private String host;
    private int port;
    private String endpointSuffix;
    private boolean bucketInPath;
    private boolean isDebuggable;
    private RetryStrategy retryStrategy;
    private QCloudHttpRetryHandler qCloudHttpRetryHandler;
    private int connectionTimeout;
    private int socketTimeout;
    private Executor executor;
    private boolean isQuic;

    public CosXmlServiceConfig(Builder builder) {
        this.protocol = builder.protocol;
        this.userAgent = builder.userAgent;
        this.isDebuggable = builder.isDebuggable;
        this.appid = builder.appid;
        this.region = builder.region;
        this.host = builder.host;
        this.port = builder.port;
        this.endpointSuffix = builder.endpointSuffix;
        this.bucketInPath = builder.bucketInPath;
        if (TextUtils.isEmpty((CharSequence)this.endpointSuffix) && TextUtils.isEmpty((CharSequence)this.region) && TextUtils.isEmpty((CharSequence)this.host)) {
            throw new IllegalArgumentException("please set host or endpointSuffix or region !");
        }
        this.retryStrategy = builder.retryStrategy;
        this.qCloudHttpRetryHandler = builder.qCloudHttpRetryHandler;
        this.socketTimeout = builder.socketTimeout;
        this.connectionTimeout = builder.connectionTimeout;
        this.executor = builder.executor;
        this.isQuic = builder.isQuic;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket(String bucket) {
        return this.getBucket(bucket, this.appid);
    }

    public String getBucket(String bucket, String appid) {
        String myBucket = bucket;
        if (bucket != null && !bucket.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
            myBucket = bucket + "-" + appid;
        }
        return myBucket;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getHost(String bucket, boolean isSupportAccelerate) {
        return this.getHost(bucket, null, isSupportAccelerate);
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getHost(String bucket, String region, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate);
    }

    public String getHost(String bucket, String region, boolean isSupportAccelerate, boolean isHeader) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate, isHeader);
    }

    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate, boolean isHeader) {
        if (!isHeader && !TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        String myBucket = this.getBucket(bucket, appId);
        String hostBuilder = "";
        if (!this.bucketInPath) {
            hostBuilder = hostBuilder + myBucket + ".";
        }
        hostBuilder = hostBuilder + this.getEndpointSuffix(region, isSupportAccelerate);
        return hostBuilder;
    }

    @Deprecated
    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, appId, isSupportAccelerate, false);
    }

    public String getEndpointSuffix() {
        return this.getEndpointSuffix(this.region, false);
    }

    public String getEndpointSuffix(String region, boolean isSupportAccelerate) {
        String myRegion = TextUtils.isEmpty((CharSequence)region) ? this.getRegion() : region;
        String myEndpointSuffix = this.endpointSuffix;
        if (this.endpointSuffix == null && myRegion != null) {
            myEndpointSuffix = "cos." + myRegion + ".myqcloud.com";
        }
        if ((myEndpointSuffix = this.substituteEndpointSuffix(myEndpointSuffix, myRegion)) != null && isSupportAccelerate) {
            myEndpointSuffix = myEndpointSuffix.replace("cos." + myRegion, ACCELERATE_ENDPOINT_SUFFIX);
        }
        return myEndpointSuffix;
    }

    private String substituteEndpointSuffix(String formatString, String region) {
        if (!TextUtils.isEmpty((CharSequence)formatString) && region != null) {
            return formatString.replace("${region}", region);
        }
        return formatString;
    }

    public String getUrlPath(String bucket, String cosPath) {
        StringBuilder path = new StringBuilder();
        if (this.bucketInPath) {
            String myBucket = bucket;
            if (!bucket.endsWith("-" + this.appid) && !TextUtils.isEmpty((CharSequence)this.appid)) {
                myBucket = bucket + "-" + this.appid;
            }
            path.append("/").append(myBucket);
        }
        if (cosPath != null && !cosPath.startsWith("/")) {
            path.append("/").append(cosPath);
        } else {
            path.append(cosPath);
        }
        return path.toString();
    }

    private boolean isEndWithV4Appid(String bucket) {
        String appid = this.extractAppidFromBucket(bucket);
        return this.isCosV4Appid(appid);
    }

    private String extractAppidFromBucket(String bucket) {
        if (bucket == null || !bucket.contains("-") || bucket.endsWith("-")) {
            return "";
        }
        int index = bucket.lastIndexOf("-");
        return bucket.substring(index + 1);
    }

    private boolean isCosV4Appid(String appid) {
        if (appid == null || appid.length() != 8 || !appid.startsWith("100")) {
            return false;
        }
        try {
            Long.valueOf(appid);
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public QCloudHttpRetryHandler getQCloudHttpRetryHandler() {
        return this.qCloudHttpRetryHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isEnableQuic() {
        return this.isQuic;
    }

    public static final class Builder {
        private String protocol = "http";
        private String userAgent = DEFAULT_USER_AGENT;
        private String region;
        private String appid;
        private String host;
        private int port = -1;
        private String endpointSuffix;
        private boolean bucketInPath = false;
        private boolean isDebuggable = false;
        private RetryStrategy retryStrategy = RetryStrategy.DEFAULT;
        private QCloudHttpRetryHandler qCloudHttpRetryHandler;
        private int connectionTimeout = 15000;
        private int socketTimeout = 30000;
        private Executor executor;
        private boolean isQuic = false;

        public Builder setConnectionTimeout(int connectionTimeoutMills) {
            this.connectionTimeout = connectionTimeoutMills;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeoutMills) {
            this.socketTimeout = socketTimeoutMills;
            return this;
        }

        public Builder isHttps(boolean isHttps) {
            this.protocol = isHttps ? CosXmlServiceConfig.HTTPS_PROTOCOL : CosXmlServiceConfig.HTTP_PROTOCOL;
            return this;
        }

        @Deprecated
        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setEndpointSuffix(String endpointSuffix) {
            this.endpointSuffix = endpointSuffix;
            return this;
        }

        public Builder setHost(Uri uri) {
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            this.protocol = uri.getScheme();
            return this;
        }

        public Builder setDebuggable(boolean isDebuggable) {
            this.isDebuggable = isDebuggable;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setRetryHandler(QCloudHttpRetryHandler qCloudHttpRetryHandler) {
            this.qCloudHttpRetryHandler = qCloudHttpRetryHandler;
            return this;
        }

        public Builder setBucketInPath(boolean bucketInPath) {
            this.bucketInPath = bucketInPath;
            return this;
        }

        public Builder setExecutor(Executor excutor) {
            this.executor = excutor;
            return this;
        }

        public Builder enableQuic(boolean isEnable) {
            this.isQuic = isEnable;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }
    }
}

