/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MTAProxy {
    private static final String TAG = "MTAProxy";
    private final String className = "com.tencent.qcloud.mtaUtils.MTAServer";
    private Object mtaServer;
    private Method reportFailedEvent;
    private Method reportSendEvent;
    private Context applicationContext;
    private static MTAProxy instance;

    private MTAProxy(Context applicationContext) {
        this.applicationContext = applicationContext;
        try {
            Class<?> cls = Class.forName("com.tencent.qcloud.mtaUtils.MTAServer");
            Constructor<?> constructor = cls.getConstructor(Context.class, String.class);
            if (constructor != null) {
                this.mtaServer = constructor.newInstance(this.applicationContext, "5.4.23");
            }
            this.reportFailedEvent = cls.getDeclaredMethod("reportFailedEvent", String.class, String.class);
            if (this.reportFailedEvent != null) {
                this.reportFailedEvent.setAccessible(true);
            }
            this.reportSendEvent = cls.getDeclaredMethod("reportSendEvent", String.class);
            if (this.reportSendEvent != null) {
                this.reportSendEvent.setAccessible(true);
            }
        }
        catch (ClassNotFoundException e) {
            QCloudLogger.d((String)TAG, (String)"com.tencent.qcloud.mtaUtils.MTAServer : not found", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InstantiationException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext) {
        Class<MTAProxy> clazz = MTAProxy.class;
        synchronized (MTAProxy.class) {
            if (instance == null) {
                instance = new MTAProxy(applicationContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static MTAProxy getInstance() {
        return instance;
    }

    public void reportCosXmlClientException(String requestClassName, String exceptionMessage) {
        if (this.mtaServer != null && this.reportFailedEvent != null) {
            try {
                this.reportFailedEvent.invoke(this.mtaServer, requestClassName, exceptionMessage);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportCosXmlServerException(String requestClassName, String errorMsg) {
        if (this.mtaServer != null && this.reportFailedEvent != null) {
            try {
                this.reportFailedEvent.invoke(this.mtaServer, requestClassName, errorMsg);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportSendAction(String requestClassName) {
        if (this.mtaServer != null && this.reportSendEvent != null) {
            try {
                this.reportSendEvent.invoke(this.mtaServer, requestClassName);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }
}

