/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;

public abstract class BucketRequest
extends CosXmlRequest {
    protected String bucket;

    public BucketRequest(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        StringBuilder path = new StringBuilder();
        String appid = config.getAppid();
        String fullBucketName = this.bucket;
        if (config.isBucketInPath()) {
            if (!fullBucketName.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
                fullBucketName = fullBucketName + "-" + appid;
            }
            path.append("/");
            path.append(fullBucketName);
        }
        return path + "/";
    }

    @Override
    public String getHostPrefix() {
        return this.bucket;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.requestURL != null) {
            return;
        }
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }
}

