/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.cos.xml.R;
import java.util.ArrayList;
import java.util.List;

public class LogActivity
extends AppCompatActivity {
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView recyclerView;
    private CustomerAdapter customerAdapter;
    private RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0) {
                // empty if block
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
        }
    };
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.item_list);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.customerAdapter = new CustomerAdapter((Context)this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.customerAdapter);
        this.recyclerView.addOnScrollListener(this.onScrollListener);
    }

    private void initItems() {
    }

    private void updateItmes() {
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerView != null && this.onScrollListener != null) {
            this.recyclerView.removeOnScrollListener(this.onScrollListener);
        }
    }

    private static class CustomerViewHolder
    extends RecyclerView.ViewHolder {
        private TextView filePathTextView;
        private ImageView actionImageView;

        public CustomerViewHolder(View itemView) {
            super(itemView);
            this.filePathTextView = (TextView)itemView.findViewById(R.id.pathId);
            this.actionImageView = (ImageView)itemView.findViewById(R.id.actionId);
        }
    }

    private static class CustomerAdapter
    extends RecyclerView.Adapter<CustomerViewHolder> {
        private List<String> items = new ArrayList<String>(10);
        private Context context;

        public CustomerAdapter(Context context) {
            this.context = context;
        }

        private void share(String filePath) {
            Intent fileIntent = new Intent("android.intent.action.SEND");
            fileIntent.setType("*/*");
            fileIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)filePath));
            this.context.startActivity(Intent.createChooser((Intent)fileIntent, (CharSequence)"\u5206\u4eab"));
        }

        @NonNull
        public CustomerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.item_log, parent, false);
            final CustomerViewHolder customerViewHolder = new CustomerViewHolder(view);
            customerViewHolder.actionImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomerAdapter.this.share(customerViewHolder.filePathTextView.getText().toString().trim());
                }
            });
            return customerViewHolder;
        }

        public void onBindViewHolder(@NonNull CustomerViewHolder holder, int position) {
            holder.filePathTextView.setText((CharSequence)this.items.get(position));
        }

        public int getItemCount() {
            return this.items.size();
        }
    }
}

