/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MTAProxy {
    private static final String TAG = "MTAProxy";
    private final String className = "com.tencent.qcloud.mtaUtils.MTAServer";
    private Object mtaServer;
    private Method reportCosXmlClientException;
    private Method reportCosXmlClientExceptionWithKey;
    private Method reportCosXmlServerException;
    private Method reportCosXmlServerExceptionWithKey;
    private Context applicationContext;
    private static MTAProxy instance;

    private MTAProxy(Context applicationContext) {
        this.applicationContext = applicationContext;
        try {
            Class<?> cls = Class.forName("com.tencent.qcloud.mtaUtils.MTAServer");
            Constructor<?> constructor = cls.getConstructor(Context.class);
            if (constructor != null) {
                this.mtaServer = constructor.newInstance(this.applicationContext);
            }
            this.reportCosXmlClientExceptionWithKey = cls.getDeclaredMethod("reportCosXmlClientException", String.class, String.class);
            if (this.reportCosXmlClientExceptionWithKey != null) {
                this.reportCosXmlClientExceptionWithKey.setAccessible(true);
            }
            this.reportCosXmlClientException = cls.getDeclaredMethod("reportCosXmlClientException", String.class);
            if (this.reportCosXmlClientException != null) {
                this.reportCosXmlClientException.setAccessible(true);
            }
            this.reportCosXmlServerExceptionWithKey = cls.getDeclaredMethod("reportCosXmlServerException", String.class, String.class);
            if (this.reportCosXmlServerExceptionWithKey != null) {
                this.reportCosXmlServerExceptionWithKey.setAccessible(true);
            }
            this.reportCosXmlServerException = cls.getDeclaredMethod("reportCosXmlServerException", String.class);
            if (this.reportCosXmlServerException != null) {
                this.reportCosXmlServerException.setAccessible(true);
            }
        }
        catch (ClassNotFoundException e) {
            QCloudLogger.e((String)TAG, (String)"com.tencent.qcloud.mtaUtils.MTAServer : not found", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            QCloudLogger.e((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InstantiationException e) {
            QCloudLogger.e((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            QCloudLogger.e((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            QCloudLogger.e((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext) {
        Class<MTAProxy> clazz = MTAProxy.class;
        synchronized (MTAProxy.class) {
            if (instance == null) {
                instance = new MTAProxy(applicationContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static MTAProxy getInstance() {
        return instance;
    }

    public void reportCosXmlClientException(String key, String exceptionMessage) {
        if (this.mtaServer != null && this.reportCosXmlClientExceptionWithKey != null) {
            try {
                this.reportCosXmlClientExceptionWithKey.invoke(this.mtaServer, key, exceptionMessage);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportCosXmlClientException(String exceptionMessage) {
        if (this.mtaServer != null && this.reportCosXmlClientException != null) {
            try {
                this.reportCosXmlClientException.invoke(this.mtaServer, exceptionMessage);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportCosXmlServerException(String key, String requestId) {
        if (this.mtaServer != null && this.reportCosXmlServerExceptionWithKey != null) {
            try {
                this.reportCosXmlServerExceptionWithKey.invoke(this.mtaServer, key, requestId);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public void reportCosXmlServerException(String requestId) {
        if (this.mtaServer != null && this.reportCosXmlServerException != null) {
            try {
                this.reportCosXmlServerException.invoke(this.mtaServer, requestId);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }
}

