/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import com.tencent.cos.xml.common.VersionInfo;
import com.tencent.qcloud.core.task.RetryStrategy;

public class CosXmlServiceConfig {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_USER_AGENT = VersionInfo.getUserAgent();
    private String protocol;
    private String userAgent;
    private String region;
    private String appid;
    private String ip;
    private String domainSuffix;
    private boolean bucketInPath;
    private boolean isDebuggable;
    private RetryStrategy retryStrategy;

    public CosXmlServiceConfig(Builder builder) {
        this.protocol = builder.protocol;
        this.userAgent = builder.userAgent;
        this.appid = builder.appid;
        this.region = builder.region;
        this.isDebuggable = builder.isDebuggable;
        this.ip = builder.ip;
        this.domainSuffix = builder.domainSuffix;
        this.retryStrategy = builder.retryStrategy;
        this.bucketInPath = builder.bucketInPath;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public String getDomainSuffix() {
        return this.domainSuffix;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public boolean isBucketInPath() {
        return this.bucketInPath;
    }

    public static final class Builder {
        private String protocol = "http";
        private String userAgent = DEFAULT_USER_AGENT;
        private String region;
        private String appid;
        private String ip;
        private String domainSuffix = "myqcloud.com";
        private boolean bucketInPath = false;
        private boolean isDebuggable = false;
        private RetryStrategy retryStrategy = RetryStrategy.DEFAULT;

        public Builder isHttps(boolean isHttps) {
            this.protocol = isHttps ? "https" : CosXmlServiceConfig.DEFAULT_PROTOCOL;
            return this;
        }

        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            return this;
        }

        @Deprecated
        public Builder setHost(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder setDebuggable(boolean isDebuggable) {
            this.isDebuggable = isDebuggable;
            return this;
        }

        public Builder setDomainSuffix(String domainSuffix) {
            this.domainSuffix = domainSuffix;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setBucketInPath(boolean bucketInPath) {
            this.bucketInPath = bucketInPath;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }
    }
}

