/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.transfer.Task;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.UploadListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UploadTask
extends Task {
    private static final long SIZE_LIMIT = 0x1400000L;
    private long sliceSize = 0x100000L;
    private String srcPath;
    private String uploadId;
    private UploadListener uploadListener;
    private long fileLength;
    private boolean isSliceUpload = false;
    private PutObjectRequest putObjectRequest;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private AtomicBoolean IS_EXIT;
    private Object SYNC_UPLOAD_PART = new Object();
    private static final byte MULTI_UPLOAD_START = 0;
    private static final byte INIT_MULTI_UPLOAD = 1;
    private static final byte LIST_MULTI_UPLOAD = 2;
    private static final byte MULTI_UPLOAD_PART = 3;
    private static final byte COMPLETE_MULTI_UPLOAD = 4;
    private static final byte MULTI_UPLOAD_PAUSE = 6;
    private static final byte MULTI_UPLOAD_CANCEL = 7;
    private static final byte MULTI_UPLOAD_SUCCESS = 9;
    private static final byte MULTI_UPLOAD_FAILED = 10;
    private static Handler multiUploadHandler;
    private static HandlerThread multiUploadHandlerThread;

    public UploadTask(String region, String bucket, String cosPath, String srcPath, String uploadId, UploadListener uploadListener) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.srcPath = srcPath;
        this.uploadId = uploadId;
        this.uploadListener = uploadListener;
    }

    public void upload(CosXmlService cosXmlService) {
        this.updateState(TransferState.WAITING);
        File file = new File(this.srcPath);
        if (!file.exists() || file.isDirectory()) {
            this.updateState(TransferState.FAILED);
            if (this.uploadListener != null) {
                this.uploadListener.onError(this.taskId, new CosXmlClientException("srcPath not exists or is not a file"), null);
                this.onRemoveTaskListener.onRemove(Integer.valueOf(this.taskId));
                return;
            }
        }
        this.fileLength = file.length();
        if (this.fileLength < 0x1400000L) {
            this.simpleUpload(cosXmlService);
        } else {
            this.isSliceUpload = true;
            this.IS_EXIT = new AtomicBoolean(false);
            this.UPLOAD_PART_COUNT = new AtomicInteger(0);
            this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
            this.partStructMap = new HashMap<Integer, SlicePartStruct>();
            this.uploadPartRequestLongMap = new HashMap<UploadPartRequest, Long>();
            this.multiUpload(cosXmlService);
        }
    }

    private void simpleUpload(CosXmlService cosXmlService) {
        this.putObjectRequest = new PutObjectRequest(this.bucket, this.cosPath, this.srcPath);
        this.putObjectRequest.setRegion(this.region);
        this.putObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                if (UploadTask.this.uploadListener != null) {
                    UploadTask.this.uploadListener.onProgressChanged(UploadTask.this.taskId, complete, target);
                }
            }
        });
        this.updateState(TransferState.IN_PROGRESS);
        cosXmlService.putObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (UploadTask.this.updateState(TransferState.COMPLETED)) {
                    UploadTask.this.uploadListener.onSuccess(UploadTask.this.taskId, result);
                    UploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(UploadTask.this.taskId));
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (UploadTask.this.updateState(TransferState.FAILED)) {
                    UploadTask.this.uploadListener.onError(UploadTask.this.taskId, exception, serviceException);
                    UploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(UploadTask.this.taskId));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multiUpload(final CosXmlService cosXmlService) {
        Class<UploadTask> clazz = UploadTask.class;
        synchronized (UploadTask.class) {
            if (multiUploadHandler == null) {
                multiUploadHandlerThread = new HandlerThread("UPLOAD_TASK_HANDLER_THREAD");
                multiUploadHandlerThread.start();
                multiUploadHandler = new Handler(multiUploadHandlerThread.getLooper()){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                UploadTask.this.initSlicePart();
                                break;
                            }
                            case 1: {
                                UploadTask.this.initMultiUpload(cosXmlService);
                                break;
                            }
                            case 2: {
                                UploadTask.this.listMultiUpload(cosXmlService);
                                break;
                            }
                            case 3: {
                                UploadTask.this.multiUploadPart(cosXmlService);
                                break;
                            }
                            case 4: {
                                UploadTask.this.completeMultiUpload(cosXmlService);
                                break;
                            }
                            case 9: {
                                UploadTask.this.IS_EXIT.set(true);
                                multiUploadHandler.removeCallbacksAndMessages(null);
                                if (UploadTask.this.updateState(TransferState.COMPLETED)) {
                                    if (UploadTask.this.uploadListener != null) {
                                        CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)msg.obj;
                                        PutObjectResult putObjectResult = new PutObjectResult();
                                        putObjectResult.headers = completeMultiUploadResult.headers;
                                        putObjectResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
                                        putObjectResult.httpCode = completeMultiUploadResult.httpCode;
                                        putObjectResult.httpMessage = completeMultiUploadResult.httpMessage;
                                        UploadTask.this.uploadListener.onSuccess(UploadTask.this.taskId, putObjectResult);
                                    }
                                    UploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(UploadTask.this.taskId));
                                }
                                multiUploadHandler.getLooper().quit();
                                UploadTask.this.terminate();
                                break;
                            }
                            case 10: {
                                UploadTask.this.IS_EXIT.set(true);
                                multiUploadHandler.removeCallbacksAndMessages(null);
                                UploadTask.this.cancelAllRequest(cosXmlService);
                                UploadTask.this.abortMultiUpload(cosXmlService);
                                if (UploadTask.this.updateState(TransferState.FAILED)) {
                                    if (UploadTask.this.uploadListener != null) {
                                        if (msg.obj instanceof CosXmlClientException) {
                                            UploadTask.this.uploadListener.onError(UploadTask.this.taskId, (CosXmlClientException)((Object)msg.obj), null);
                                        } else {
                                            UploadTask.this.uploadListener.onError(UploadTask.this.taskId, null, (CosXmlServiceException)((Object)msg.obj));
                                        }
                                    }
                                    UploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(UploadTask.this.taskId));
                                }
                                multiUploadHandler.getLooper().quit();
                                UploadTask.this.terminate();
                                break;
                            }
                            case 6: {
                                UploadTask.this.IS_EXIT.set(true);
                                multiUploadHandler.removeCallbacksAndMessages(null);
                                UploadTask.this.cancelAllRequest(cosXmlService);
                                multiUploadHandler.getLooper().quit();
                                UploadTask.this.terminate();
                                break;
                            }
                            case 7: {
                                UploadTask.this.IS_EXIT.set(true);
                                multiUploadHandler.removeCallbacksAndMessages(null);
                                UploadTask.this.cancelAllRequest(cosXmlService);
                                UploadTask.this.abortMultiUpload(cosXmlService);
                                multiUploadHandler.getLooper().quit();
                                UploadTask.this.terminate();
                            }
                        }
                    }
                };
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.updateState(TransferState.IN_PROGRESS);
            multiUploadHandler.sendEmptyMessage(0);
            return;
        }
    }

    private void initMultiUpload(CosXmlService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (UploadTask.this.IS_EXIT.get()) {
                    return;
                }
                UploadTask.this.uploadId = ((InitMultipartUploadResult)result).initMultipartUpload.uploadId;
                multiUploadHandler.sendEmptyMessage(3);
                if (UploadTask.this.uploadListener != null) {
                    UploadTask.this.uploadListener.onGetUploadId(UploadTask.this.taskId, UploadTask.this.uploadId);
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (UploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = multiUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                multiUploadHandler.handleMessage(message);
            }
        });
    }

    private void listMultiUpload(CosXmlService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        cosXmlService.listPartsAsync(this.listPartsRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (UploadTask.this.IS_EXIT.get()) {
                    return;
                }
                UploadTask.this.updateSlicePart((ListPartsResult)result);
                multiUploadHandler.sendEmptyMessage(3);
                if (UploadTask.this.uploadListener != null) {
                    UploadTask.this.uploadListener.onGetUploadId(UploadTask.this.taskId, UploadTask.this.uploadId);
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (UploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = multiUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                multiUploadHandler.sendMessage(message);
            }
        });
    }

    private void multiUploadPart(CosXmlService cosXmlService) {
        boolean isUploadFinished = true;
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = entry.getValue();
            if (slicePartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isUploadFinished = false;
            final UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.srcPath, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    if (UploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    try {
                        long dataLen = UploadTask.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)UploadTask.this.uploadPartRequestLongMap.get(uploadPartRequest));
                        UploadTask.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                        if (UploadTask.this.uploadListener != null) {
                            UploadTask.this.uploadListener.onProgressChanged(UploadTask.this.taskId, dataLen, UploadTask.this.fileLength);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            cosXmlService.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    Object object = UploadTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        UploadTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (UploadTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            if (UploadTask.this.IS_EXIT.get()) {
                                return;
                            }
                            multiUploadHandler.sendEmptyMessage(4);
                        }
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (UploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    Message message = multiUploadHandler.obtainMessage();
                    message.what = 10;
                    message.obj = exception != null ? exception : serviceException;
                    multiUploadHandler.sendMessage(message);
                }
            });
        }
        if (isUploadFinished && !this.IS_EXIT.get()) {
            multiUploadHandler.sendEmptyMessage(4);
            if (this.uploadListener != null) {
                this.uploadListener.onProgressChanged(this.taskId, this.fileLength, this.fileLength);
            }
        }
    }

    private void completeMultiUpload(CosXmlService cosXmlService) {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                Message message = multiUploadHandler.obtainMessage();
                message.what = 9;
                message.obj = result;
                multiUploadHandler.sendMessage(message);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (UploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = multiUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                multiUploadHandler.sendMessage(message);
            }
        });
    }

    private void cancelAllRequest(CosXmlService cosXmlService) {
        if (this.putObjectRequest != null) {
            cosXmlService.cancel(this.putObjectRequest);
            this.putObjectRequest = null;
        }
        if (this.initMultipartUploadRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.initMultipartUploadRequest = null;
        }
        if (this.listPartsRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.listPartsRequest = null;
        }
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                cosXmlService.cancel(iterator.next());
            }
            this.uploadPartRequestLongMap.clear();
        }
        if (this.completeMultiUploadRequest != null) {
            cosXmlService.cancel(this.completeMultiUploadRequest);
            this.completeMultiUploadRequest = null;
        }
    }

    private void abortMultiUpload(CosXmlService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    private void terminate() {
        if (multiUploadHandlerThread != null && !multiUploadHandlerThread.isInterrupted()) {
            multiUploadHandlerThread.interrupt();
        }
        multiUploadHandlerThread = null;
        multiUploadHandler = null;
    }

    @Override
    protected void pause(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.PAUSED)) {
            if (this.uploadListener != null) {
                this.uploadListener.onError(this.taskId, new CosXmlClientException("paused by user"), null);
            }
            if (this.isSliceUpload) {
                multiUploadHandler.sendEmptyMessage(6);
            } else {
                cosXmlService.cancel(this.putObjectRequest);
            }
        }
    }

    @Override
    protected void cancel(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.CANCELED)) {
            if (this.uploadListener != null) {
                this.uploadListener.onError(this.taskId, new CosXmlClientException("cancelled by user"), null);
            }
            if (this.isSliceUpload) {
                multiUploadHandler.sendEmptyMessage(7);
            } else {
                cosXmlService.cancel(this.putObjectRequest);
            }
            this.onRemoveTaskListener.onRemove(Integer.valueOf(this.taskId));
        }
    }

    @Override
    protected void resume(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.RESUMED_WAITING)) {
            this.upload(cosXmlService);
        }
    }

    private synchronized boolean updateState(TransferState newTaskState) {
        switch (newTaskState) {
            case WAITING: {
                if (this.taskState != TransferState.WAITING && this.taskState != TransferState.COMPLETED && this.taskState != TransferState.FAILED && this.taskState != TransferState.CANCELED) {
                    this.taskState = TransferState.WAITING;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case IN_PROGRESS: {
                if (this.taskState != TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.IN_PROGRESS;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case COMPLETED: {
                if (this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.COMPLETED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case FAILED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.FAILED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case PAUSED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.PAUSED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case CANCELED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.CANCELED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case RESUMED_WAITING: {
                if (this.taskState != TransferState.PAUSED) break;
                return true;
            }
        }
        return false;
    }

    private void initSlicePart() {
        if (this.fileLength > 0L && this.sliceSize > 0L) {
            SlicePartStruct slicePartStruct;
            int i;
            int count = (int)(this.fileLength / this.sliceSize);
            for (i = 1; i < count; ++i) {
                slicePartStruct = new SlicePartStruct();
                slicePartStruct.isAlreadyUpload = false;
                slicePartStruct.partNumber = i;
                slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
                slicePartStruct.sliceSize = this.sliceSize;
                this.partStructMap.put(i, slicePartStruct);
            }
            slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
            slicePartStruct.sliceSize = this.fileLength - slicePartStruct.offset;
            this.partStructMap.put(i, slicePartStruct);
            this.UPLOAD_PART_COUNT.set(i);
            if (this.IS_EXIT.get()) {
                return;
            }
            if (this.uploadId == null) {
                multiUploadHandler.sendEmptyMessage(1);
            } else {
                multiUploadHandler.sendEmptyMessage(2);
            }
        } else {
            if (this.IS_EXIT.get()) {
                return;
            }
            Message message = multiUploadHandler.obtainMessage();
            message.what = 10;
            message.obj = new CosXmlClientException("file size or slice size less than 0");
            multiUploadHandler.sendMessage(message);
        }
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
                this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
            }
        }
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }
}

