/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.transfer.Task;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.UploadListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SliceUploadTask
extends Task
implements Runnable {
    private int mPriority = 0;
    private Looper mLooper;
    @Nullable
    private Handler sliceUploadHandler;
    private static ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2 + 1);
    private long sliceSize = 0x100000L;
    private CosXmlService cosXmlService;
    private String srcPath;
    private String uploadId;
    private UploadListener uploadListener;
    private long fileLength;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private AtomicBoolean IS_EXIT;
    private Object SYNC_EXIT = new Object();
    private boolean isFinish = false;
    private Object SYNC_UPLOAD_PART = new Object();
    private static final byte MULTI_UPLOAD_START = 0;
    private static final byte INIT_MULTI_UPLOAD = 1;
    private static final byte LIST_MULTI_UPLOAD = 2;
    private static final byte MULTI_UPLOAD_PART = 3;
    private static final byte COMPLETE_MULTI_UPLOAD = 4;
    private static final byte MULTI_UPLOAD_PAUSE = 6;
    private static final byte MULTI_UPLOAD_CANCEL = 7;
    private static final byte MULTI_UPLOAD_SUCCESS = 9;
    private static final byte MULTI_UPLOAD_FAILED = 10;

    public SliceUploadTask(String region, String bucket, String cosPath, String srcPath, String uploadId, UploadListener uploadListener) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.srcPath = srcPath;
        this.uploadId = uploadId;
        this.uploadListener = uploadListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Object object = this;
        synchronized (object) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority((int)this.mPriority);
        object = this.SYNC_EXIT;
        synchronized (object) {
            this.onLooperPrepared();
            if (this.isFinish) {
                if (this.taskState == TransferState.PAUSED) {
                    this.sliceUploadHandler.sendEmptyMessage(6);
                } else if (this.taskState == TransferState.CANCELED) {
                    this.sliceUploadHandler.sendEmptyMessage(7);
                }
            }
        }
        Looper.loop();
        Log.d((String)"SliceUploadTask", (String)"release resource");
        this.cosXmlService = null;
        this.initMultipartUploadRequest = null;
        this.listPartsRequest = null;
        this.completeMultiUploadRequest = null;
        this.UPLOAD_PART_COUNT = null;
        this.ALREADY_SEND_DATA_LEN = null;
        this.IS_EXIT = null;
        this.isFinish = false;
        this.partStructMap.clear();
        this.partStructMap = null;
        this.uploadPartRequestLongMap.clear();
        this.uploadPartRequestLongMap = null;
    }

    protected void onLooperPrepared() {
        this.sliceUploadHandler = new Handler(this.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        SliceUploadTask.this.initSlicePart();
                        break;
                    }
                    case 1: {
                        SliceUploadTask.this.initMultiUpload(SliceUploadTask.this.cosXmlService);
                        break;
                    }
                    case 2: {
                        SliceUploadTask.this.listMultiUpload(SliceUploadTask.this.cosXmlService);
                        break;
                    }
                    case 3: {
                        SliceUploadTask.this.multiUploadPart(SliceUploadTask.this.cosXmlService);
                        break;
                    }
                    case 4: {
                        SliceUploadTask.this.completeMultiUpload(SliceUploadTask.this.cosXmlService);
                        break;
                    }
                    case 9: {
                        SliceUploadTask.this.IS_EXIT.set(true);
                        SliceUploadTask.this.sliceUploadHandler.removeCallbacksAndMessages(null);
                        if (SliceUploadTask.this.updateState(TransferState.COMPLETED)) {
                            if (SliceUploadTask.this.uploadListener != null) {
                                CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)msg.obj;
                                PutObjectResult putObjectResult = new PutObjectResult();
                                putObjectResult.headers = completeMultiUploadResult.headers;
                                putObjectResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
                                putObjectResult.httpCode = completeMultiUploadResult.httpCode;
                                putObjectResult.httpMessage = completeMultiUploadResult.httpMessage;
                                SliceUploadTask.this.uploadListener.onSuccess(SliceUploadTask.this.taskId, putObjectResult);
                            }
                            SliceUploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(SliceUploadTask.this.taskId));
                        }
                        SliceUploadTask.this.sliceUploadHandler.getLooper().quit();
                        break;
                    }
                    case 10: {
                        SliceUploadTask.this.IS_EXIT.set(true);
                        SliceUploadTask.this.sliceUploadHandler.removeCallbacksAndMessages(null);
                        SliceUploadTask.this.cancelAllRequest(SliceUploadTask.this.cosXmlService);
                        SliceUploadTask.this.abortMultiUpload(SliceUploadTask.this.cosXmlService);
                        if (SliceUploadTask.this.updateState(TransferState.FAILED)) {
                            if (SliceUploadTask.this.uploadListener != null) {
                                if (msg.obj instanceof CosXmlClientException) {
                                    SliceUploadTask.this.uploadListener.onError(SliceUploadTask.this.taskId, (CosXmlClientException)((Object)msg.obj), null);
                                } else {
                                    SliceUploadTask.this.uploadListener.onError(SliceUploadTask.this.taskId, null, (CosXmlServiceException)((Object)msg.obj));
                                }
                            }
                            SliceUploadTask.this.onRemoveTaskListener.onRemove(Integer.valueOf(SliceUploadTask.this.taskId));
                        }
                        SliceUploadTask.this.sliceUploadHandler.getLooper().quit();
                        break;
                    }
                    case 6: {
                        SliceUploadTask.this.IS_EXIT.set(true);
                        SliceUploadTask.this.sliceUploadHandler.removeCallbacksAndMessages(null);
                        SliceUploadTask.this.cancelAllRequest(SliceUploadTask.this.cosXmlService);
                        SliceUploadTask.this.sliceUploadHandler.getLooper().quit();
                        break;
                    }
                    case 7: {
                        SliceUploadTask.this.IS_EXIT.set(true);
                        SliceUploadTask.this.sliceUploadHandler.removeCallbacksAndMessages(null);
                        SliceUploadTask.this.cancelAllRequest(SliceUploadTask.this.cosXmlService);
                        SliceUploadTask.this.abortMultiUpload(SliceUploadTask.this.cosXmlService);
                        SliceUploadTask.this.sliceUploadHandler.getLooper().quit();
                    }
                }
            }
        };
        this.IS_EXIT = new AtomicBoolean(false);
        this.UPLOAD_PART_COUNT = new AtomicInteger(0);
        this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
        this.partStructMap = new HashMap<Integer, SlicePartStruct>();
        this.uploadPartRequestLongMap = new HashMap<UploadPartRequest, Long>();
        this.updateState(TransferState.IN_PROGRESS);
        this.sliceUploadHandler.sendEmptyMessage(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Looper getLooper() {
        if (!Thread.currentThread().isAlive()) {
            return null;
        }
        SliceUploadTask sliceUploadTask = this;
        synchronized (sliceUploadTask) {
            while (Thread.currentThread().isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mLooper;
    }

    public void upload(CosXmlService cosXmlService) {
        this.cosXmlService = cosXmlService;
        executorService.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pause(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.PAUSED)) {
            if (this.cosXmlService == null) {
                this.cosXmlService = cosXmlService;
            }
            if (this.uploadListener != null) {
                this.uploadListener.onError(this.taskId, new CosXmlClientException("paused by user"), null);
            }
            Object object = this.SYNC_EXIT;
            synchronized (object) {
                if (this.sliceUploadHandler != null) {
                    this.sliceUploadHandler.sendEmptyMessage(6);
                } else {
                    this.isFinish = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.CANCELED)) {
            if (this.cosXmlService == null) {
                this.cosXmlService = cosXmlService;
            }
            if (this.uploadListener != null) {
                this.uploadListener.onError(this.taskId, new CosXmlClientException("cancelled by user"), null);
            }
            Object object = this.SYNC_EXIT;
            synchronized (object) {
                if (this.sliceUploadHandler != null) {
                    this.sliceUploadHandler.sendEmptyMessage(7);
                } else {
                    this.isFinish = true;
                }
            }
            this.onRemoveTaskListener.onRemove(Integer.valueOf(this.taskId));
        }
    }

    @Override
    protected void resume(CosXmlService cosXmlService) {
        if (this.updateState(TransferState.RESUMED_WAITING)) {
            this.upload(cosXmlService);
        }
    }

    private void initSlicePart() {
        File file = new File(this.srcPath);
        if (!file.exists() || file.isDirectory()) {
            if (this.IS_EXIT.get()) {
                return;
            }
            Message message = this.sliceUploadHandler.obtainMessage();
            message.what = 10;
            message.obj = new CosXmlClientException("srcPath not exists or is not a file");
            this.sliceUploadHandler.sendMessage(message);
            return;
        }
        this.fileLength = file.length();
        if (this.fileLength > 0L && this.sliceSize > 0L) {
            SlicePartStruct slicePartStruct;
            int i;
            int count = (int)(this.fileLength / this.sliceSize);
            for (i = 1; i < count; ++i) {
                slicePartStruct = new SlicePartStruct();
                slicePartStruct.isAlreadyUpload = false;
                slicePartStruct.partNumber = i;
                slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
                slicePartStruct.sliceSize = this.sliceSize;
                this.partStructMap.put(i, slicePartStruct);
            }
            slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
            slicePartStruct.sliceSize = this.fileLength - slicePartStruct.offset;
            this.partStructMap.put(i, slicePartStruct);
            this.UPLOAD_PART_COUNT.set(i);
            if (this.IS_EXIT.get()) {
                return;
            }
            if (this.uploadId == null) {
                this.sliceUploadHandler.sendEmptyMessage(1);
            } else {
                this.sliceUploadHandler.sendEmptyMessage(2);
            }
        } else {
            if (this.IS_EXIT.get()) {
                return;
            }
            Message message = this.sliceUploadHandler.obtainMessage();
            message.what = 10;
            message.obj = new CosXmlClientException("file size or slice size less than 0");
            this.sliceUploadHandler.sendMessage(message);
        }
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
                this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
            }
        }
    }

    private void initMultiUpload(CosXmlService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (SliceUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                SliceUploadTask.this.uploadId = ((InitMultipartUploadResult)result).initMultipartUpload.uploadId;
                SliceUploadTask.this.sliceUploadHandler.sendEmptyMessage(3);
                if (SliceUploadTask.this.uploadListener != null) {
                    SliceUploadTask.this.uploadListener.onGetUploadId(SliceUploadTask.this.taskId, SliceUploadTask.this.uploadId);
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (SliceUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = SliceUploadTask.this.sliceUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                SliceUploadTask.this.sliceUploadHandler.handleMessage(message);
            }
        });
    }

    private void listMultiUpload(CosXmlService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        cosXmlService.listPartsAsync(this.listPartsRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (SliceUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                SliceUploadTask.this.updateSlicePart((ListPartsResult)result);
                SliceUploadTask.this.sliceUploadHandler.sendEmptyMessage(3);
                if (SliceUploadTask.this.uploadListener != null) {
                    SliceUploadTask.this.uploadListener.onGetUploadId(SliceUploadTask.this.taskId, SliceUploadTask.this.uploadId);
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (SliceUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = SliceUploadTask.this.sliceUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                SliceUploadTask.this.sliceUploadHandler.sendMessage(message);
            }
        });
    }

    private void multiUploadPart(CosXmlService cosXmlService) {
        boolean isUploadFinished = true;
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = entry.getValue();
            if (slicePartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isUploadFinished = false;
            final UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.srcPath, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    if (SliceUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    try {
                        long dataLen = SliceUploadTask.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)SliceUploadTask.this.uploadPartRequestLongMap.get(uploadPartRequest));
                        SliceUploadTask.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                        if (SliceUploadTask.this.uploadListener != null) {
                            SliceUploadTask.this.uploadListener.onProgressChanged(SliceUploadTask.this.taskId, dataLen, SliceUploadTask.this.fileLength);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            cosXmlService.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    Object object = SliceUploadTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        SliceUploadTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (SliceUploadTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            if (SliceUploadTask.this.IS_EXIT.get()) {
                                return;
                            }
                            SliceUploadTask.this.sliceUploadHandler.sendEmptyMessage(4);
                        }
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (SliceUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    Message message = SliceUploadTask.this.sliceUploadHandler.obtainMessage();
                    message.what = 10;
                    message.obj = exception != null ? exception : serviceException;
                    SliceUploadTask.this.sliceUploadHandler.sendMessage(message);
                }
            });
        }
        if (isUploadFinished && !this.IS_EXIT.get()) {
            this.sliceUploadHandler.sendEmptyMessage(4);
            if (this.uploadListener != null) {
                this.uploadListener.onProgressChanged(this.taskId, this.fileLength, this.fileLength);
            }
        }
    }

    private void completeMultiUpload(CosXmlService cosXmlService) {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                Message message = SliceUploadTask.this.sliceUploadHandler.obtainMessage();
                message.what = 9;
                message.obj = result;
                SliceUploadTask.this.sliceUploadHandler.sendMessage(message);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (SliceUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                Message message = SliceUploadTask.this.sliceUploadHandler.obtainMessage();
                message.what = 10;
                message.obj = exception != null ? exception : serviceException;
                SliceUploadTask.this.sliceUploadHandler.sendMessage(message);
            }
        });
    }

    private void abortMultiUpload(CosXmlService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    private void cancelAllRequest(CosXmlService cosXmlService) {
        if (this.initMultipartUploadRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.initMultipartUploadRequest = null;
        }
        if (this.listPartsRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.listPartsRequest = null;
        }
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                cosXmlService.cancel(iterator.next());
            }
            this.uploadPartRequestLongMap.clear();
        }
        if (this.completeMultiUploadRequest != null) {
            cosXmlService.cancel(this.completeMultiUploadRequest);
            this.completeMultiUploadRequest = null;
        }
    }

    private synchronized boolean updateState(TransferState newTaskState) {
        switch (newTaskState) {
            case WAITING: {
                if (this.taskState != TransferState.WAITING && this.taskState != TransferState.COMPLETED && this.taskState != TransferState.FAILED && this.taskState != TransferState.CANCELED) {
                    this.taskState = TransferState.WAITING;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case IN_PROGRESS: {
                if (this.taskState != TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.IN_PROGRESS;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case COMPLETED: {
                if (this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.COMPLETED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case FAILED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.FAILED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case PAUSED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.PAUSED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case CANCELED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.CANCELED;
                    if (this.uploadListener != null) {
                        this.uploadListener.onStateChanged(this.taskId, this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case RESUMED_WAITING: {
                if (this.taskState != TransferState.PAUSED) break;
                return true;
            }
        }
        return false;
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }
}

