/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.Map;

public final class InitMultipartUploadRequest
extends ObjectRequest {
    public InitMultipartUploadRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.addHeader("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.addHeader("Content-Disposition", contentDisposition);
    }

    public void setContentEncoding(String contentEncoding) {
        if (contentEncoding == null) {
            return;
        }
        this.addHeader("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.addHeader("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("uploads", null);
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() {
        return RequestBodySerializer.bytes(null, (byte[])new byte[0]);
    }
}

