/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mmkv;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import androidx.annotation.Nullable;
import com.tencent.mmkv.MMKVContentChangeNotification;
import com.tencent.mmkv.MMKVContentProvider;
import com.tencent.mmkv.MMKVHandler;
import com.tencent.mmkv.MMKVLogLevel;
import com.tencent.mmkv.MMKVRecoverStrategic;
import com.tencent.mmkv.NativeBuffer;
import com.tencent.mmkv.ParcelableMMKV;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MMKV
implements SharedPreferences,
SharedPreferences.Editor {
    private static EnumMap<MMKVRecoverStrategic, Integer> recoverIndex = new EnumMap(MMKVRecoverStrategic.class);
    private static EnumMap<MMKVLogLevel, Integer> logLevel2Index;
    private static MMKVLogLevel[] index2LogLevel;
    private static HashSet<Long> checkedHandleSet;
    private static String rootDir;
    public static final int SINGLE_PROCESS_MODE = 1;
    public static final int MULTI_PROCESS_MODE = 2;
    private static final int CONTEXT_MODE_MULTI_PROCESS = 4;
    private static final int ASHMEM_MODE = 8;
    private static final HashMap<String, Parcelable.Creator<?>> mCreators;
    private static MMKVHandler gCallbackHandler;
    private static boolean gWantLogReDirecting;
    private static MMKVContentChangeNotification gContentChangeNotify;
    private long nativeHandle;

    public static String initialize(Context context) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(root, null, logLevel);
    }

    public static String initialize(Context context, MMKVLogLevel logLevel) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        return MMKV.initialize(root, null, logLevel);
    }

    public static String initialize(String rootDir) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(rootDir, null, logLevel);
    }

    public static String initialize(String rootDir, MMKVLogLevel logLevel) {
        return MMKV.initialize(rootDir, null, logLevel);
    }

    public static String initialize(String rootDir, LibLoader loader) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(rootDir, loader, logLevel);
    }

    public static String initialize(String rootDir, LibLoader loader, MMKVLogLevel logLevel) {
        if (loader != null) {
            if ("StaticCpp".equals("SharedCpp")) {
                loader.loadLibrary("c++_shared");
            }
            loader.loadLibrary("mmkv");
        } else {
            if ("StaticCpp".equals("SharedCpp")) {
                System.loadLibrary("c++_shared");
            }
            System.loadLibrary("mmkv");
        }
        MMKV.jniInitialize(rootDir, MMKV.logLevel2Int(logLevel));
        MMKV.rootDir = rootDir;
        return MMKV.rootDir;
    }

    public static String getRootDir() {
        return rootDir;
    }

    private static int logLevel2Int(MMKVLogLevel level) {
        int realLevel;
        switch (level) {
            case LevelDebug: {
                realLevel = 0;
                break;
            }
            case LevelInfo: {
                realLevel = 1;
                break;
            }
            case LevelWarning: {
                realLevel = 2;
                break;
            }
            case LevelError: {
                realLevel = 3;
                break;
            }
            case LevelNone: {
                realLevel = 4;
                break;
            }
            default: {
                realLevel = 1;
            }
        }
        return realLevel;
    }

    public static void setLogLevel(MMKVLogLevel level) {
        int realLevel = MMKV.logLevel2Int(level);
        MMKV.setLogLevel(realLevel);
    }

    public static native void onExit();

    public static MMKV mmkvWithID(String mmapID) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, 1, null, null);
        return MMKV.checkProcessMode(handle, mmapID, 1);
    }

    public static MMKV mmkvWithID(String mmapID, int mode) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, null, null);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    public static MMKV mmkvWithID(String mmapID, int mode, String cryptKey) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey, null);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @Nullable
    public static MMKV mmkvWithID(String mmapID, String rootPath) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, 1, null, rootPath);
        return MMKV.checkProcessMode(handle, mmapID, 1);
    }

    @Nullable
    public static MMKV mmkvWithID(String mmapID, int mode, String cryptKey, String rootPath) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey, rootPath);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @Nullable
    public static MMKV mmkvWithAshmemID(Context context, String mmapID, int size, int mode, String cryptKey) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        String processName = MMKVContentProvider.getProcessNameByPID(context, Process.myPid());
        if (processName == null || processName.length() == 0) {
            MMKV.simpleLog(MMKVLogLevel.LevelError, "process name detect fail, try again later");
            return null;
        }
        if (processName.contains(":")) {
            ContentResolver resolver;
            Bundle result;
            Uri uri = MMKVContentProvider.contentUri(context);
            if (uri == null) {
                MMKV.simpleLog(MMKVLogLevel.LevelError, "MMKVContentProvider has invalid authority");
                return null;
            }
            MMKV.simpleLog(MMKVLogLevel.LevelInfo, "getting parcelable mmkv in process, Uri = " + uri);
            Bundle extras = new Bundle();
            extras.putInt("KEY_SIZE", size);
            extras.putInt("KEY_MODE", mode);
            if (cryptKey != null) {
                extras.putString("KEY_CRYPT", cryptKey);
            }
            if ((result = (resolver = context.getContentResolver()).call(uri, "mmkvFromAshmemID", mmapID, extras)) != null) {
                result.setClassLoader(ParcelableMMKV.class.getClassLoader());
                ParcelableMMKV parcelableMMKV = (ParcelableMMKV)result.getParcelable("KEY");
                if (parcelableMMKV != null) {
                    MMKV mmkv = parcelableMMKV.toMMKV();
                    if (mmkv != null) {
                        MMKV.simpleLog(MMKVLogLevel.LevelInfo, mmkv.mmapID() + " fd = " + mmkv.ashmemFD() + ", meta fd = " + mmkv.ashmemMetaFD());
                    }
                    return mmkv;
                }
            }
        } else {
            MMKV.simpleLog(MMKVLogLevel.LevelInfo, "getting mmkv in main process");
            long handle = MMKV.getMMKVWithIDAndSize(mmapID, size, mode |= 8, cryptKey);
            return new MMKV(handle);
        }
        return null;
    }

    public static MMKV defaultMMKV() {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getDefaultMMKV(1, null);
        return MMKV.checkProcessMode(handle, "DefaultMMKV", 1);
    }

    public static MMKV defaultMMKV(int mode, String cryptKey) {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getDefaultMMKV(mode, cryptKey);
        return MMKV.checkProcessMode(handle, "DefaultMMKV", mode);
    }

    private static MMKV checkProcessMode(long handle, String mmapID, int mode) {
        if (handle == 0L) {
            return null;
        }
        if (!checkedHandleSet.contains(handle)) {
            if (!MMKV.checkProcessMode(handle)) {
                String message;
                if (mode == 1) {
                    message = "Opening a multi-process MMKV instance [" + mmapID + "] with SINGLE_PROCESS_MODE!";
                } else {
                    message = "Opening a MMKV instance [" + mmapID + "] with MULTI_PROCESS_MODE, ";
                    message = message + "while it's already been opened with SINGLE_PROCESS_MODE by someone somewhere else!";
                }
                throw new IllegalArgumentException(message);
            }
            checkedHandleSet.add(handle);
        }
        return new MMKV(handle);
    }

    public native String cryptKey();

    public native boolean reKey(String var1);

    public native void checkReSetCryptKey(String var1);

    public static native int pageSize();

    public native String mmapID();

    public native void lock();

    public native void unlock();

    public native boolean tryLock();

    public boolean encode(String key, boolean value) {
        return this.encodeBool(this.nativeHandle, key, value);
    }

    public boolean decodeBool(String key) {
        return this.decodeBool(this.nativeHandle, key, false);
    }

    public boolean decodeBool(String key, boolean defaultValue) {
        return this.decodeBool(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, int value) {
        return this.encodeInt(this.nativeHandle, key, value);
    }

    public int decodeInt(String key) {
        return this.decodeInt(this.nativeHandle, key, 0);
    }

    public int decodeInt(String key, int defaultValue) {
        return this.decodeInt(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, long value) {
        return this.encodeLong(this.nativeHandle, key, value);
    }

    public long decodeLong(String key) {
        return this.decodeLong(this.nativeHandle, key, 0L);
    }

    public long decodeLong(String key, long defaultValue) {
        return this.decodeLong(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, float value) {
        return this.encodeFloat(this.nativeHandle, key, value);
    }

    public float decodeFloat(String key) {
        return this.decodeFloat(this.nativeHandle, key, 0.0f);
    }

    public float decodeFloat(String key, float defaultValue) {
        return this.decodeFloat(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, double value) {
        return this.encodeDouble(this.nativeHandle, key, value);
    }

    public double decodeDouble(String key) {
        return this.decodeDouble(this.nativeHandle, key, 0.0);
    }

    public double decodeDouble(String key, double defaultValue) {
        return this.decodeDouble(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, String value) {
        return this.encodeString(this.nativeHandle, key, value);
    }

    public String decodeString(String key) {
        return this.decodeString(this.nativeHandle, key, null);
    }

    public String decodeString(String key, String defaultValue) {
        return this.decodeString(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, Set<String> value) {
        return this.encodeSet(this.nativeHandle, key, value.toArray(new String[0]));
    }

    public Set<String> decodeStringSet(String key) {
        return this.decodeStringSet(key, null);
    }

    public Set<String> decodeStringSet(String key, Set<String> defaultValue) {
        return this.decodeStringSet(key, defaultValue, HashSet.class);
    }

    public Set<String> decodeStringSet(String key, Set<String> defaultValue, Class<? extends Set> cls) {
        Set a;
        String[] result = this.decodeStringSet(this.nativeHandle, key);
        if (result == null) {
            return defaultValue;
        }
        try {
            a = cls.newInstance();
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (InstantiationException e) {
            return defaultValue;
        }
        a.addAll(Arrays.asList(result));
        return a;
    }

    public boolean encode(String key, byte[] value) {
        return this.encodeBytes(this.nativeHandle, key, value);
    }

    public byte[] decodeBytes(String key) {
        return this.decodeBytes(key, null);
    }

    public byte[] decodeBytes(String key, byte[] defaultValue) {
        byte[] ret = this.decodeBytes(this.nativeHandle, key);
        return ret != null ? ret : defaultValue;
    }

    public boolean encode(String key, Parcelable value) {
        Parcel source = Parcel.obtain();
        value.writeToParcel(source, value.describeContents());
        byte[] bytes = source.marshall();
        source.recycle();
        return this.encodeBytes(this.nativeHandle, key, bytes);
    }

    public <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass) {
        return this.decodeParcelable(key, tClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass, T defaultValue) {
        String name;
        Parcel source;
        block11: {
            Parcelable.Creator creator;
            if (tClass == null) {
                return defaultValue;
            }
            byte[] bytes = this.decodeBytes(this.nativeHandle, key);
            if (bytes == null) {
                return defaultValue;
            }
            source = Parcel.obtain();
            source.unmarshall(bytes, 0, bytes.length);
            source.setDataPosition(0);
            name = tClass.toString();
            Parcelable parcelable = mCreators;
            synchronized (parcelable) {
                Field f;
                creator = mCreators.get(name);
                if (creator == null && (creator = (Parcelable.Creator)(f = tClass.getField("CREATOR")).get(null)) != null) {
                    mCreators.put(name, creator);
                }
            }
            if (creator == null) break block11;
            parcelable = (Parcelable)creator.createFromParcel(source);
            source.recycle();
            return (T)parcelable;
        }
        try {
            try {
                throw new Exception("Parcelable protocol requires a non-null static Parcelable.Creator object called CREATOR on class " + name);
            }
            catch (Exception e) {
                MMKV.simpleLog(MMKVLogLevel.LevelError, e.toString());
                source.recycle();
            }
        }
        catch (Throwable throwable) {
            source.recycle();
            throw throwable;
        }
        return defaultValue;
    }

    public int getValueSize(String key) {
        return this.valueSize(this.nativeHandle, key, false);
    }

    public int getValueActualSize(String key) {
        return this.valueSize(this.nativeHandle, key, true);
    }

    public boolean containsKey(String key) {
        return this.containsKey(this.nativeHandle, key);
    }

    public native String[] allKeys();

    public long count() {
        return this.count(this.nativeHandle);
    }

    public long totalSize() {
        return this.totalSize(this.nativeHandle);
    }

    public void removeValueForKey(String key) {
        this.removeValueForKey(this.nativeHandle, key);
    }

    public native void removeValuesForKeys(String[] var1);

    public native void clearAll();

    public native void trim();

    public native void close();

    public native void clearMemoryCache();

    public void sync() {
        this.sync(true);
    }

    public void async() {
        this.sync(false);
    }

    private native void sync(boolean var1);

    public static native boolean isFileValid(String var0);

    public int importFromSharedPreferences(SharedPreferences preferences) {
        Map kvs = preferences.getAll();
        if (kvs == null || kvs.size() <= 0) {
            return 0;
        }
        for (Map.Entry entry : kvs.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Boolean) {
                this.encodeBool(this.nativeHandle, key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                this.encodeInt(this.nativeHandle, key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.encodeLong(this.nativeHandle, key, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                this.encodeFloat(this.nativeHandle, key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.encodeDouble(this.nativeHandle, key, (Double)value);
                continue;
            }
            if (value instanceof String) {
                this.encodeString(this.nativeHandle, key, (String)value);
                continue;
            }
            if (value instanceof Set) {
                this.encode(key, (Set)value);
                continue;
            }
            MMKV.simpleLog(MMKVLogLevel.LevelError, "unknown type: " + value.getClass());
        }
        return kvs.size();
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException("use allKeys() instead, getAll() not implement because type-erasure inside mmkv");
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.decodeString(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putString(String key, @Nullable String value) {
        this.encodeString(this.nativeHandle, key, value);
        return this;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return this.decodeStringSet(key, defValues);
    }

    public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
        this.encode(key, values);
        return this;
    }

    public SharedPreferences.Editor putBytes(String key, @Nullable byte[] bytes) {
        this.encode(key, bytes);
        return this;
    }

    public byte[] getBytes(String key, @Nullable byte[] defValue) {
        return this.decodeBytes(key, defValue);
    }

    public int getInt(String key, int defValue) {
        return this.decodeInt(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putInt(String key, int value) {
        this.encodeInt(this.nativeHandle, key, value);
        return this;
    }

    public long getLong(String key, long defValue) {
        return this.decodeLong(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putLong(String key, long value) {
        this.encodeLong(this.nativeHandle, key, value);
        return this;
    }

    public float getFloat(String key, float defValue) {
        return this.decodeFloat(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putFloat(String key, float value) {
        this.encodeFloat(this.nativeHandle, key, value);
        return this;
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.decodeBool(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putBoolean(String key, boolean value) {
        this.encodeBool(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor remove(String key) {
        this.removeValueForKey(key);
        return this;
    }

    public SharedPreferences.Editor clear() {
        this.clearAll();
        return this;
    }

    public boolean commit() {
        this.sync(true);
        return true;
    }

    public void apply() {
        this.sync(false);
    }

    public boolean contains(String key) {
        return this.containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return this;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implement in MMKV");
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implement in MMKV");
    }

    public static MMKV mmkvWithAshmemFD(String mmapID, int fd, int metaFD, String cryptKey) {
        long handle = MMKV.getMMKVWithAshmemFD(mmapID, fd, metaFD, cryptKey);
        return new MMKV(handle);
    }

    public native int ashmemFD();

    public native int ashmemMetaFD();

    public static NativeBuffer createNativeBuffer(int size) {
        long pointer = MMKV.createNB(size);
        if (pointer <= 0L) {
            return null;
        }
        return new NativeBuffer(pointer, size);
    }

    public static void destroyNativeBuffer(NativeBuffer buffer) {
        MMKV.destroyNB(buffer.pointer, buffer.size);
    }

    public int writeValueToNativeBuffer(String key, NativeBuffer buffer) {
        return this.writeValueToNB(this.nativeHandle, key, buffer.pointer, buffer.size);
    }

    public static void registerHandler(MMKVHandler handler) {
        gCallbackHandler = handler;
        if (gCallbackHandler.wantLogRedirecting()) {
            MMKV.setCallbackHandler(true, true);
            gWantLogReDirecting = true;
        } else {
            MMKV.setCallbackHandler(false, true);
            gWantLogReDirecting = false;
        }
    }

    public static void unregisterHandler() {
        gCallbackHandler = null;
        MMKV.setCallbackHandler(false, false);
        gWantLogReDirecting = false;
    }

    private static int onMMKVCRCCheckFail(String mmapID) {
        MMKVRecoverStrategic strategic = MMKVRecoverStrategic.OnErrorDiscard;
        if (gCallbackHandler != null) {
            strategic = gCallbackHandler.onMMKVCRCCheckFail(mmapID);
        }
        MMKV.simpleLog(MMKVLogLevel.LevelInfo, "Recover strategic for " + mmapID + " is " + (Object)((Object)strategic));
        Integer value = recoverIndex.get((Object)strategic);
        return value == null ? 0 : value;
    }

    private static int onMMKVFileLengthError(String mmapID) {
        MMKVRecoverStrategic strategic = MMKVRecoverStrategic.OnErrorDiscard;
        if (gCallbackHandler != null) {
            strategic = gCallbackHandler.onMMKVFileLengthError(mmapID);
        }
        MMKV.simpleLog(MMKVLogLevel.LevelInfo, "Recover strategic for " + mmapID + " is " + (Object)((Object)strategic));
        Integer value = recoverIndex.get((Object)strategic);
        return value == null ? 0 : value;
    }

    private static void mmkvLogImp(int level, String file, int line, String function, String message) {
        if (gCallbackHandler != null && gWantLogReDirecting) {
            gCallbackHandler.mmkvLog(index2LogLevel[level], file, line, function, message);
        } else {
            switch (index2LogLevel[level]) {
                case LevelDebug: {
                    Log.d((String)"MMKV", (String)message);
                    break;
                }
                case LevelInfo: {
                    Log.i((String)"MMKV", (String)message);
                    break;
                }
                case LevelWarning: {
                    Log.w((String)"MMKV", (String)message);
                    break;
                }
                case LevelError: {
                    Log.e((String)"MMKV", (String)message);
                    break;
                }
            }
        }
    }

    private static void simpleLog(MMKVLogLevel level, String message) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stacktrace[stacktrace.length - 1];
        Integer i = logLevel2Index.get((Object)level);
        int intLevel = i == null ? 0 : i;
        MMKV.mmkvLogImp(intLevel, e.getFileName(), e.getLineNumber(), e.getMethodName(), message);
    }

    public static void registerContentChangeNotify(MMKVContentChangeNotification notify) {
        gContentChangeNotify = notify;
        MMKV.setWantsContentChangeNotify(gContentChangeNotify != null);
    }

    public static void unregisterContentChangeNotify() {
        gContentChangeNotify = null;
        MMKV.setWantsContentChangeNotify(false);
    }

    private static void onContentChangedByOuterProcess(String mmapID) {
        if (gContentChangeNotify != null) {
            gContentChangeNotify.onContentChangedByOuterProcess(mmapID);
        }
    }

    private static native void setWantsContentChangeNotify(boolean var0);

    public native void checkContentChangedByOuterProcess();

    private MMKV(long handle) {
        this.nativeHandle = handle;
    }

    private static native void jniInitialize(String var0, int var1);

    private static native long getMMKVWithID(String var0, int var1, String var2, String var3);

    private static native long getMMKVWithIDAndSize(String var0, int var1, int var2, String var3);

    private static native long getDefaultMMKV(int var0, String var1);

    private static native long getMMKVWithAshmemFD(String var0, int var1, int var2, String var3);

    private native boolean encodeBool(long var1, String var3, boolean var4);

    private native boolean decodeBool(long var1, String var3, boolean var4);

    private native boolean encodeInt(long var1, String var3, int var4);

    private native int decodeInt(long var1, String var3, int var4);

    private native boolean encodeLong(long var1, String var3, long var4);

    private native long decodeLong(long var1, String var3, long var4);

    private native boolean encodeFloat(long var1, String var3, float var4);

    private native float decodeFloat(long var1, String var3, float var4);

    private native boolean encodeDouble(long var1, String var3, double var4);

    private native double decodeDouble(long var1, String var3, double var4);

    private native boolean encodeString(long var1, String var3, String var4);

    private native String decodeString(long var1, String var3, String var4);

    private native boolean encodeSet(long var1, String var3, String[] var4);

    private native String[] decodeStringSet(long var1, String var3);

    private native boolean encodeBytes(long var1, String var3, byte[] var4);

    private native byte[] decodeBytes(long var1, String var3);

    private native boolean containsKey(long var1, String var3);

    private native long count(long var1);

    private native long totalSize(long var1);

    private native void removeValueForKey(long var1, String var3);

    private native int valueSize(long var1, String var3, boolean var4);

    private static native void setLogLevel(int var0);

    private static native void setCallbackHandler(boolean var0, boolean var1);

    private static native long createNB(int var0);

    private static native void destroyNB(long var0, int var2);

    private native int writeValueToNB(long var1, String var3, long var4, int var6);

    private static native boolean checkProcessMode(long var0);

    static {
        recoverIndex.put(MMKVRecoverStrategic.OnErrorDiscard, 0);
        recoverIndex.put(MMKVRecoverStrategic.OnErrorRecover, 1);
        logLevel2Index = new EnumMap(MMKVLogLevel.class);
        logLevel2Index.put(MMKVLogLevel.LevelDebug, 0);
        logLevel2Index.put(MMKVLogLevel.LevelInfo, 1);
        logLevel2Index.put(MMKVLogLevel.LevelWarning, 2);
        logLevel2Index.put(MMKVLogLevel.LevelError, 3);
        logLevel2Index.put(MMKVLogLevel.LevelNone, 4);
        index2LogLevel = new MMKVLogLevel[]{MMKVLogLevel.LevelDebug, MMKVLogLevel.LevelInfo, MMKVLogLevel.LevelWarning, MMKVLogLevel.LevelError, MMKVLogLevel.LevelNone};
        checkedHandleSet = new HashSet();
        rootDir = null;
        mCreators = new HashMap();
        gWantLogReDirecting = false;
    }

    public static interface LibLoader {
        public void loadLibrary(String var1);
    }
}

