/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelbiz;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.utils.Log;

public class JumpToBizProfile {
    public static final int JUMP_TO_NORMAL_BIZ_PROFILE = 0;
    public static final int JUMP_TO_HARD_WARE_BIZ_PROFILE = 1;

    public static class Req
    extends BaseReq {
        private static final String TAG = "MicroMsg.SDK.JumpToBizProfile.Req";
        private static final int EXT_MSG_LENGTH = 1024;
        public String toUserName;
        public String extMsg;
        public int profileType = 0;

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public boolean checkArgs() {
            if (this.toUserName == null || this.toUserName.length() == 0) {
                Log.e(TAG, "checkArgs fail, toUserName is invalid");
                return false;
            }
            if (this.extMsg != null && this.extMsg.length() > 1024) {
                Log.e(TAG, "ext msg is not null, while the length exceed 1024 bytes");
                return false;
            }
            if (this.profileType == 1 && (this.extMsg == null || this.extMsg.length() == 0)) {
                Log.e(TAG, "scene is jump to hardware profile, while extmsg is null");
                return false;
            }
            return true;
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putString("_wxapi_jump_to_biz_profile_req_to_user_name", this.toUserName);
            bundle.putString("_wxapi_jump_to_biz_profile_req_ext_msg", this.extMsg);
            bundle.putInt("_wxapi_jump_to_biz_profile_req_scene", 0);
            bundle.putInt("_wxapi_jump_to_biz_profile_req_profile_type", this.profileType);
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.toUserName = bundle.getString("_wxapi_jump_to_biz_profile_req_to_user_name");
            this.extMsg = bundle.getString("_wxapi_jump_to_biz_profile_req_ext_msg");
        }
    }
}

