/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelbiz;

import android.os.Bundle;
import android.util.Log;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class AddCardToWXCardPackage {
    private static final String TAG = "MicroMsg.AddCardToWXCardPackage";

    public static class Resp
    extends BaseResp {
        public List<WXCardItem> cardArrary;

        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public boolean checkArgs() {
            return this.cardArrary != null && this.cardArrary.size() != 0;
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (WXCardItem wXCardItem : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)wXCardItem.cardId);
                    jSONStringer.key("card_ext");
                    jSONStringer.value((Object)(wXCardItem.cardExtMsg == null ? "" : wXCardItem.cardExtMsg));
                    jSONStringer.key("is_succ");
                    jSONStringer.value((long)wXCardItem.cardState);
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                Log.e((String)AddCardToWXCardPackage.TAG, (String)("Resp.toBundle exception:" + exception.getMessage()));
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }

        @Override
        public void fromBundle(Bundle object) {
            super.fromBundle((Bundle)object);
            if (this.cardArrary == null) {
                this.cardArrary = new LinkedList<WXCardItem>();
            }
            if ((object = object.getString("_wxapi_add_card_to_wx_card_list")) != null && ((String)object).length() > 0) {
                try {
                    object = ((JSONObject)new JSONTokener((String)object).nextValue()).getJSONArray("card_list");
                    for (int i = 0; i < object.length(); ++i) {
                        JSONObject jSONObject = object.getJSONObject(i);
                        WXCardItem wXCardItem = new WXCardItem();
                        new WXCardItem().cardId = jSONObject.optString("card_id");
                        wXCardItem.cardExtMsg = jSONObject.optString("card_ext");
                        wXCardItem.cardState = jSONObject.optInt("is_succ");
                        this.cardArrary.add(wXCardItem);
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class Req
    extends BaseReq {
        public List<WXCardItem> cardArrary;

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public boolean checkArgs() {
            if (this.cardArrary == null || this.cardArrary.size() == 0 || this.cardArrary.size() > 40) {
                return false;
            }
            for (WXCardItem wXCardItem : this.cardArrary) {
                if (wXCardItem != null && wXCardItem.cardId != null && wXCardItem.cardId.length() <= 1024 && (wXCardItem.cardExtMsg == null || wXCardItem.cardExtMsg.length() <= 1024)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (WXCardItem wXCardItem : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)wXCardItem.cardId);
                    jSONStringer.key("card_ext");
                    jSONStringer.value((Object)(wXCardItem.cardExtMsg == null ? "" : wXCardItem.cardExtMsg));
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                Log.e((String)AddCardToWXCardPackage.TAG, (String)("Req.toBundle exception:" + exception.getMessage()));
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }
    }

    public static final class WXCardItem {
        public String cardId;
        public String cardExtMsg;
        public int cardState;
    }
}

