/*
 * Decompiled with CFR 0.152.
 */
package tinker.net.dongliu.apk.parser.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ResourceLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, String> loadSystemAttrIds() {
        try (BufferedReader reader = ResourceLoader.toReader("/r_values.ini");){
            String line;
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            while ((line = reader.readLine()) != null) {
                String[] items = line.trim().split("=");
                if (items.length != 2) continue;
                String name = items[0].trim();
                Integer id = Integer.valueOf(items[1].trim());
                map.put(id, name);
            }
            HashMap<Integer, String> hashMap = map;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<Integer, String> loadSystemStyles() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        try (BufferedReader reader = ResourceLoader.toReader("/r_styles.ini");){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] items = (line = line.trim()).split("=");
                if (items.length != 2) continue;
                Integer id = Integer.valueOf(items[1].trim());
                String name = items[0].trim();
                map.put(id, name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static BufferedReader toReader(String path) {
        return new BufferedReader(new InputStreamReader(ResourceLoader.class.getResourceAsStream(path)));
    }
}

