/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mars.xlog;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.tencent.mars.xlog.Xlog;

public class Log {
    private static final String TAG = "mars.xlog.log";
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    public static final int LEVEL_NONE = 6;
    private static int level = 6;
    public static Context toastSupportContext = null;
    private static LogImp debugLog;
    private static LogImp logImp;
    private static final String SYS_INFO;

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void appenderClose() {
        if (logImp != null) {
            logImp.appenderClose();
        }
    }

    public static void appenderFlush(boolean isSync) {
        if (logImp != null) {
            logImp.appenderFlush(isSync);
        }
    }

    public static int getLogLevel() {
        if (logImp != null) {
            return logImp.getLogLevel();
        }
        return 6;
    }

    public static void setLevel(int level, boolean jni) {
        Log.level = level;
        android.util.Log.w((String)TAG, (String)("new log level: " + level));
        if (jni) {
            Xlog.setLogLevel(level);
        }
    }

    public static void f(String tag, String msg) {
        Log.f(tag, msg, null);
    }

    public static void e(String tag, String msg) {
        Log.e(tag, msg, null);
    }

    public static void w(String tag, String msg) {
        Log.w(tag, msg, null);
    }

    public static void i(String tag, String msg) {
        Log.i(tag, msg, null);
    }

    public static void d(String tag, String msg) {
        Log.d(tag, msg, null);
    }

    public static void v(String tag, String msg) {
        Log.v(tag, msg, null);
    }

    public static void f(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log = obj == null ? format : String.format(format, obj);
            logImp.logF(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void e(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logE(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void w(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logW(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void i(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logI(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void d(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logD(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void v(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logV(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            log = log + "  " + android.util.Log.getStackTraceString((Throwable)tr);
            logImp.logE(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static String getSysInfo() {
        return SYS_INFO;
    }

    static {
        logImp = debugLog = new LogImp(){
            private Handler handler = new Handler(Looper.getMainLooper());

            @Override
            public void logV(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 0) {
                    android.util.Log.v((String)tag, (String)log);
                }
            }

            @Override
            public void logI(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 2) {
                    android.util.Log.i((String)tag, (String)log);
                }
            }

            @Override
            public void logD(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 1) {
                    android.util.Log.d((String)tag, (String)log);
                }
            }

            @Override
            public void logW(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 3) {
                    android.util.Log.w((String)tag, (String)log);
                }
            }

            @Override
            public void logE(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 4) {
                    android.util.Log.e((String)tag, (String)log);
                }
            }

            @Override
            public void logF(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, final String log) {
                if (level > 5) {
                    return;
                }
                android.util.Log.e((String)tag, (String)log);
                if (toastSupportContext != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)toastSupportContext, (CharSequence)log, (int)1).show();
                        }
                    });
                }
            }

            @Override
            public int getLogLevel() {
                return level;
            }

            @Override
            public void appenderClose() {
            }

            @Override
            public void appenderFlush(boolean isSync) {
            }
        };
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("VERSION.RELEASE:[" + Build.VERSION.RELEASE);
            sb.append("] VERSION.CODENAME:[" + Build.VERSION.CODENAME);
            sb.append("] VERSION.INCREMENTAL:[" + Build.VERSION.INCREMENTAL);
            sb.append("] BOARD:[" + Build.BOARD);
            sb.append("] DEVICE:[" + Build.DEVICE);
            sb.append("] DISPLAY:[" + Build.DISPLAY);
            sb.append("] FINGERPRINT:[" + Build.FINGERPRINT);
            sb.append("] HOST:[" + Build.HOST);
            sb.append("] MANUFACTURER:[" + Build.MANUFACTURER);
            sb.append("] MODEL:[" + Build.MODEL);
            sb.append("] PRODUCT:[" + Build.PRODUCT);
            sb.append("] TAGS:[" + Build.TAGS);
            sb.append("] TYPE:[" + Build.TYPE);
            sb.append("] USER:[" + Build.USER + "]");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SYS_INFO = sb.toString();
    }

    public static interface LogImp {
        public void logV(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logI(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logD(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logW(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logE(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logF(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public int getLogLevel();

        public void appenderClose();

        public void appenderFlush(boolean var1);
    }
}

