/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.tencent.rtmp.sharp.jni.QLog;
import com.tencent.rtmp.sharp.jni.TraeAudioCodecList;
import com.tencent.rtmp.sharp.jni.TraeAudioManager;
import com.tencent.rtmp.sharp.jni.TraeAudioSession;
import com.tencent.rtmp.sharp.jni.VivoKTVHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=16)
public class AudioDeviceInterface {
    private static final String TAG = "AudioDeviceInterface";
    private AudioTrack _audioTrack;
    private AudioRecord _audioRecord;
    private int _streamType;
    private int _playSamplerate;
    private int _channelOutType;
    private int _audioSource;
    private int _deviceStat;
    private int _sceneMode;
    private int _sessionId;
    private Context _context;
    private int _modePolicy;
    private int _audioSourcePolicy;
    private int _audioStreamTypePolicy;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private ByteBuffer _decBuffer0;
    private ByteBuffer _decBuffer1;
    private ByteBuffer _decBuffer2;
    private ByteBuffer _decBuffer3;
    private ByteBuffer _decBuffer4;
    private ByteBuffer _decBuffer5;
    private ByteBuffer _decBuffer6;
    private ByteBuffer _decBuffer7;
    private ByteBuffer _decBuffer8;
    private ByteBuffer _decBuffer9;
    private ByteBuffer _decBuffer10;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private boolean _doPlayInit;
    private boolean _doRecInit;
    private boolean _isRecording;
    private boolean _isPlaying;
    private int _bufferedRecSamples;
    private int _bufferedPlaySamples;
    private int _playPosition;
    private File _rec_dump;
    private File _play_dump;
    private FileOutputStream _rec_out;
    private FileOutputStream _play_out;
    private static boolean _dumpEnable = false;
    private static boolean _logEnable = true;
    private int nRecordLengthMs;
    private int nPlayLengthMs;
    private TraeAudioCodecList _traeAudioCodecList;
    private static String[] mDeviceList = null;
    private static VivoKTVHelper mVivoKTVHelper = null;
    private static boolean isSupportVivoKTVHelper = false;
    private TraeAudioSession _as;
    private String _connectedDev;
    private boolean _audioRouteChanged;
    private ReentrantLock _prelock;
    private Condition _precon;
    private boolean _preDone;
    private boolean usingJava;
    private int switchState;
    private TraeAudioSession _asAudioManager;
    public static final int OUTPUT_MODE_HEADSET = 0;
    public static final int OUTPUT_MODE_SPEAKER = 1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i2 = 3; i2 < string.length(); ++i2) {
                    if (string.charAt(i2) >= '0' && string.charAt(i2) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public AudioDeviceInterface() {
        block7: {
            this._audioTrack = null;
            this._audioRecord = null;
            this._streamType = 0;
            this._playSamplerate = 8000;
            this._channelOutType = 4;
            this._audioSource = 0;
            this._deviceStat = 0;
            this._sceneMode = 0;
            this._sessionId = 0;
            this._context = null;
            this._modePolicy = -1;
            this._audioSourcePolicy = -1;
            this._audioStreamTypePolicy = -1;
            this._audioManager = null;
            this._doPlayInit = true;
            this._doRecInit = true;
            this._isRecording = false;
            this._isPlaying = false;
            this._bufferedRecSamples = 0;
            this._bufferedPlaySamples = 0;
            this._playPosition = 0;
            this._rec_dump = null;
            this._play_dump = null;
            this._rec_out = null;
            this._play_out = null;
            this.nRecordLengthMs = 0;
            this.nPlayLengthMs = 0;
            this._traeAudioCodecList = null;
            this._as = null;
            this._connectedDev = "DEVICE_NONE";
            this._audioRouteChanged = false;
            this._prelock = new ReentrantLock();
            this._precon = this._prelock.newCondition();
            this._preDone = false;
            this.usingJava = true;
            this.switchState = 0;
            this._asAudioManager = null;
            try {
                this._playBuffer = ByteBuffer.allocateDirect(1920);
                this._recBuffer = ByteBuffer.allocateDirect(1920);
                this._decBuffer0 = ByteBuffer.allocateDirect(3840);
                this._decBuffer1 = ByteBuffer.allocateDirect(3840);
                this._decBuffer2 = ByteBuffer.allocateDirect(3840);
                this._decBuffer3 = ByteBuffer.allocateDirect(3840);
                this._decBuffer4 = ByteBuffer.allocateDirect(3840);
                this._decBuffer5 = ByteBuffer.allocateDirect(3840);
                this._decBuffer6 = ByteBuffer.allocateDirect(3840);
                this._decBuffer7 = ByteBuffer.allocateDirect(3840);
                this._decBuffer8 = ByteBuffer.allocateDirect(3840);
                this._decBuffer9 = ByteBuffer.allocateDirect(3840);
                this._decBuffer10 = ByteBuffer.allocateDirect(3840);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block7;
                QLog.w(TAG, 2, exception.getMessage());
            }
        }
        this._tempBufPlay = new byte[1920];
        this._tempBufRec = new byte[1920];
        this._traeAudioCodecList = new TraeAudioCodecList();
        int n2 = Build.VERSION.SDK_INT;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "AudioDeviceInterface apiLevel:" + n2);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, " SDK_INT:" + Build.VERSION.SDK_INT);
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "manufacture:" + Build.MANUFACTURER);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "MODEL:" + Build.MODEL);
        }
    }

    public void setContext(Context context) {
        this._context = context;
    }

    private int getLowlatencySamplerate() {
        if (this._context == null || Build.VERSION.SDK_INT < 9) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "getLowlatencySamplerate err, _context:" + this._context + " api:" + Build.VERSION.SDK_INT);
            }
            return 0;
        }
        PackageManager packageManager = this._context.getPackageManager();
        boolean bl = packageManager.hasSystemFeature("android.hardware.audio.low_latency");
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "LOW_LATENCY:" + (bl ? "Y" : "N"));
        }
        if (Build.VERSION.SDK_INT < 17) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
            }
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 2, "getLowlatencySamplerate not support right now!");
        }
        return 0;
    }

    private int getLowlatencyFramesPerBuffer() {
        if (this._context == null || Build.VERSION.SDK_INT < 9) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "getLowlatencySamplerate err, _context:" + this._context + " api:" + Build.VERSION.SDK_INT);
            }
            return 0;
        }
        PackageManager packageManager = this._context.getPackageManager();
        boolean bl = packageManager.hasSystemFeature("android.hardware.audio.low_latency");
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "LOW_LATENCY:" + (bl ? "Y" : "N"));
        }
        if (Build.VERSION.SDK_INT < 17) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
            }
            return 0;
        }
        return 0;
    }

    @TargetApi(value=16)
    private int getAudioSessionId(AudioRecord audioRecord) {
        return 0;
    }

    private int InitSetting(int n2, int n3, int n4, int n5, int n6) {
        this._audioSourcePolicy = n2;
        this._audioStreamTypePolicy = n3;
        this._modePolicy = n4;
        this._deviceStat = n5;
        this._sceneMode = n6;
        TraeAudioManager.IsMusicScene = this._deviceStat == 1 || this._deviceStat == 5 || this._deviceStat == 2 || this._deviceStat == 3;
        TraeAudioManager.IsEarPhoneSupported = this._sceneMode == 0 || this._sceneMode == 4;
        TraeAudioManager.IsUpdateSceneFlag = true;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitSetting: _audioSourcePolicy:" + this._audioSourcePolicy + " _audioStreamTypePolicy:" + this._audioStreamTypePolicy + " _modePolicy:" + this._modePolicy + " DeviceStat:" + n5 + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper);
        }
        return 0;
    }

    private int InitRecording(int n2, int n3) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitRecording entry:" + n2);
        }
        if (this._isRecording || this._audioRecord != null || n3 > 2) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "InitRecording _isRecording:" + this._isRecording);
            }
            return -1;
        }
        int n4 = 16;
        if (n3 == 2) {
            n4 = 12;
        }
        int n5 = AudioRecord.getMinBufferSize((int)n2, (int)n4, (int)2);
        int n6 = 20 * n2 * n3 * 2 / 1000;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitRecording: min rec buf size is " + n5 + " sr:" + this.getLowlatencySamplerate() + " fp" + this.getLowlatencyFramesPerBuffer() + " 20msFZ:" + n6);
        }
        this._bufferedRecSamples = 5 * n2 / 200;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "  rough rec delay set to " + this._bufferedRecSamples);
        }
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        int[] nArray = new int[]{0, 1, 5, 0};
        nArray[0] = TraeAudioManager.getAudioSource(this._audioSourcePolicy);
        int n7 = n5;
        block2: for (int i2 = 0; i2 < nArray.length && this._audioRecord == null; ++i2) {
            this._audioSource = nArray[i2];
            for (int i3 = 1; i3 <= 2; ++i3) {
                n7 = n5 * i3;
                if (n7 < n6 * 4 && i3 < 2) continue;
                try {
                    this.nRecordLengthMs = n7 * 500 / (n2 * n3);
                    this._audioRecord = new AudioRecord(this._audioSource, n2, n4, 2, n7);
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, exception.getMessage() + " _audioRecord:" + this._audioRecord);
                    }
                    if (this._audioRecord != null) {
                        this._audioRecord.release();
                    }
                    this._audioRecord = null;
                    continue;
                }
                if (this._audioRecord.getState() == 1) continue block2;
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "InitRecording:  rec not initialized,try agine,  minbufsize:" + n7 + " sr:" + n2 + " as:" + this._audioSource);
                }
                this._audioRecord.release();
                this._audioRecord = null;
            }
        }
        if (this._audioRecord == null) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "InitRecording fail!!!");
            }
            return -1;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, " [Config] InitRecording: audioSession:" + this._sessionId + " audioSource:" + this._audioSource + " rec sample rate set to " + n2 + " recBufSize:" + n7 + " nRecordLengthMs:" + this.nRecordLengthMs);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitRecording exit");
        }
        return this._bufferedRecSamples;
    }

    private int InitPlayback(int n2, int n3) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitPlayback entry: sampleRate " + n2);
        }
        if (this._isPlaying || this._audioTrack != null || n3 > 2) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "InitPlayback _isPlaying:" + this._isPlaying);
            }
            return -1;
        }
        if (this._audioManager == null) {
            try {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, exception.getMessage());
                }
                return -1;
            }
        }
        this._channelOutType = n3 == 2 ? 12 : 4;
        this._playSamplerate = n2;
        int n4 = AudioTrack.getMinBufferSize((int)n2, (int)this._channelOutType, (int)2);
        if (this._channelOutType == 12) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "InitPlayback, _channelOutType stero");
            } else if (this._channelOutType == 4 && QLog.isColorLevel()) {
                QLog.w(TAG, 2, "InitPlayback, _channelOutType Mono");
            }
        }
        int n5 = 20 * n2 * 1 * 2 / 1000;
        if (this._channelOutType == 12) {
            n5 *= 2;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitPlayback: minPlayBufSize:" + n4 + " 20msFz:" + n5);
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        int[] nArray = new int[]{0, 0, 3, 1};
        this._streamType = TraeAudioManager.getAudioStreamType(this._audioStreamTypePolicy);
        if (this._audioRouteChanged) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_audioRouteChanged:" + this._audioRouteChanged + " _streamType:" + this._streamType);
            }
            this._streamType = this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
            this._audioRouteChanged = false;
        }
        nArray[0] = this._streamType;
        int n6 = n4;
        block4: for (int i2 = 0; i2 < nArray.length && this._audioTrack == null; ++i2) {
            this._streamType = nArray[i2];
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "InitPlayback: min play buf size is " + n4 + " hw_sr:" + AudioTrack.getNativeOutputSampleRate((int)this._streamType));
            }
            for (int i3 = 1; i3 <= 2; ++i3) {
                n6 = n4 * i3;
                if (n6 < n5 * 4 && i3 < 2) continue;
                try {
                    this.nPlayLengthMs = n6 * 500 / (n2 * n3);
                    this._audioTrack = new AudioTrack(this._streamType, this._playSamplerate, this._channelOutType, 2, n6, 1);
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, exception.getMessage() + " _audioTrack:" + this._audioTrack);
                    }
                    if (this._audioTrack != null) {
                        this._audioTrack.release();
                    }
                    this._audioTrack = null;
                    continue;
                }
                if (this._audioTrack.getState() == 1) continue block4;
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "InitPlayback: play not initialized playBufSize:" + n6 + " sr:" + this._playSamplerate);
                }
                this._audioTrack.release();
                this._audioTrack = null;
            }
        }
        if (this._audioTrack == null) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "InitPlayback fail!!!");
            }
            return -1;
        }
        if (this._as != null && this._audioManager != null) {
            this._as.voiceCallAudioParamChanged(this._audioManager.getMode(), this._streamType);
        }
        this._playPosition = this._audioTrack.getPlaybackHeadPosition();
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InitPlayback exit: streamType:" + this._streamType + " samplerate:" + this._playSamplerate + " _playPosition:" + this._playPosition + " playBufSize:" + n6 + " nPlayLengthMs:" + this.nPlayLengthMs);
        }
        TraeAudioManager.forceVolumeControlStream(this._audioManager, this._connectedDev.equals("DEVICE_BLUETOOTHHEADSET") ? 6 : this._audioTrack.getStreamType());
        return 0;
    }

    private int getPlayRecordSysBufferMs() {
        return (this.nRecordLengthMs + this.nPlayLengthMs) * 2;
    }

    private String getDumpFilePath(String string, int n2) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "manufacture:" + Build.MANUFACTURER);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "MODEL:" + Build.MODEL);
        }
        if (this._context == null) {
            return null;
        }
        File file = this._context.getExternalFilesDir(null);
        if (file == null) {
            return null;
        }
        String string2 = file.getPath() + "/MF-" + Build.MANUFACTURER + "-M-" + Build.MODEL + "-as-" + TraeAudioManager.getAudioSource(this._audioSourcePolicy) + "-st-" + this._streamType + "-m-" + n2 + "-" + string;
        File file2 = new File(string2);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "dump:" + string2);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "dump replace:" + string2.replace(" ", "_"));
        }
        return string2.replace(" ", "_");
    }

    private int StartRecording() {
        block12: {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "StartRecording entry");
            }
            if (this._isRecording) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartRecording _isRecording:" + this._isRecording);
                }
                return -1;
            }
            if (this._audioRecord == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartRecording _audioRecord:" + this._audioRecord);
                }
                return -1;
            }
            try {
                this._audioRecord.startRecording();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartRecording fail");
                }
                illegalStateException.printStackTrace();
                return -1;
            }
            if (_dumpEnable) {
                this._rec_dump = new File(this.getDumpFilePath("jnirecord.pcm", this._audioManager != null ? this._audioManager.getMode() : -1));
                try {
                    this._rec_out = new FileOutputStream(this._rec_dump);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!QLog.isColorLevel()) break block12;
                    QLog.e(TAG, 2, "open rec dump file failed.");
                }
            }
        }
        this._isRecording = true;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StartRecording ok");
        }
        return 0;
    }

    private int StartPlayback() {
        block11: {
            if (this._isPlaying) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartPlayback _isPlaying");
                }
                return -1;
            }
            if (this._audioTrack == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartPlayback _audioTrack:" + this._audioTrack);
                }
                return -1;
            }
            try {
                this._audioTrack.play();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StartPlayback fail");
                }
                return -1;
            }
            if (_dumpEnable) {
                this._play_dump = new File(this.getDumpFilePath("jniplay.pcm", this._audioManager != null ? this._audioManager.getMode() : -1));
                try {
                    this._play_out = new FileOutputStream(this._play_dump);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!QLog.isColorLevel()) break block11;
                    QLog.e(TAG, 2, "open play dump file failed.");
                }
            }
        }
        this._isPlaying = true;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StartPlayback ok");
        }
        return 0;
    }

    private int StopRecording() {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopRecording entry");
        }
        if (this._audioRecord == null) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "UnintRecord:" + this._audioRecord);
            }
            return -1;
        }
        if (this._audioRecord.getRecordingState() == 3) {
            try {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "StopRecording stop... state:" + this._audioRecord.getRecordingState());
                }
                this._audioRecord.stop();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StopRecording  err");
                }
                return -1;
            }
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopRecording releaseing... state:" + this._audioRecord.getRecordingState());
        }
        this._audioRecord.release();
        this._audioRecord = null;
        this._isRecording = false;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopRecording exit ok");
        }
        return 0;
    }

    private int StopPlayback() {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopPlayback entry _isPlaying:" + this._isPlaying);
        }
        if (this._audioTrack == null) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "StopPlayback _isPlaying:" + this._isPlaying + " " + this._audioTrack);
            }
            return -1;
        }
        if (this._audioTrack.getPlayState() == 3) {
            try {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "StopPlayback stoping...");
                }
                this._audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "StopPlayback err");
                }
                return -1;
            }
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "StopPlayback flushing... state:" + this._audioTrack.getPlayState());
            }
            this._audioTrack.flush();
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopPlayback releaseing... state:" + this._audioTrack.getPlayState());
        }
        this._audioTrack.release();
        this._audioTrack = null;
        this._isPlaying = false;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "StopPlayback exit ok");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int n2) {
        int n3;
        block49: {
            int n4;
            block50: {
                boolean bl;
                block46: {
                    block44: {
                        n3 = 0;
                        if (!this._isPlaying | this._audioTrack == null) {
                            if (QLog.isColorLevel()) {
                                QLog.e(TAG, 2, "PlayAudio: _isPlaying " + this._isPlaying + " " + this._audioTrack);
                            }
                            return -1;
                        }
                        n4 = 0;
                        if (this._audioTrack != null) break block44;
                        int n5 = -2;
                        return n5;
                    }
                    if (this._doPlayInit) {
                        block45: {
                            try {
                                Process.setThreadPriority((int)-19);
                                Thread.currentThread().setName("TRAEAudioPlay");
                            }
                            catch (Exception exception) {
                                if (!QLog.isColorLevel()) break block45;
                                QLog.w(TAG, 2, "Set play thread priority failed: " + exception.getMessage());
                            }
                        }
                        this._doPlayInit = false;
                    }
                    if (_dumpEnable && this._play_out != null) {
                        try {
                            this._play_out.write(this._tempBufPlay, 0, n3);
                        }
                        catch (IOException iOException) {
                            if (!QLog.isColorLevel()) break block46;
                            QLog.e(TAG, 2, "write data failed.");
                        }
                    }
                }
                if (!this._audioRouteChanged) {
                    bl = false;
                } else {
                    if (this._audioManager == null && this._context != null) {
                        this._audioManager = (AudioManager)this._context.getSystemService("audio");
                    }
                    this._streamType = this._audioManager != null && this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                    bl = this._streamType != this._audioTrack.getStreamType();
                    this._audioRouteChanged = false;
                }
                this._playBuffer.get(this._tempBufPlay);
                if (bl) {
                    long l2;
                    block48: {
                        block47: {
                            n3 = n2;
                            this._playBuffer.rewind();
                            l2 = SystemClock.elapsedRealtime();
                            if (QLog.isColorLevel()) {
                                QLog.w(TAG, 2, " track resting: _streamType:" + this._streamType + " at.st:" + this._audioTrack.getStreamType());
                            }
                            if (this._audioTrack.getPlayState() == 3) {
                                try {
                                    if (QLog.isColorLevel()) {
                                        QLog.w(TAG, 2, "StopPlayback stoping...");
                                    }
                                    this._audioTrack.stop();
                                    this._audioTrack.flush();
                                    if (QLog.isColorLevel()) {
                                        QLog.w(TAG, 2, "StopPlayback flushing... state:" + this._audioTrack.getPlayState());
                                    }
                                    this._audioTrack.release();
                                    if (QLog.isColorLevel()) {
                                        QLog.w(TAG, 2, "StopPlayback releaseing... state:" + this._audioTrack.getPlayState());
                                    }
                                    this._audioTrack = null;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (!QLog.isColorLevel()) break block47;
                                    QLog.e(TAG, 2, "StopPlayback err");
                                }
                            }
                        }
                        int n6 = AudioTrack.getMinBufferSize((int)this._playSamplerate, (int)this._channelOutType, (int)2);
                        int[] nArray = new int[]{0, 0, 3, 1};
                        nArray[0] = this._streamType;
                        int n7 = 20 * this._playSamplerate * 1 * 2 / 1000;
                        if (this._channelOutType == 12) {
                            n7 *= 2;
                        }
                        block16: for (int i2 = 0; i2 < nArray.length && this._audioTrack == null; ++i2) {
                            this._streamType = nArray[i2];
                            if (QLog.isColorLevel()) {
                                QLog.w(TAG, 2, "InitPlayback: min play buf size is " + n6 + " hw_sr:" + AudioTrack.getNativeOutputSampleRate((int)this._streamType));
                            }
                            for (int i3 = 1; i3 <= 2; ++i3) {
                                int n8 = n6 * i3;
                                if (n8 < n7 * 4 && i3 < 2) continue;
                                try {
                                    this._audioTrack = new AudioTrack(this._streamType, this._playSamplerate, this._channelOutType, 2, n8, 1);
                                }
                                catch (Exception exception) {
                                    if (QLog.isColorLevel()) {
                                        QLog.w(TAG, 2, exception.getMessage() + " _audioTrack:" + this._audioTrack);
                                    }
                                    if (this._audioTrack != null) {
                                        this._audioTrack.release();
                                    }
                                    this._audioTrack = null;
                                    continue;
                                }
                                if (QLog.isColorLevel()) {
                                    QLog.w(TAG, 2, " _audioTrack:" + this._audioTrack);
                                }
                                if (this._audioTrack.getState() == 1) continue block16;
                                if (QLog.isColorLevel()) {
                                    QLog.w(TAG, 2, "InitPlayback: play not initialized playBufSize:" + n8 + " sr:" + this._playSamplerate);
                                }
                                this._audioTrack.release();
                                this._audioTrack = null;
                            }
                        }
                        if (this._audioTrack != null) {
                            try {
                                this._audioTrack.play();
                                this._as.voiceCallAudioParamChanged(this._audioManager.getMode(), this._streamType);
                                TraeAudioManager.forceVolumeControlStream(this._audioManager, this._connectedDev.equals("DEVICE_BLUETOOTHHEADSET") ? 6 : this._audioTrack.getStreamType());
                            }
                            catch (Exception exception) {
                                if (!QLog.isColorLevel()) break block48;
                                QLog.e(TAG, 2, "start play failed.");
                            }
                        }
                    }
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "  track reset used:" + (SystemClock.elapsedRealtime() - l2) + "ms");
                    }
                    break block49;
                }
                n3 = this._audioTrack.write(this._tempBufPlay, 0, n2);
                this._playBuffer.rewind();
                if (n3 >= 0) break block50;
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "Could not write data from sc (write = " + n3 + ", length = " + n2 + ")");
                }
                int n9 = -1;
                return n9;
            }
            try {
                if (n3 != n2 && QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "Could not write all data from sc (write = " + n3 + ", length = " + n2 + ")");
                }
                this._bufferedPlaySamples += n3 >> 1;
                int n10 = this._audioTrack.getPlaybackHeadPosition();
                if (n10 < this._playPosition) {
                    this._playPosition = 0;
                }
                this._bufferedPlaySamples -= n10 - this._playPosition;
                this._playPosition = n10;
                if (!this._isRecording) {
                    n4 = this._bufferedPlaySamples;
                }
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "PlayAudio Exception: " + exception.getMessage());
                }
            }
        }
        return n3;
    }

    private int OpenslesNeedResetAudioTrack(boolean bl) {
        block9: {
            block10: {
                block8: {
                    if (TraeAudioManager.isCloseSystemAPM(this._modePolicy)) break block8;
                    int n2 = -1;
                    return n2;
                }
                if (!this._audioRouteChanged && !bl) break block9;
                if (this._audioManager == null && this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) break block10;
                int n3 = 0;
                return n3;
            }
            try {
                this._audioStreamTypePolicy = this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                this._audioRouteChanged = false;
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "PlayAudio Exception: " + exception.getMessage());
                }
            }
        }
        return this._audioStreamTypePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int n2) {
        int n3;
        block20: {
            block18: {
                n3 = 0;
                if (!this._isRecording) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "RecordAudio: _isRecording " + this._isRecording);
                    }
                    return -1;
                }
                if (this._audioRecord != null) break block18;
                int n4 = -2;
                return n4;
            }
            if (this._doRecInit) {
                block19: {
                    try {
                        Process.setThreadPriority((int)-19);
                        Thread.currentThread().setName("TRAEAudioRecord");
                    }
                    catch (Exception exception) {
                        if (!QLog.isColorLevel()) break block19;
                        QLog.w(TAG, 2, "Set rec thread priority failed: " + exception.getMessage());
                    }
                }
                this._doRecInit = false;
            }
            this._recBuffer.rewind();
            n3 = this._audioRecord.read(this._tempBufRec, 0, n2);
            if (n3 >= 0) break block20;
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "Could not read data from sc (read = " + n3 + ", length = " + n2 + ")");
            }
            int n5 = -1;
            return n5;
        }
        try {
            block21: {
                this._recBuffer.put(this._tempBufRec, 0, n3);
                if (_dumpEnable && this._rec_out != null) {
                    try {
                        this._rec_out.write(this._tempBufRec, 0, n3);
                    }
                    catch (IOException iOException) {
                        if (!QLog.isColorLevel()) break block21;
                        QLog.e(TAG, 2, "write rec buffer failed.");
                    }
                }
            }
            if (n3 != n2) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "Could not read all data from sc (read = " + n3 + ", length = " + n2 + ")");
                }
                int n6 = -1;
                return n6;
            }
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "RecordAudio Exception: " + exception.getMessage());
            }
        }
        return n3;
    }

    private int SetPlayoutVolume(int n2) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n3 = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, n2, 0);
            n3 = 0;
        }
        return n3;
    }

    public int GetPlayoutVolume() {
        int n2;
        block3: {
            n2 = -1;
            try {
                if (this._audioManager == null && this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                n2 = this._audioManager != null ? this._audioManager.getStreamVolume(this._streamType) : -1;
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block3;
                QLog.w("TRAE GetPlayoutVolume", 2, exception.getMessage());
            }
        }
        return n2;
    }

    public static String getTraceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = stackTraceElementArray.length;
        stringBuffer.append("").append(stackTraceElementArray[2].getClassName()).append(".").append(stackTraceElementArray[2].getMethodName()).append(": ").append(stackTraceElementArray[2].getLineNumber());
        return stringBuffer.toString();
    }

    public static final void LogTraceEntry(String string) {
        if (!_logEnable) {
            return;
        }
        String string2 = AudioDeviceInterface.getTraceInfo() + " entry:" + string;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, string2);
        }
    }

    public static final void LogTraceExit() {
        if (!_logEnable) {
            return;
        }
        String string = AudioDeviceInterface.getTraceInfo() + " exit";
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, string);
        }
    }

    private void onOutputChanage(String string) {
        block9: {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, " onOutputChanage:" + string);
            }
            this.setAudioRouteSwitchState(string);
            if (!TraeAudioManager.isCloseSystemAPM(this._modePolicy)) {
                return;
            }
            if (this._deviceStat == 1 || this._deviceStat == 5 || this._deviceStat == 2 || this._deviceStat == 3) {
                return;
            }
            this._connectedDev = string;
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, " onOutputChanage:" + string + (this._audioManager == null ? " am==null" : " mode:" + this._audioManager.getMode()) + " st:" + this._streamType + (this._audioTrack == null ? "_audioTrack==null" : " at.st:" + this._audioTrack.getStreamType()));
            }
            try {
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, " curr mode:" + string + (this._audioManager == null ? "am==null" : " mode:" + this._audioManager.getMode()));
                }
                if (this._audioManager != null && this._connectedDev.equals("DEVICE_SPEAKERPHONE")) {
                    this._audioManager.setMode(0);
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block9;
                QLog.w(TAG, 2, exception.getMessage());
            }
        }
        this._audioRouteChanged = true;
    }

    public int getMode() {
        int n2;
        block4: {
            n2 = -1;
            try {
                if (this._audioManager == null && this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) {
                    n2 = this._audioManager.getMode();
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block4;
                QLog.w("TRAE getMode", 2, exception.getMessage());
            }
        }
        return n2;
    }

    public int isBackground() {
        boolean bl = false;
        if (this._context == null) {
            return 0;
        }
        try {
            String string;
            ActivityManager activityManager = (ActivityManager)this._context.getSystemService("activity");
            if (activityManager.getRunningTasks(1) == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "running task is null, ams is abnormal!!!");
                }
                return 0;
            }
            ActivityManager.RunningTaskInfo runningTaskInfo = (ActivityManager.RunningTaskInfo)activityManager.getRunningTasks(1).get(0);
            if (runningTaskInfo == null || runningTaskInfo.topActivity == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "failed to get RunningTaskInfo");
                }
                return 0;
            }
            String string2 = runningTaskInfo.topActivity.getPackageName();
            boolean bl2 = bl = !string2.equals(string = this._context.getPackageName());
            if (bl) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE isBackground", 2, exception.getMessage());
            }
            return 0;
        }
    }

    public int call_preprocess() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        this._streamType = TraeAudioManager.getAudioStreamType(this._audioStreamTypePolicy);
        if (this._as == null) {
            this._as = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                @Override
                public void onServiceStateUpdate(boolean bl) {
                    if (!bl) {
                        try {
                            AudioDeviceInterface.this._prelock.lock();
                            AudioDeviceInterface.this._preDone = true;
                            if (QLog.isColorLevel()) {
                                QLog.e(AudioDeviceInterface.TAG, 2, "onServiceStateUpdate signalAll");
                            }
                            AudioDeviceInterface.this._precon.signalAll();
                            AudioDeviceInterface.this._prelock.unlock();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void onDeviceListUpdate(String[] stringArray, String string, String string2, String string3) {
                    AudioDeviceInterface.access$302(stringArray);
                    if (AudioDeviceInterface.this.usingJava) {
                        AudioDeviceInterface.this.onOutputChanage(string);
                    }
                }

                @Override
                public void onDeviceChangabledUpdate(boolean bl) {
                }

                @Override
                public void onGetDeviceListRes(int n2, String[] stringArray, String string, String string2, String string3) {
                    AudioDeviceInterface.access$302(stringArray);
                }

                @Override
                public void onConnectDeviceRes(int n2, String string, boolean bl) {
                }

                @Override
                public void onIsDeviceChangabledRes(int n2, boolean bl) {
                }

                @Override
                public void onGetConnectedDeviceRes(int n2, String string) {
                    if (n2 == 0) {
                        AudioDeviceInterface.this.onOutputChanage(string);
                    }
                }

                @Override
                public void onGetConnectingDeviceRes(int n2, String string) {
                }

                @Override
                public void onRingCompletion(int n2, String string) {
                }

                @Override
                public void onStreamTypeUpdate(int n2) {
                }

                @Override
                public void onGetStreamTypeRes(int n2, int n3) {
                }

                @Override
                public void onVoicecallPreprocessRes(int n2) {
                    try {
                        AudioDeviceInterface.this._prelock.lock();
                        AudioDeviceInterface.this._preDone = true;
                        if (QLog.isColorLevel()) {
                            QLog.e(AudioDeviceInterface.TAG, 2, "onVoicecallPreprocessRes signalAll");
                        }
                        AudioDeviceInterface.this._precon.signalAll();
                        AudioDeviceInterface.this._prelock.unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void onAudioRouteSwitchStart(String string, String string2) {
                }

                @Override
                public void onAudioRouteSwitchEnd(String string, long l2) {
                }
            });
        }
        this._preDone = false;
        if (this._as != null) {
            this._prelock.lock();
            try {
                int n2;
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) {
                    if (this._audioManager.getMode() == 2) {
                        n2 = 5;
                        while (n2-- > 0 && this._audioManager.getMode() == 2) {
                            if (QLog.isColorLevel()) {
                                QLog.e(TAG, 2, "call_preprocess waiting...  mode:" + this._audioManager.getMode());
                            }
                            Thread.sleep(500L);
                        }
                    }
                    if (this._audioManager.isMicrophoneMute()) {
                        this._audioManager.setMicrophoneMute(false);
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 2, "media call_preprocess setMicrophoneMute false");
                        }
                    }
                }
                this._as.voiceCallPreprocess(this._modePolicy, this._streamType);
                this._as.connectHighestPriorityDevice();
                try {
                    n2 = 7;
                    while (n2-- > 0 && !this._preDone) {
                        this._precon.await(1L, TimeUnit.SECONDS);
                        if (!QLog.isColorLevel()) continue;
                        QLog.e(TAG, 2, "call_preprocess waiting...  as:" + (Object)((Object)this._as));
                    }
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "call_preprocess done!");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._as.getConnectedDevice();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this._prelock.unlock();
            }
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_postprocess() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        if (this._as != null) {
            this._as.voiceCallPostprocess();
            this._as.release();
            this._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_preprocess_media() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.openKTVDevice();
            mVivoKTVHelper.setPreModeParam(1);
            mVivoKTVHelper.setPlayFeedbackParam(1);
            mVivoKTVHelper.setPlayFeedbackParam(0);
        }
        if (this._as == null) {
            this._as = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                @Override
                public void onServiceStateUpdate(boolean bl) {
                }

                @Override
                public void onDeviceListUpdate(String[] stringArray, String string, String string2, String string3) {
                    AudioDeviceInterface.access$302(stringArray);
                    if (AudioDeviceInterface.this.usingJava) {
                        AudioDeviceInterface.this.onOutputChanage(string);
                    }
                }

                @Override
                public void onDeviceChangabledUpdate(boolean bl) {
                }

                @Override
                public void onGetDeviceListRes(int n2, String[] stringArray, String string, String string2, String string3) {
                    AudioDeviceInterface.access$302(stringArray);
                }

                @Override
                public void onConnectDeviceRes(int n2, String string, boolean bl) {
                }

                @Override
                public void onIsDeviceChangabledRes(int n2, boolean bl) {
                }

                @Override
                public void onGetConnectedDeviceRes(int n2, String string) {
                    if (n2 == 0) {
                        AudioDeviceInterface.this.onOutputChanage(string);
                    }
                }

                @Override
                public void onGetConnectingDeviceRes(int n2, String string) {
                }

                @Override
                public void onRingCompletion(int n2, String string) {
                }

                @Override
                public void onStreamTypeUpdate(int n2) {
                }

                @Override
                public void onGetStreamTypeRes(int n2, int n3) {
                }

                @Override
                public void onVoicecallPreprocessRes(int n2) {
                }

                @Override
                public void onAudioRouteSwitchStart(String string, String string2) {
                }

                @Override
                public void onAudioRouteSwitchEnd(String string, long l2) {
                }
            });
        }
        if (this._as != null) {
            try {
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) {
                    if (this._audioManager.getMode() == 2) {
                        int n2 = 5;
                        while (n2-- > 0 && this._audioManager.getMode() == 2) {
                            if (QLog.isColorLevel()) {
                                QLog.e(TAG, 2, "media call_preprocess_media waiting...  mode:" + this._audioManager.getMode());
                            }
                            Thread.sleep(500L);
                        }
                    }
                    if (this._audioManager.getMode() != 0) {
                        this._audioManager.setMode(0);
                    }
                    if (this._audioManager.isMicrophoneMute()) {
                        this._audioManager.setMicrophoneMute(false);
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 2, "media call_preprocess_media setMicrophoneMute false");
                        }
                    }
                }
                this._as.connectHighestPriorityDevice();
                this._as.getConnectedDevice();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 2, "call_preprocess_media done!");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_postprocess_media() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        if (this._as != null) {
            this._as.release();
            this._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.closeKTVDevice();
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public void setJavaInterface(int n2) {
        this.usingJava = n2 != 0;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "setJavaInterface flg:" + n2);
        }
    }

    private void setAudioRouteSwitchState(String string) {
        this.switchState = string.equals("DEVICE_EARPHONE") ? 1 : (string.equals("DEVICE_SPEAKERPHONE") ? 2 : (string.equals("DEVICE_WIREDHEADSET") ? 3 : (string.equals("DEVICE_BLUETOOTHHEADSET") ? 4 : 0)));
    }

    public int getAudioRouteSwitchState() {
        return this.switchState;
    }

    private void initTRAEAudioManager() {
        if (this._context != null) {
            TraeAudioManager.init(this._context);
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "initTRAEAudioManager , TraeAudioSession create");
            }
            if (this._asAudioManager == null) {
                this._asAudioManager = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean bl) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] stringArray, String string, String string2, String string3) {
                        AudioDeviceInterface.access$302(stringArray);
                        if (AudioDeviceInterface.this.usingJava) {
                            AudioDeviceInterface.this.onOutputChanage(string);
                        }
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bl) {
                    }

                    @Override
                    public void onGetDeviceListRes(int n2, String[] stringArray, String string, String string2, String string3) {
                        AudioDeviceInterface.access$302(stringArray);
                    }

                    @Override
                    public void onConnectDeviceRes(int n2, String string, boolean bl) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int n2, boolean bl) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int n2, String string) {
                        if (n2 == 0) {
                            AudioDeviceInterface.this.onOutputChanage(string);
                        }
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int n2, String string) {
                    }

                    @Override
                    public void onRingCompletion(int n2, String string) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int n2) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int n2, int n3) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int n2) {
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String string, String string2) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String string, long l2) {
                    }
                });
            }
            this._asAudioManager.startService("DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;");
        }
    }

    private int startService(String string) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "initTRAEAudioManager , TraeAudioSession startService: " + (Object)((Object)this._asAudioManager) + " deviceConfig:" + string);
        }
        if (this._asAudioManager != null) {
            return this._asAudioManager.startService(string);
        }
        return -1;
    }

    private int stopService() {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "initTRAEAudioManager , TraeAudioSession stopService: " + (Object)((Object)this._asAudioManager));
        }
        if (this._asAudioManager != null) {
            return this._asAudioManager.stopService();
        }
        return -1;
    }

    private int SetAudioOutputMode(int n2) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "TraeAudioSession SetAudioOutputMode: " + n2);
        }
        if (0 == n2) {
            if (null == mDeviceList || null == this._asAudioManager) {
                return -1;
            }
            boolean bl = false;
            block0: do {
                int n3;
                for (n3 = 0; n3 < mDeviceList.length && !bl; ++n3) {
                    if (!"DEVICE_WIREDHEADSET".equals(mDeviceList[n3])) continue;
                    this._asAudioManager.connectDevice("DEVICE_WIREDHEADSET");
                    bl = true;
                    break;
                }
                for (n3 = 0; n3 < mDeviceList.length && !bl; ++n3) {
                    if (!"DEVICE_BLUETOOTHHEADSET".equals(mDeviceList[n3])) continue;
                    this._asAudioManager.connectDevice("DEVICE_BLUETOOTHHEADSET");
                    bl = true;
                    break;
                }
                for (n3 = 0; n3 < mDeviceList.length && !bl; ++n3) {
                    if (!"DEVICE_EARPHONE".equals(mDeviceList[n3])) continue;
                    this._asAudioManager.connectDevice("DEVICE_EARPHONE");
                    bl = true;
                    continue block0;
                }
            } while (!bl);
        } else {
            if (1 == n2) {
                if (this._asAudioManager == null) {
                    return -1;
                }
                this._asAudioManager.connectDevice("DEVICE_SPEAKERPHONE");
                return 0;
            }
            return -1;
        }
        return 0;
    }

    private int getAndroidSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public int hasLightSensorManager() {
        if (this._context == null) {
            return 1;
        }
        Sensor sensor = null;
        try {
            SensorManager sensorManager = (SensorManager)this._context.getSystemService("sensor");
            sensor = sensorManager.getDefaultSensor(5);
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, exception.getMessage());
            }
            return 1;
        }
        if (null == sensor) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "not hasLightSensorManager null == sensor8");
            }
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "hasLightSensorManager");
        }
        return 1;
    }

    static boolean isHardcodeOpenSles() {
        if (Build.MANUFACTURER.equals("Xiaomi")) {
            if (Build.MODEL.equals("MI 5")) {
                return true;
            }
            if (Build.MODEL.equals("MI 5s")) {
                return true;
            }
            if (Build.MODEL.equals("MI 5s Plus")) {
                return true;
            }
        } else if (Build.MANUFACTURER.equals("samsung") && Build.MODEL.equals("SM-G9350")) {
            return true;
        }
        return false;
    }

    public int getNumberOfCPUCores() {
        int n2;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            n2 = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException securityException) {
            n2 = -1;
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        return n2;
    }

    private int isSupportLowLatency() {
        if (AudioDeviceInterface.isHardcodeOpenSles()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "hardcode FEATURE_AUDIO_LOW_LATENCY: " + Build.MANUFACTURER + "_" + Build.MODEL);
            }
            return 1;
        }
        return 0;
    }

    private int isSupportVivoKTVHelper() {
        if (this._context != null && (mVivoKTVHelper = VivoKTVHelper.getInstance(this._context)) != null) {
            isSupportVivoKTVHelper = mVivoKTVHelper.isDeviceSupportKaraoke();
        }
        return isSupportVivoKTVHelper ? 1 : 0;
    }

    private int EnableVivoKTVLoopback(int n2) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "EnableVivoKTVLoopback: " + n2 + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper + " mVivoKTVHelper:" + mVivoKTVHelper);
        }
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.setPlayFeedbackParam(n2);
            return 0;
        }
        return -1;
    }

    private int isVivoKTVLoopback() {
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            return mVivoKTVHelper.getPlayFeedbackParam();
        }
        return 0;
    }

    private void uninitTRAEAudioManager() {
        if (this._context != null) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "uninitTRAEAudioManager , stopService");
            }
            if (this._asAudioManager != null) {
                this._asAudioManager.stopService();
                this._asAudioManager.release();
                this._asAudioManager = null;
            }
        } else if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "uninitTRAEAudioManager , context null");
        }
    }

    private int OpenMp3File(String string, int n2, int n3) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo == null) {
            TraeAudioCodecList.CodecInfo codecInfo2 = this._traeAudioCodecList.add(n2);
            codecInfo2.audioDecoder.setIOPath(string);
            codecInfo2.audioDecoder.setIndex(n2);
            int n4 = codecInfo2.audioDecoder.prepare(n3);
            if (n4 != 0) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "openFile mp3 Failed!!!");
                }
                codecInfo2.audioDecoder.release();
                codecInfo2.audioDecoder = null;
                this._traeAudioCodecList.remove(n2);
                return n4;
            }
            return 0;
        }
        return -1;
    }

    private ByteBuffer getDecBuffer(int n2) {
        switch (n2) {
            case 0: {
                return this._decBuffer0;
            }
            case 1: {
                return this._decBuffer1;
            }
            case 2: {
                return this._decBuffer2;
            }
            case 3: {
                return this._decBuffer3;
            }
            case 4: {
                return this._decBuffer4;
            }
            case 5: {
                return this._decBuffer5;
            }
            case 6: {
                return this._decBuffer6;
            }
            case 7: {
                return this._decBuffer7;
            }
            case 8: {
                return this._decBuffer8;
            }
            case 9: {
                return this._decBuffer9;
            }
            case 10: {
                return this._decBuffer10;
            }
        }
        QLog.w(TAG, 2, "getDecBuffer failed!! index:" + n2);
        return null;
    }

    private int ReadMp3File(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            ByteBuffer byteBuffer = this.getDecBuffer(n2);
            if (byteBuffer == null) {
                return -1;
            }
            byteBuffer.rewind();
            int n3 = codecInfo.audioDecoder.getFrameSize();
            int n4 = codecInfo.audioDecoder.ReadOneFrame(codecInfo._tempBufdec, n3);
            byteBuffer.put(codecInfo._tempBufdec, 0, n3);
            return n4;
        }
        return -1;
    }

    private int CloseMp3File(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            codecInfo.audioDecoder.release();
            codecInfo.audioDecoder = null;
            this._traeAudioCodecList.remove(n2);
            return 0;
        }
        return -1;
    }

    private int SeekMp3To(int n2, int n3) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.SeekTo(n3);
        }
        return 0;
    }

    private int getMp3SampleRate(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getSampleRate();
        }
        return -1;
    }

    private int getMp3Channels(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getChannels();
        }
        return -1;
    }

    private long getMp3FileTotalMs(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getFileTotalMs();
        }
        return -1L;
    }

    public int checkAACSupported() {
        int n2 = this.checkAACMediaCodecSupported(false);
        int n3 = this.checkAACMediaCodecSupported(true);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "checkAACSupported isSupportEncoder: " + n2 + ", isSupportDecoder:" + n3);
        }
        if (n2 == 1 && n3 == 1) {
            return 1;
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public int checkAACMediaCodecSupported(boolean bl) {
        block13: {
            try {
                String string = "audio/mp4a-latm";
                if (Build.VERSION.SDK_INT >= 21) {
                    for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(1).getCodecInfos()) {
                        if (mediaCodecInfo.isEncoder() == bl) continue;
                        if (mediaCodecInfo.getName().toLowerCase().contains("nvidia")) {
                            return 0;
                        }
                        String[] stringArray = mediaCodecInfo.getSupportedTypes();
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            if (!stringArray[i2].equalsIgnoreCase(string)) continue;
                            if (QLog.isColorLevel()) {
                                QLog.w(TAG, 2, "checkAACSupported support!, " + mediaCodecInfo.getName());
                            }
                            return 1;
                        }
                    }
                } else {
                    int n2 = MediaCodecList.getCodecCount();
                    for (int i3 = 0; i3 < n2; ++i3) {
                        MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
                        if (mediaCodecInfo.isEncoder() == bl) continue;
                        if (mediaCodecInfo.getName().toLowerCase().contains("nvidia")) {
                            return 0;
                        }
                        String[] stringArray = mediaCodecInfo.getSupportedTypes();
                        for (int i4 = 0; i4 < stringArray.length; ++i4) {
                            if (!stringArray[i4].equalsIgnoreCase(string)) continue;
                            if (QLog.isColorLevel()) {
                                QLog.w(TAG, 2, "checkAACSupported support!, " + mediaCodecInfo.getName());
                            }
                            return 1;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block13;
                QLog.e(TAG, 2, "check if support aac codec failed.");
            }
        }
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 2, "Error when checking aac codec availability");
        }
        return 0;
    }

    static /* synthetic */ String[] access$302(String[] stringArray) {
        mDeviceList = stringArray;
        return stringArray;
    }
}

