/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.opengl.GLES20;
import android.os.Build;
import android.os.HandlerThread;
import android.os.SystemClock;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.i;
import com.tencent.liteav.basic.opengl.j;
import com.tencent.liteav.basic.util.c;
import com.tencent.liteav.beauty.b.k;
import com.tencent.liteav.d;
import com.tencent.trtc.TRTCCloudDef;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TRTCCustomTextureUtil {
    private static final String TAG = "TRTCCustomTextureUtil";
    private final c mFpsMeter;
    private i mGLThreadHandler = null;
    private HandlerThread mEGLThread = null;
    private Object mEGLContext = null;
    private long mLastGLThreadId;
    private j mRotateFilter;
    private k mI4202RGBAFilter = null;
    private d mCaptureAndEnc;
    private long mLastCaptureCalculateTS = 0L;
    private long mCaptureFrameCount = 0L;
    private long mLastCaptureFrameCount = 0L;
    private double mCurrentFps = 0.0;

    public TRTCCustomTextureUtil(d d2) {
        this.mCaptureAndEnc = d2;
        this.mFpsMeter = new c("send-custom-texture", (int)TimeUnit.SECONDS.toMillis(5L));
    }

    public void release() {
        this.stopThread();
    }

    public void sendCustomTexture(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        this.mFpsMeter.a();
        this.checkEGLContext(tRTCVideoFrame);
        this.sendCustomTextureInternal(tRTCVideoFrame);
        if (this.mLastCaptureCalculateTS == 0L) {
            this.mLastCaptureCalculateTS = SystemClock.elapsedRealtime();
            this.mLastCaptureFrameCount = 0L;
            this.mCaptureFrameCount = 0L;
        } else {
            ++this.mCaptureFrameCount;
        }
    }

    public double getCurrentFPS() {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = l2 - this.mLastCaptureCalculateTS;
        if (l3 >= 1000L) {
            this.mCurrentFps = (double)(this.mCaptureFrameCount - this.mLastCaptureFrameCount) * 1000.0 / (double)l3;
            this.mLastCaptureFrameCount = this.mCaptureFrameCount;
            this.mLastCaptureCalculateTS = l2;
        }
        return this.mCurrentFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCustomTextureInternal(final TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mGLThreadHandler != null) {
                GLES20.glFinish();
                final i i2 = this.mGLThreadHandler;
                this.mGLThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        i2.d();
                        if (i2.d) {
                            if (tRTCVideoFrame.texture != null) {
                                tRTCVideoFrame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(tRTCVideoFrame.texture.textureId, tRTCVideoFrame);
                                if (i2.e != null) {
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.texture.textureId, tRTCVideoFrame.width, tRTCVideoFrame.height, (Object)i2.e.f(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                                }
                            }
                        } else if (tRTCVideoFrame.texture != null) {
                            tRTCVideoFrame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(tRTCVideoFrame.texture.textureId, tRTCVideoFrame);
                            if (i2.g != null) {
                                TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.texture.textureId, tRTCVideoFrame.width, tRTCVideoFrame.height, (Object)i2.g.d(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                            }
                        } else {
                            k k2;
                            int n2 = 3;
                            if (tRTCVideoFrame.pixelFormat == 1) {
                                n2 = 1;
                            } else if (tRTCVideoFrame.pixelFormat == 4) {
                                n2 = 3;
                            }
                            if (TRTCCustomTextureUtil.this.mI4202RGBAFilter == null) {
                                k2 = new k(n2);
                                k2.a(true);
                                if (!k2.a()) {
                                    TXCLog.e(TRTCCustomTextureUtil.TAG, "mI4202RGBAFilter init failed!!, break init");
                                }
                                k2.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
                                TRTCCustomTextureUtil.this.mI4202RGBAFilter = k2;
                            }
                            if ((k2 = TRTCCustomTextureUtil.this.mI4202RGBAFilter) != null) {
                                GLES20.glViewport((int)0, (int)0, (int)tRTCVideoFrame.width, (int)tRTCVideoFrame.height);
                                k2.a(tRTCVideoFrame.data);
                                int n3 = k2.r();
                                n3 = TRTCCustomTextureUtil.this.checkRotate(n3, tRTCVideoFrame);
                                if (i2.g != null) {
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(n3, tRTCVideoFrame.width, tRTCVideoFrame.height, (Object)i2.g.d(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                                }
                            } else if (i2.g != null) {
                                TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.data, n2, tRTCVideoFrame.width, tRTCVideoFrame.height, i2.g.d(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                            }
                        }
                    }
                });
            }
        }
    }

    private void checkEGLContext(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null) {
            return;
        }
        boolean bl = false;
        if (this.mLastGLThreadId == Thread.currentThread().getId()) {
            if (tRTCVideoFrame.texture != null) {
                if (tRTCVideoFrame.texture.eglContext10 != null) {
                    boolean bl2 = bl = !tRTCVideoFrame.texture.eglContext10.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomCapture egl10Context change!");
                    }
                }
                if (tRTCVideoFrame.texture.eglContext14 != null) {
                    boolean bl3 = bl = !tRTCVideoFrame.texture.eglContext14.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomCapture egl14Context change!");
                    }
                }
            }
        } else {
            bl = true;
            this.apiLog("CustomCapture eglContext's thread change!");
        }
        this.mLastGLThreadId = Thread.currentThread().getId();
        if (tRTCVideoFrame.texture != null) {
            this.mEGLContext = tRTCVideoFrame.texture.eglContext10 != null ? tRTCVideoFrame.texture.eglContext10 : tRTCVideoFrame.texture.eglContext14;
        }
        if (bl) {
            this.stopThread();
            this.startThread(tRTCVideoFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null) {
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mEGLThread == null) {
                this.mEGLThread = new HandlerThread("customCaptureGLThread");
                this.mEGLThread.start();
                this.mGLThreadHandler = new i(this.mEGLThread.getLooper());
                if (tRTCVideoFrame.texture == null) {
                    this.apiLog("CustomCapture buffer start egl10 thread");
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.h = null;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (tRTCVideoFrame.texture.eglContext10 != null) {
                    this.apiLog("CustomCapture texture start egl10 thread");
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.h = tRTCVideoFrame.texture.eglContext10;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (tRTCVideoFrame.texture.eglContext14 != null && Build.VERSION.SDK_INT >= 17) {
                    this.apiLog("CustomCapture texture start egl14 thread");
                    this.mGLThreadHandler.d = true;
                    this.mGLThreadHandler.f = tRTCVideoFrame.texture.eglContext14;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                }
                this.mGLThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        TXCLog.i(TRTCCustomTextureUtil.TAG, "GLContext create finished!");
                        countDownLatch.countDown();
                    }
                });
            } else {
                countDownLatch.countDown();
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void stopThread() {
        if (this.mGLThreadHandler != null) {
            final j j2 = this.mRotateFilter;
            this.mRotateFilter = null;
            final k k2 = this.mI4202RGBAFilter;
            this.mI4202RGBAFilter = null;
            this.mGLThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (j2 != null) {
                        j2.d();
                    }
                    if (k2 != null) {
                        k2.d();
                    }
                    if (TRTCCustomTextureUtil.this.mCaptureAndEnc != null) {
                        TRTCCustomTextureUtil.this.apiLog("CustomCapture release");
                        TRTCCustomTextureUtil.this.mCaptureAndEnc.q();
                    }
                }
            });
            i.a(this.mGLThreadHandler, this.mEGLThread);
            this.apiLog("CustomCapture destroy egl thread");
        }
        this.mGLThreadHandler = null;
        this.mEGLThread = null;
    }

    private void apiLog(String string) {
        TXCLog.i(TAG, "trtc_api " + string);
    }

    private int checkRotate(int n2, TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null || tRTCVideoFrame.rotation == 0) {
            return n2;
        }
        int n3 = tRTCVideoFrame.rotation * 90;
        if (this.mRotateFilter == null) {
            j j2 = new j();
            j2.a();
            j2.a(true);
            j2.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
            this.mRotateFilter = j2;
        }
        int n4 = n2;
        j j3 = this.mRotateFilter;
        if (j3 != null) {
            GLES20.glViewport((int)0, (int)0, (int)tRTCVideoFrame.width, (int)tRTCVideoFrame.height);
            int n5 = (720 - n3) % 360;
            j3.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
            j3.a(tRTCVideoFrame.width, tRTCVideoFrame.height, n5, null, (float)tRTCVideoFrame.width / (float)tRTCVideoFrame.height, false, false);
            j3.b(n4);
            n4 = j3.l();
            int n6 = n5 == 90 || n5 == 270 ? tRTCVideoFrame.height : tRTCVideoFrame.width;
            int n7 = n5 == 90 || n5 == 270 ? tRTCVideoFrame.width : tRTCVideoFrame.height;
            tRTCVideoFrame.width = n6;
            tRTCVideoFrame.height = n7;
        }
        return n4;
    }
}

