/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.device;

import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.d;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.g;

public class TXDeviceManagerImpl
implements TXDeviceManager {
    public static final String TAG = "TXDeviceManagerImpl";
    public static final int AUDIO_ROUTE_SPEAKER = 0;
    public static final int AUDIO_ROUTE_EARPIECE = 1;
    public static final int SystemVolumeTypeAuto = 0;
    public static final int SystemVolumeTypeMedia = 1;
    public static final int SystemVolumeTypeVOIP = 2;
    private TXDeviceManagerListener mDeviceManagerListener;
    protected d mCaptureAndEnc;
    protected Handler mSDKHandler;
    private boolean mIsFrontCamera;

    protected void runOnSDKThread(Runnable runnable) {
        if (this.mSDKHandler != null) {
            if (Looper.myLooper() != this.mSDKHandler.getLooper()) {
                this.mSDKHandler.post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public TXDeviceManagerImpl(Handler handler) {
        this.mSDKHandler = handler;
    }

    public void setCaptureAndEnc(d d2) {
        this.mCaptureAndEnc = d2;
    }

    public void setDeviceManagerListener(TXDeviceManagerListener tXDeviceManagerListener) {
        this.mDeviceManagerListener = tXDeviceManagerListener;
    }

    protected void apiLog(String string) {
        TXCLog.i(TAG, "trtc_api TXDeviceManager:" + string);
    }

    protected void apiOnlineLog(String string, Object ... objectArray) {
        String string2 = "trtc_api TXDeviceManager:";
        Monitor.a(1, String.format(string, objectArray), "", 0, string2);
    }

    public void setFrontCamera(boolean bl) {
        this.mIsFrontCamera = bl;
    }

    @Override
    public boolean isFrontCamera() {
        return this.mIsFrontCamera;
    }

    @Override
    public int switchCamera(final boolean bl) {
        final boolean bl2 = this.mIsFrontCamera;
        this.mIsFrontCamera = bl;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (bl2 != bl) {
                    TXDeviceManagerImpl.this.mCaptureAndEnc.j();
                    if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                        TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchCamera(bl);
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        return this.mCaptureAndEnc.p();
    }

    @Override
    public int setCameraZoomRatio(final float f2) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraZoomRatio " + f2);
                TXDeviceManagerImpl.this.mCaptureAndEnc.h((int)f2);
            }
        });
        return 0;
    }

    @Override
    public int enableCameraAutoFocus(final boolean bl) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("enableCameraAutoFocus " + bl);
                g g2 = TXDeviceManagerImpl.this.mCaptureAndEnc.c();
                g2.L = !bl;
                TXDeviceManagerImpl.this.mCaptureAndEnc.a(g2);
            }
        });
        return 0;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        g g2 = this.mCaptureAndEnc.c();
        return !g2.L;
    }

    @Override
    public boolean enableCameraTorch(boolean bl) {
        this.apiLog("enableCameraTorch " + bl);
        return this.mCaptureAndEnc.e(bl);
    }

    @Override
    public int setCameraFocusPosition(final int n2, final int n3) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraFocusPosition x:" + n2 + "y:" + n3);
                TXDeviceManagerImpl.this.mCaptureAndEnc.b(n2, n3);
            }
        });
        return 0;
    }

    @Override
    public int setAudioRoute(final TXDeviceManager.TXAudioRoute tXAudioRoute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiOnlineLog("setAudioRoute route:" + (tXAudioRoute == TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece ? "earpiece" : "speakerphone"), new Object[0]);
                switch (tXAudioRoute) {
                    case TXAudioRouteSpeakerphone: {
                        TXCAudioEngine.setAudioRoute(0);
                        break;
                    }
                    case TXAudioRouteEarpiece: {
                        TXCAudioEngine.setAudioRoute(1);
                        break;
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public int setSystemVolumeType(final TXDeviceManager.TXSystemVolumeType tXSystemVolumeType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiOnlineLog("setSystemVolumeType type:%s,  auto(0),media(1),VOIP(2)", tXSystemVolumeType.name());
                switch (tXSystemVolumeType) {
                    case TXSystemVolumeTypeAuto: {
                        TXCAudioEngine.setSystemVolumeType(0);
                        break;
                    }
                    case TXSystemVolumeTypeVOIP: {
                        TXCAudioEngine.setSystemVolumeType(2);
                        break;
                    }
                    case TXSystemVolumeTypeMedia: {
                        TXCAudioEngine.setSystemVolumeType(1);
                    }
                }
                if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                    TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchSystemVolumeType(tXSystemVolumeType);
                }
            }
        });
        return 0;
    }

    public static interface TXDeviceManagerListener {
        public void onSwitchCamera(boolean var1);

        public void onSwitchSystemVolumeType(TXDeviceManager.TXSystemVolumeType var1);
    }
}

