/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.log;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.g;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TXCLog {
    public static final int LOG_VERBOSE = 0;
    public static final int LOG_DEBUG = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_WARNING = 3;
    public static final int LOG_ERROR = 4;
    public static final int LOG_FATAL = 5;
    public static final int LOG_NONE = 6;
    public static final int LOG_ASYNC = 0;
    public static final int LOG_SYNC = 1;
    public static String mLogDir = "";
    private static String mLogCacheDir = "";
    private static boolean mEnableCompress = true;
    private static final Object mLogLock = new Object();
    private static boolean mHasInit = false;
    private static a mListener = null;
    private static int mLogLevel = 0;
    private static boolean mEnableConsole = true;
    private static boolean mEnableCallback = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init() {
        if (mHasInit) {
            return true;
        }
        Object object = mLogLock;
        synchronized (object) {
            if (mHasInit) {
                return true;
            }
            boolean bl = g.f();
            Context context = TXCCommonUtil.getAppContext();
            if (bl && context != null) {
                File file;
                if (TextUtils.isEmpty((CharSequence)mLogDir) && (file = context.getExternalFilesDir(null)) != null) {
                    mLogDir = file.getAbsolutePath() + "/log/liteav";
                }
                mLogCacheDir = context.getFilesDir().getAbsolutePath() + "/log/liteav";
                Log.i((String)"TXCLog", (String)("TXCLog init log file path : " + mLogDir + ", cache : " + mLogCacheDir));
                TXCLog.nativeLogInit();
                TXCLog.nativeLogSetLevel(mLogLevel);
                TXCLog.nativeLogSetConsole(mEnableConsole);
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
                TXCLog.nativeEnableCallback(mEnableCallback);
                mHasInit = true;
            }
        }
        return mHasInit;
    }

    public static void log(int n2, String string, String string2) {
        if (TXCLog.init()) {
            TXCLog.nativeLog(n2, string, "", 0, "", string2);
        }
        TXCLog.log_callback(n2, string, string2);
    }

    public static void setLevel(int n2) {
        mLogLevel = n2;
        if (mHasInit) {
            TXCLog.nativeLogSetLevel(mLogLevel);
        }
    }

    public static void setLogDirPath(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (!string.equalsIgnoreCase(mLogDir)) {
            mLogDir = string;
            if (mHasInit) {
                Log.i((String)"TXCLog", (String)("TXCLog setLogDirPath " + string));
                TXCLog.nativeLogClose();
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
            }
        }
    }

    public static void sliceLogFile() {
        if (mHasInit) {
            Log.i((String)"TXCLog", (String)"TXCLog sliceLogFile");
            TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
        }
    }

    public static void copyLogFile() {
        if (mHasInit) {
            Log.i((String)"TXCLog", (String)"TXCLog copyLogFile");
            TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
        }
    }

    public static void setLogCompressEnabled(boolean bl) {
        if (mEnableCompress != bl) {
            mEnableCompress = bl;
            if (mHasInit) {
                TXCLog.nativeLogClose();
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
            }
        }
    }

    public static void setConsoleEnabled(boolean bl) {
        mEnableConsole = bl;
        if (mHasInit) {
            TXCLog.nativeLogSetConsole(mEnableConsole);
        }
    }

    public static void setListener(a a2) {
        mListener = a2;
        boolean bl = mEnableCallback = mListener != null;
        if (mHasInit) {
            TXCLog.nativeEnableCallback(mEnableCallback);
        }
    }

    public static void v(String string, String string2, Object ... objectArray) {
        TXCLog.log(0, string, String.format(string2, objectArray));
    }

    public static void d(String string, String string2, Object ... objectArray) {
        TXCLog.log(1, string, String.format(string2, objectArray));
    }

    public static void i(String string, String string2, Object ... objectArray) {
        TXCLog.log(2, string, String.format(string2, objectArray));
    }

    public static void w(String string, String string2, Object ... objectArray) {
        TXCLog.log(3, string, String.format(string2, objectArray));
    }

    public static void e(String string, String string2, Object ... objectArray) {
        TXCLog.log(4, string, String.format(string2, objectArray));
    }

    public static void v(String string, String string2) {
        TXCLog.log(0, string, string2);
    }

    public static void d(String string, String string2) {
        TXCLog.log(1, string, string2);
    }

    public static void i(String string, String string2) {
        TXCLog.log(2, string, string2);
    }

    public static void w(String string, String string2) {
        TXCLog.log(3, string, string2);
    }

    public static void e(String string, String string2) {
        TXCLog.log(4, string, string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            throwable2.printStackTrace(printWriter);
        }
        printWriter.close();
        TXCLog.e(string, string2 + "\n" + ((Object)stringWriter).toString());
    }

    private static void log_callback(int n2, String string, String string2) {
        if (mListener != null) {
            mListener.a(n2, string, string2);
        }
    }

    private static native void nativeLogInit();

    private static native void nativeLog(int var0, String var1, String var2, int var3, String var4, String var5);

    private static native void nativeLogSetLevel(int var0);

    private static native void nativeLogSetConsole(boolean var0);

    private static native void nativeLogOpen(int var0, String var1, String var2, String var3, boolean var4);

    private static native void nativeLogClose();

    private static native void nativeEnableCallback(boolean var0);

    public static interface a {
        public void a(int var1, String var2, String var3);
    }
}

