/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.h;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.g;
import java.lang.ref.WeakReference;

public class TXCLiveBGMPlayer
implements TXAudioEffectManager.TXMusicPlayObserver {
    private static final String TAG = "AudioCenter:TXCLiveBGMPlayer";
    private static final int PLAY_SUCCESS = 0;
    private static final int PLAY_ERR_OPEN = -1;
    private boolean mIsRunning = false;
    private boolean mIsPause = false;
    private WeakReference<h> mWeakListener = null;
    private int mBGMId = Integer.MAX_VALUE;
    private final Handler mHandler = new Handler(Looper.getMainLooper());

    public static TXCLiveBGMPlayer getInstance() {
        return a.a();
    }

    private TXCLiveBGMPlayer() {
    }

    public synchronized void setOnPlayListener(h h2) {
        if (h2 == null) {
            this.mWeakListener = null;
        }
        this.mWeakListener = new WeakReference<h>(h2);
    }

    public boolean startPlay(String string) {
        if (string == null || string.isEmpty()) {
            TXCLog.e(TAG, "start live bgm failed! invalid params!");
            return false;
        }
        this.mIsRunning = true;
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(this.mBGMId, string);
        audioMusicParam.publish = true;
        audioMusicParam.loopCount = 0;
        boolean bl = TXAudioEffectManagerImpl.getInstance().startPlayMusic(audioMusicParam);
        TXAudioEffectManagerImpl.getInstance().setMusicObserver(this.mBGMId, this);
        if (!bl) {
            this.onPlayEnd(-1);
            return false;
        }
        TXCLog.i(TAG, "start bgm play : filePath = " + string);
        return true;
    }

    public boolean stopPlay() {
        this.mIsRunning = false;
        long l2 = System.currentTimeMillis();
        TXAudioEffectManagerImpl.getInstance().setMusicObserver(this.mBGMId, null);
        TXAudioEffectManagerImpl.getInstance().stopPlayMusic(this.mBGMId);
        this.mIsPause = false;
        TXCLog.i(TAG, "stopBGMPlay cost(MS): " + (System.currentTimeMillis() - l2));
        return true;
    }

    public void stopAll() {
        TXAudioEffectManagerImpl.getInstance().stopAllMusics();
        TXAudioEffectManagerImpl.getAutoCacheHolder().stopAllMusics();
        TXAudioEffectManagerImpl.getCacheInstance().stopAllMusics();
    }

    public boolean isRunning() {
        return this.mIsRunning && !this.mIsPause;
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public boolean pause() {
        TXCLog.i(TAG, "pause");
        this.mIsPause = true;
        TXAudioEffectManagerImpl.getInstance().pausePlayMusic(this.mBGMId);
        return true;
    }

    public boolean resume() {
        TXCLog.i(TAG, "resume");
        this.mIsPause = false;
        TXAudioEffectManagerImpl.getInstance().resumePlayMusic(this.mBGMId);
        return true;
    }

    public boolean setVolume(float f2) {
        TXCLog.i(TAG, "setVolume");
        TXAudioEffectManagerImpl.getInstance().setMusicVolume(this.mBGMId, (int)(f2 * 100.0f));
        return true;
    }

    public boolean setPlayoutVolume(float f2) {
        TXCLog.i(TAG, "setPlayoutVolume:" + f2);
        TXAudioEffectManagerImpl.getInstance().setMusicPlayoutVolume(this.mBGMId, (int)(f2 * 100.0f));
        return true;
    }

    public boolean setPublishVolume(float f2) {
        TXAudioEffectManagerImpl.getInstance().setMusicPublishVolume(this.mBGMId, (int)(f2 * 100.0f));
        return true;
    }

    public int getBGMDuration(String string) {
        return (int)TXAudioEffectManagerImpl.getInstance().getMusicDurationInMS(string);
    }

    public long getBGMGetCurrentProgressInMs(String string) {
        if (string == null) {
            return TXAudioEffectManagerImpl.getInstance().getMusicCurrentPosInMS(this.mBGMId);
        }
        return 0L;
    }

    public void setBGMPosition(int n2) {
        TXAudioEffectManagerImpl.getInstance().seekMusicToPosInMS(this.mBGMId, n2);
    }

    public void setPitch(float f2) {
        TXAudioEffectManagerImpl.getInstance().setMusicPitch(this.mBGMId, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayStart(int n2) {
        h h2 = null;
        Object object = this;
        synchronized (object) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        object = h2;
        this.mHandler.post(new Runnable((h)object){
            final /* synthetic */ h a;
            {
                this.a = h2;
            }

            @Override
            public void run() {
                if (this.a != null) {
                    this.a.onPlayStart();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayEnd(int n2) {
        h h2 = null;
        Object object = this;
        synchronized (object) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        object = h2;
        this.mHandler.post(new Runnable((h)object, n2){
            final /* synthetic */ h a;
            final /* synthetic */ int b;
            {
                this.a = h2;
                this.b = n2;
            }

            @Override
            public void run() {
                if (this.a != null) {
                    this.a.onPlayEnd(this.b);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayProgress(long l2, long l3) {
        h h2 = null;
        Object object = this;
        synchronized (object) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        object = h2;
        this.mHandler.post(new Runnable((h)object, l2, l3){
            final /* synthetic */ h a;
            final /* synthetic */ long b;
            final /* synthetic */ long c;
            {
                this.a = h2;
                this.b = l2;
                this.c = l3;
            }

            @Override
            public void run() {
                if (this.a != null) {
                    this.a.onPlayProgress(this.b, this.c);
                }
            }
        });
    }

    @Override
    public void onPlayProgress(int n2, long l2, long l3) {
        this.onPlayProgress(l2, l3);
    }

    @Override
    public void onStart(int n2, int n3) {
        this.onPlayStart(n3);
    }

    @Override
    public void onComplete(int n2, int n3) {
        this.onPlayEnd(n3);
    }

    static {
        g.f();
    }

    private static class a {
        private static TXCLiveBGMPlayer a = new TXCLiveBGMPlayer();

        public static TXCLiveBGMPlayer a() {
            return a;
        }
    }
}

