/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import com.tencent.rtmp.sharp.jni.QLog;
import java.nio.ByteBuffer;

public class MediaCodecDecoder {
    private static final String TAG = "MediaCodecDecoder";
    private MediaCodec mAudioAACDecoder = null;
    private int mChannels = 2;
    private int mSampleRate = 44100;
    ByteBuffer mInputBuffer = null;
    ByteBuffer mOutputBuffer = null;
    private MediaCodec.BufferInfo mAACDecBufferInfo = null;
    private ByteBuffer mDecInBuffer = ByteBuffer.allocateDirect(16384);
    private ByteBuffer mDecOutBuffer = ByteBuffer.allocateDirect(16384);
    private byte[] mTempBufDec = new byte[16384];

    @SuppressLint(value={"NewApi"})
    public int createAACDecoder(int n2, int n3) {
        try {
            this.mAudioAACDecoder = MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
            mediaFormat.setInteger("sample-rate", n2);
            mediaFormat.setInteger("channel-count", n3);
            mediaFormat.setInteger("aac-profile", 2);
            byte[] byArray = new byte[]{17, -112};
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            mediaFormat.setByteBuffer("csd-0", byteBuffer);
            this.mAudioAACDecoder.configure(mediaFormat, null, null, 0);
            if (this.mAudioAACDecoder != null) {
                this.mAudioAACDecoder.start();
                this.mAACDecBufferInfo = new MediaCodec.BufferInfo();
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "createAACDecoder succeed!!! : (" + n2 + ", " + n3 + ")");
                }
            }
            return 0;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "Error when creating aac decode stream");
            }
            return -1;
        }
    }

    public int decodeAACFrame(int n2) {
        this.mDecInBuffer.get(this.mTempBufDec, 0, n2);
        int n3 = this.decodeInternalAACFrame(n2);
        this.mDecOutBuffer.rewind();
        if (n3 > 0) {
            this.mDecOutBuffer.put(this.mTempBufDec, 0, n3);
        } else {
            n3 = 0;
        }
        return n3;
    }

    @SuppressLint(value={"NewApi"})
    public int decodeInternalAACFrame(int n2) {
        while (true) {
            int n3 = 0;
            try {
                int n4 = 0;
                n4 = this.mAudioAACDecoder.dequeueInputBuffer(200L);
                if (n4 >= 0) {
                    this.mInputBuffer = Build.VERSION.SDK_INT >= 21 ? this.mAudioAACDecoder.getInputBuffer(n4) : this.mAudioAACDecoder.getInputBuffers()[n4];
                    this.mInputBuffer.clear();
                    this.mInputBuffer.put(this.mTempBufDec, 0, n2);
                    this.mDecInBuffer.rewind();
                    this.mAudioAACDecoder.queueInputBuffer(n4, 0, n2, 0L, 0);
                }
                int n5 = this.mAudioAACDecoder.dequeueOutputBuffer(this.mAACDecBufferInfo, 10000L);
                n3 = 0;
                if (n5 < 0) break;
                this.mOutputBuffer = Build.VERSION.SDK_INT >= 21 ? this.mAudioAACDecoder.getOutputBuffer(n5) : this.mAudioAACDecoder.getOutputBuffers()[n5];
                n3 = this.mAACDecBufferInfo.size;
                try {
                    this.mOutputBuffer.limit(n3);
                    this.mOutputBuffer.get(this.mTempBufDec, 0, n3);
                    this.mOutputBuffer.position(0);
                    this.mAudioAACDecoder.releaseOutputBuffer(n5, false);
                    return n3;
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) continue;
                    QLog.e("TRAE", 2, "Error when decoding aac stream");
                }
            }
            catch (Exception exception) {
                n3 = 0;
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, "decode failed.");
                }
                return n3;
            }
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public int releaseAACDecoder() {
        block5: {
            try {
                if (this.mAudioAACDecoder != null) {
                    this.mAudioAACDecoder.stop();
                    this.mAudioAACDecoder.release();
                    this.mAudioAACDecoder = null;
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, "releaseAACDecoder, release aac decode stream succeed!!");
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block5;
                QLog.e("TRAE", 2, "release aac decoder failed.");
            }
        }
        if (QLog.isColorLevel()) {
            QLog.e("TRAE", 2, "releaseAACDecoder, Error when releasing aac decode stream");
        }
        return -1;
    }
}

