/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoencoder;

import android.opengl.GLES20;
import com.tencent.liteav.basic.c.h;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.videoencoder.TXSVideoEncoderParam;
import com.tencent.liteav.videoencoder.c;
import java.lang.ref.WeakReference;

public class TXCSWVideoEncoder
extends c {
    private static final String TAG = TXCSWVideoEncoder.class.getSimpleName();
    private long mNativeEncoder = 0L;
    private int mBitrate = 0;
    private h mRawFrameFilter;
    private h mResizeFilter;
    private long mPTS = 0L;
    private static final boolean DEBUG = false;
    private int mPushIdx = 0;
    private int mRendIdx = 0;
    private int mPopIdx = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start(TXSVideoEncoderParam tXSVideoEncoderParam) {
        super.start(tXSVideoEncoderParam);
        int n2 = (tXSVideoEncoderParam.width + 7) / 8 * 8;
        int n3 = (tXSVideoEncoderParam.height + 1) / 2 * 2;
        if (n2 != tXSVideoEncoderParam.width || n3 != tXSVideoEncoderParam.height) {
            TXCLog.w(TAG, "Encode Resolution not supportted, transforming...");
            TXCLog.w(TAG, tXSVideoEncoderParam.width + "x" + tXSVideoEncoderParam.height + "-> " + n2 + "x" + n3);
        }
        tXSVideoEncoderParam.width = n2;
        tXSVideoEncoderParam.height = n3;
        this.mOutputWidth = n2;
        this.mOutputHeight = n3;
        this.mInputWidth = n2;
        this.mInputHeight = n3;
        this.mRawFrameFilter = null;
        this.mResizeFilter = null;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.mNativeEncoder = this.nativeInit(new WeakReference<TXCSWVideoEncoder>(this));
            this.nativeSetBitrate(this.mNativeEncoder, this.mBitrate);
            this.nativeSetID(this.mNativeEncoder, this.getID());
            this.nativeStart(this.mNativeEncoder, tXSVideoEncoderParam);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TXCLog.i(TAG, "stop->enter with mRawFrameFilter:" + this.mRawFrameFilter);
        this.mGLContextExternal = null;
        long l2 = 0L;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            l2 = this.mNativeEncoder;
            this.mNativeEncoder = 0L;
        }
        this.nativeStop(l2);
        this.nativeRelease(l2);
        if (this.mRawFrameFilter != null) {
            this.mRawFrameFilter.d();
            this.mRawFrameFilter = null;
        }
        if (this.mResizeFilter != null) {
            this.mResizeFilter.d();
            this.mResizeFilter = null;
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setID(String string) {
        super.setID(string);
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetID(this.mNativeEncoder, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFPS(int n2) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetFPS(this.mNativeEncoder, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableNearestRPS(int n2) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeEnableNearestRPS(this.mNativeEncoder, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBitrate(int n2) {
        this.mBitrate = n2;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetBitrate(this.mNativeEncoder, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBitrateFromQos(int n2, int n3) {
        this.mBitrate = n2;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetBitrateFromQos(this.mNativeEncoder, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncodeIdrFpsFromQos(int n2) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetEncodeIdrFpsFromQos(this.mNativeEncoder, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRealFPS() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            return this.nativeGetRealFPS(this.mNativeEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRealBitrate() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            return this.nativegetRealBitrate(this.mNativeEncoder);
        }
    }

    @Override
    public long pushVideoFrame(int n2, int n3, int n4, long l2) {
        return this.pushVideoFrameInternal(n2, n3, n4, l2, false);
    }

    @Override
    public long pushVideoFrameSync(int n2, int n3, int n4, long l2) {
        return this.pushVideoFrameInternal(n2, n3, n4, l2, true);
    }

    @Override
    public long pushVideoFrameAsync(int n2, int n3, int n4, long l2) {
        return this.pushVideoFrameInternal(n2, n3, n4, l2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEOSAndFlush() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSignalEOSAndFlush(this.mNativeEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRPSRefBitmap(int n2, int n3, long l2) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetRPSRefBitmap(this.mNativeEncoder, n2, n3, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartIDR() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeRestartIDR(this.mNativeEncoder);
        }
    }

    public static long getAndIncreateSeq() {
        return TXCSWVideoEncoder.nativeGetAndIncreaseSeq();
    }

    public static long getAndIncreaseGopIndex() {
        return TXCSWVideoEncoder.nativeGetAndIncreaseGopIndex();
    }

    private static void postEventFromNative(WeakReference<TXCSWVideoEncoder> weakReference, byte[] byArray, int n2, long l2, long l3, long l4, long l5, long l6, long l7, int n3) {
        TXCSWVideoEncoder tXCSWVideoEncoder = (TXCSWVideoEncoder)weakReference.get();
        if (tXCSWVideoEncoder != null) {
            tXCSWVideoEncoder.callDelegate(byArray, n2, l2, l3, l4, l5, l6, l7, n3, null, null);
            if (byArray != null) {
                // empty if block
            }
        }
    }

    private static void onEncodeFinishedFromNative(WeakReference<TXCSWVideoEncoder> weakReference, int n2, long l2, long l3) {
        TXCSWVideoEncoder tXCSWVideoEncoder = (TXCSWVideoEncoder)weakReference.get();
        if (tXCSWVideoEncoder != null) {
            tXCSWVideoEncoder.onEncodeFinished(n2, l2, l3);
        }
    }

    private long pushVideoFrameInternal(int n2, int n3, int n4, long l2, final boolean bl) {
        h h2 = this.mResizeFilter;
        h h3 = this.mRawFrameFilter;
        if (this.mGLContextExternal != null) {
            int n5;
            int n6;
            this.mInputWidth = n3;
            this.mInputHeight = n4;
            if (h2 == null) {
                this.mResizeFilter = h2 = new h();
                h2.a();
                h2.a(true);
            }
            h2.a(this.mOutputWidth, this.mOutputHeight);
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            if (h2 != null) {
                n6 = (720 - this.mRotation) % 360;
                int n7 = n6 == 90 || n6 == 270 ? this.mOutputHeight : this.mOutputWidth;
                n5 = n6 == 90 || n6 == 270 ? this.mOutputWidth : this.mOutputHeight;
                h2.a(n3, n4, n6, null, (float)n7 / (float)n5, this.mEnableXMirror, false);
                h2.b(n2);
            }
            n6 = h2 != null ? h2.l() : n2;
            int[] nArray = new int[1];
            this.mPTS = l2;
            if (h3 == null) {
                TXCLog.i(TAG, "pushVideoFrameInternal->create mRawFrameFilter");
                this.mRawFrameFilter = h3 = new o(1);
                h3.a(true);
                n5 = h3.a() ? 1 : 0;
                if (n5 == 0) {
                    TXCLog.i(TAG, "pushVideoFrameInternal->destroy mRawFrameFilter, init failed!");
                    this.mRawFrameFilter = null;
                    return 10000004L;
                }
                h3.a(this.mOutputWidth, this.mOutputHeight);
                h3.a(new h.a(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void a(int n2) {
                        TXCSWVideoEncoder tXCSWVideoEncoder = TXCSWVideoEncoder.this;
                        synchronized (tXCSWVideoEncoder) {
                            if (TXCSWVideoEncoder.this.mListener != null) {
                                TXCSWVideoEncoder.this.mListener.l(TXCSWVideoEncoder.this.mStreamType);
                            }
                            if (bl) {
                                TXCSWVideoEncoder.this.nativeEncodeSync(TXCSWVideoEncoder.this.mNativeEncoder, n6, TXCSWVideoEncoder.this.mOutputWidth, TXCSWVideoEncoder.this.mOutputHeight, TXCSWVideoEncoder.this.mPTS);
                            } else {
                                TXCSWVideoEncoder.this.nativeEncode(TXCSWVideoEncoder.this.mNativeEncoder, n6, TXCSWVideoEncoder.this.mOutputWidth, TXCSWVideoEncoder.this.mOutputHeight, TXCSWVideoEncoder.this.mPTS);
                            }
                        }
                    }
                });
            }
            if (h3 == null) {
                return 10000004L;
            }
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            h3.b(n6);
            n5 = nArray[0];
            if (n5 != 0) {
                this.callDelegate(n5);
            }
        }
        return 0L;
    }

    private native long nativeInit(WeakReference<TXCSWVideoEncoder> var1);

    private native void nativeRelease(long var1);

    private native int nativeStart(long var1, TXSVideoEncoderParam var3);

    private native void nativeStop(long var1);

    private native void nativeSetID(long var1, String var3);

    private native int nativeEncode(long var1, int var3, int var4, int var5, long var6);

    private native int nativeEncodeSync(long var1, int var3, int var4, int var5, long var6);

    private native void nativeSetFPS(long var1, int var3);

    private native void nativeSetBitrate(long var1, int var3);

    private native void nativeSetBitrateFromQos(long var1, int var3, int var4);

    private native void nativeSetEncodeIdrFpsFromQos(long var1, int var3);

    private native void nativeEnableNearestRPS(long var1, int var3);

    private native void nativeSignalEOSAndFlush(long var1);

    private native long nativeGetRealFPS(long var1);

    private native long nativegetRealBitrate(long var1);

    private native void nativeSetRPSRefBitmap(long var1, int var3, int var4, long var5);

    private native void nativeRestartIDR(long var1);

    private static native void nativeClassInit();

    private static native long nativeGetAndIncreaseSeq();

    private static native long nativeGetAndIncreaseGopIndex();

    static {
        f.f();
        TXCSWVideoEncoder.nativeClassInit();
    }
}

