/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videodecoder;

import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCKeyPointReportProxy;
import com.tencent.liteav.basic.module.TXCStatus;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.videodecoder.TXCVideoFfmpegDecoder;
import com.tencent.liteav.videodecoder.b;
import com.tencent.liteav.videodecoder.e;
import com.tencent.liteav.videodecoder.f;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.json.JSONArray;

public class TXCVideoDecoder
implements com.tencent.liteav.basic.b.b,
f {
    private static final String TAG = "TXCVideoDecoder";
    private static final boolean NEW_DECODER = true;
    boolean mNeedSortFrame = true;
    boolean mHWDec = true;
    boolean mHevc = false;
    boolean mRecvFirstFrame = false;
    Surface mSurface;
    f mDecoderListener;
    private int mDecoderCacheNum;
    private ByteBuffer mSps;
    private ByteBuffer mPps;
    private String mUserId;
    private long mNativeContext;
    private boolean mRestarting = false;
    private int mStreamType = 0;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private boolean mEnableDecoderChange = false;
    private boolean mEnableRestartDecoder = false;
    private boolean mEnableLimitDecCache = false;
    private static long mDecodeFirstFrameTS = 0L;
    b mVideoDecoder;
    private JSONArray mDecFormat = null;
    private ArrayList<TXSNALPacket> mNALList = new ArrayList();
    private a mDecoderHandler;
    private WeakReference<com.tencent.liteav.basic.b.b> mNotifyListener;

    @Override
    public void onNotifyEvent(int n2, Bundle bundle) {
        com.tencent.liteav.basic.util.f.a(this.mNotifyListener, this.mUserId, n2, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserId(String string) {
        this.mUserId = string;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeSetID(this.mNativeContext, this.mUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamType(int n2) {
        this.mStreamType = n2;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeSetStreamType(this.mNativeContext, this.mStreamType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableChange(boolean bl) {
        this.mEnableDecoderChange = bl;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeEnableDecodeChange(this.mNativeContext, this.mEnableDecoderChange);
        }
    }

    public void enableLimitDecCache(boolean bl) {
        this.mEnableLimitDecCache = bl;
        b b2 = this.mVideoDecoder;
        if (b2 != null) {
            b2.enableLimitDecCache(this.mEnableLimitDecCache);
        }
    }

    public void config(JSONArray jSONArray) {
        this.mDecFormat = jSONArray;
    }

    public void enableRestart(boolean bl) {
        this.mEnableRestartDecoder = bl;
    }

    public TXCVideoDecoder() {
        mDecodeFirstFrameTS = 0L;
    }

    public void setListener(f f2) {
        this.mDecoderListener = f2;
    }

    public boolean isHardwareDecode() {
        return this.mVideoDecoder != null;
    }

    public void setNotifyListener(com.tencent.liteav.basic.b.b b2) {
        this.mNotifyListener = new WeakReference<com.tencent.liteav.basic.b.b>(b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setup(SurfaceTexture surfaceTexture, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }
        return this.setup(new Surface(surfaceTexture), byteBuffer, byteBuffer2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setup(Surface surface, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.mSurface = surface;
        }
        this.mSps = byteBuffer;
        this.mPps = byteBuffer2;
        this.mNeedSortFrame = bl;
        return 0;
    }

    public void enableHWDec(boolean bl) {
        this.mHWDec = bl;
    }

    private void addOneNalToDecoder(TXSNALPacket tXSNALPacket) {
        boolean bl = tXSNALPacket.nalType == 0;
        Bundle bundle = new Bundle();
        bundle.putBoolean("iframe", bl);
        bundle.putByteArray("nal", tXSNALPacket.nalData);
        bundle.putLong("pts", tXSNALPacket.pts);
        bundle.putLong("dts", tXSNALPacket.dts);
        bundle.putInt("codecId", tXSNALPacket.codecId);
        Message message = new Message();
        message.what = 101;
        message.setData(bundle);
        a a2 = this.mDecoderHandler;
        if (a2 != null) {
            a2.sendMessage(message);
        }
        ++this.mDecoderCacheNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decNALByNewWay(TXSNALPacket tXSNALPacket) {
        if (this.mHWDec) {
            this.decodeFrame(tXSNALPacket.nalData, tXSNALPacket.pts, tXSNALPacket.dts, tXSNALPacket.rotation, tXSNALPacket.codecId, 0, 0, tXSNALPacket.nalType);
        } else {
            TXCVideoDecoder tXCVideoDecoder = this;
            synchronized (tXCVideoDecoder) {
                this.nativeDecodeFrame(this.mNativeContext, tXSNALPacket.nalData, tXSNALPacket.nalType, tXSNALPacket.pts, tXSNALPacket.dts, tXSNALPacket.rotation, tXSNALPacket.codecId);
            }
        }
    }

    private void decNALByOldWay(TXSNALPacket tXSNALPacket) {
        try {
            a a2;
            boolean bl;
            boolean bl2 = bl = tXSNALPacket.nalType == 0;
            if (!this.mRecvFirstFrame && !bl) {
                TXCLog.i(TAG, "play:decode: push nal ignore p frame when not got i frame");
                return;
            }
            if (!this.mRecvFirstFrame && bl) {
                TXCLog.w(TAG, "play:decode: push first i frame");
                this.mRecvFirstFrame = true;
            }
            if (!this.mRestarting && tXSNALPacket.codecId == 1 && !this.mHWDec) {
                TXCLog.w(TAG, "play:decode: hevc decode error  ");
                com.tencent.liteav.basic.util.f.a(this.mNotifyListener, -2304, "h265 Decoding failed");
                this.mRestarting = true;
            }
            if ((a2 = this.mDecoderHandler) != null) {
                if (!this.mNALList.isEmpty()) {
                    for (TXSNALPacket tXSNALPacket2 : this.mNALList) {
                        this.addOneNalToDecoder(tXSNALPacket2);
                    }
                }
                this.mNALList.clear();
                this.addOneNalToDecoder(tXSNALPacket);
            } else {
                if (bl && !this.mNALList.isEmpty()) {
                    this.mNALList.clear();
                }
                this.mNALList.add(tXSNALPacket);
                if (!this.mRestarting) {
                    this.start();
                }
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "decode NAL By Old way failed.", exception);
        }
    }

    public void pushNAL(TXSNALPacket tXSNALPacket) {
        this.decNALByNewWay(tXSNALPacket);
    }

    public synchronized int start() {
        if (this.mHWDec && this.mSurface == null) {
            TXCLog.i(TAG, "play:decode: start decoder error when not setup surface, id " + this.mUserId + "_" + this.mStreamType);
            return -1;
        }
        if (this.mNativeContext != 0L) {
            TXCLog.w(TAG, "play:decode: start decoder error when decoder is started, id " + this.mUserId + "_" + this.mStreamType);
            return -1;
        }
        TXCLog.w(TAG, "play:decode: start decoder java id " + this.mUserId + "_" + this.mStreamType + " " + this.hashCode());
        this.mNativeContext = this.nativeCreateContext(this.mHWDec);
        this.nativeSetID(this.mNativeContext, this.mUserId);
        this.nativeSetStreamType(this.mNativeContext, this.mStreamType);
        this.nativeEnableDecodeChange(this.mNativeContext, this.mEnableDecoderChange);
        this.nativeEnableRestartDecoder(this.mNativeContext, this.mEnableRestartDecoder);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.mNativeContext == 0L) {
            TXCLog.w(TAG, "play:decode: stop decoder ignore when decoder is stopped, id " + this.mUserId + "_" + this.mStreamType);
            return;
        }
        TXCLog.w(TAG, "play:decode: stop decoder java id " + this.mUserId + "_" + this.mStreamType + " " + this.hashCode());
        this.nativeDestroyContext(this.mNativeContext);
        this.mNativeContext = 0L;
        this.mNALList.clear();
        this.mRecvFirstFrame = false;
        this.mDecoderCacheNum = 0;
        mDecodeFirstFrameTS = 0L;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mVideoDecoder != null) {
                this.mVideoDecoder.stop();
                this.mVideoDecoder.setListener(null);
                this.mVideoDecoder.setNotifyListener(null);
                this.mVideoDecoder = null;
            }
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(boolean bl) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.mHWDec = bl;
            this.nativeReStart(this.mNativeContext, this.mHWDec);
        }
    }

    public int getDecoderCacheNum() {
        return this.mDecoderCacheNum + this.mNALList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodeFrame(TXSVideoFrame tXSVideoFrame, int n2, int n3, long l2, long l3, int n4) {
        int n5;
        if (mDecodeFirstFrameTS == 0L) {
            mDecodeFirstFrameTS = TXCTimeUtil.getTimeTick();
            Log.i((String)TAG, (String)("MediaCodec onDecodeFrame: decode first frame success:" + this.mUserId + "_" + this.mStreamType));
            TXCStatus.a(this.mUserId, 5005, this.mStreamType, mDecodeFirstFrameTS);
            n5 = this.mHevc ? 3 : 1;
            TXCStatus.a(this.mUserId, 5004, this.mStreamType, n5);
        }
        if (this.mDecoderListener != null) {
            this.mDecoderListener.onDecodeFrame(tXSVideoFrame, n2, n3, l2, l3, n4);
        }
        if (this.mDecoderCacheNum > 0) {
            --this.mDecoderCacheNum;
        }
        if (tXSVideoFrame == null) {
            TXCVideoDecoder tXCVideoDecoder = this;
            synchronized (tXCVideoDecoder) {
                this.nativeNotifyPts(this.mNativeContext, l2, n2, n3);
            }
        }
        n5 = this.mVideoDecoder.GetDecodeCost();
        if (this.mHWDec) {
            TXCStatus.a(this.mUserId, 8004, this.mStreamType, n5);
        } else {
            TXCStatus.a(this.mUserId, 8003, this.mStreamType, n5);
        }
    }

    @Override
    public void onVideoSizeChange(int n2, int n3) {
        f f2 = this.mDecoderListener;
        if (f2 != null && (this.mVideoWidth != n2 || this.mVideoHeight != n3)) {
            this.mVideoWidth = n2;
            this.mVideoHeight = n3;
            f2.onVideoSizeChange(this.mVideoWidth, this.mVideoHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodeFailed(int n2) {
        if (this.mDecoderListener != null) {
            this.mDecoderListener.onDecodeFailed(n2);
        }
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeDecCache(this.mNativeContext);
        }
    }

    public boolean isHevc() {
        a a2 = this.mDecoderHandler;
        if (a2 != null) {
            return a2.a();
        }
        return false;
    }

    public long GetDecodeFirstFrameTS() {
        return mDecodeFirstFrameTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startDecodeThread() {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mDecoderHandler != null) {
                TXCLog.e(TAG, "play:decode: start decoder error when decoder is started");
                return -1;
            }
            this.mDecoderCacheNum = 0;
            this.mRestarting = false;
            HandlerThread handlerThread = new HandlerThread("VDecoder");
            handlerThread.start();
            if (this.mHWDec) {
                handlerThread.setName("VideoWDec" + handlerThread.getId());
            } else {
                handlerThread.setName("VideoSWDec" + handlerThread.getId());
            }
            a a2 = new a(handlerThread.getLooper());
            a2.a(this.mHevc, this.mHWDec, this.mSurface, this.mSps, this.mPps, this, this);
            TXCLog.w(TAG, "play:decode: start decode thread");
            Message message = Message.obtain();
            message.what = 100;
            message.obj = this.mNeedSortFrame;
            a2.sendMessage(message);
            this.mDecoderHandler = a2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDecodeThread() {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mDecoderHandler != null) {
                this.mDecoderHandler.sendEmptyMessage(102);
            }
            this.mDecoderHandler = null;
        }
    }

    private void notifyDecoderStartEvent(boolean bl) {
        TXCEventRecorderProxy.a(this.mUserId, 4005, bl ? 1L : 0L, -1L, "", this.mStreamType);
        Bundle bundle = new Bundle();
        bundle.putInt("EVT_ID", 2008);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        bundle.putCharSequence("EVT_MSG", (CharSequence)(bl ? "Enables hardware decoding" : "Enables software decoding"));
        bundle.putInt("EVT_PARAM1", bl ? 1 : 2);
        com.tencent.liteav.basic.util.f.a(this.mNotifyListener, this.mUserId, 2008, bundle);
        TXCKeyPointReportProxy.a(this.mUserId, 40026, bl ? 1L : 2L, this.mStreamType);
    }

    private boolean hasSurface() {
        return this.mSurface != null;
    }

    private native long nativeCreateContext(boolean var1);

    private native void nativeDestroyContext(long var1);

    private native void nativeSetID(long var1, String var3);

    private native void nativeSetStreamType(long var1, int var3);

    private native void nativeReStart(long var1, boolean var3);

    private native void nativeDecCache(long var1);

    private native void nativeNotifyPts(long var1, long var3, int var5, int var6);

    private native void nativeDecodeFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10);

    private native void nativeEnableDecodeChange(long var1, boolean var3);

    private native void nativeEnableRestartDecoder(long var1, boolean var3);

    private void onDecodeDone(TXSVideoFrame tXSVideoFrame, int n2, int n3, long l2, long l3, int n4, int n5) {
        f f2;
        if (mDecodeFirstFrameTS == 0L) {
            mDecodeFirstFrameTS = TXCTimeUtil.getTimeTick();
            Log.i((String)TAG, (String)("SoftDecode onDecodeFrame: decode first frame success:" + this.mUserId + "_" + this.mStreamType));
            TXCStatus.a(this.mUserId, 5005, this.mStreamType, mDecodeFirstFrameTS);
            int n6 = this.mHevc ? 2 : 0;
            TXCStatus.a(this.mUserId, 5004, this.mStreamType, n6);
        }
        if ((f2 = this.mDecoderListener) != null) {
            tXSVideoFrame.width = n2;
            tXSVideoFrame.height = n3;
            tXSVideoFrame.rotation = n4;
            tXSVideoFrame.pts = l2;
            tXSVideoFrame.frameType = n5;
            f2.onDecodeFrame(tXSVideoFrame, n2, n3, l2, l3, n4);
            if (this.mVideoWidth != n2 || this.mVideoHeight != n3) {
                this.mVideoWidth = n2;
                this.mVideoHeight = n3;
                f2.onVideoSizeChange(this.mVideoWidth, this.mVideoHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeFrame(byte[] byArray, long l2, long l3, int n2, int n3, int n4, int n5, int n6) {
        TXSNALPacket tXSNALPacket = new TXSNALPacket();
        tXSNALPacket.nalData = byArray;
        tXSNALPacket.pts = l2;
        tXSNALPacket.dts = l3;
        tXSNALPacket.rotation = n2;
        tXSNALPacket.codecId = n3;
        tXSNALPacket.nalType = n6;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mNativeContext != 0L && this.mVideoDecoder == null) {
                e e2 = new e();
                e2.a(n4, n5);
                e2.setListener(this);
                e2.setNotifyListener(this.mNotifyListener);
                e2.a(this.mDecFormat);
                e2.config(this.mSurface);
                e2.enableLimitDecCache(this.mEnableLimitDecCache);
                e2.start(this.mSps, this.mPps, this.mNeedSortFrame, this.mHevc);
                this.notifyDecoderStartEvent(true);
                this.mVideoDecoder = e2;
            }
            if (this.mVideoDecoder != null) {
                this.mVideoDecoder.decode(tXSNALPacket);
            }
        }
    }

    private synchronized void stopHWDecoder() {
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.stop();
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder = null;
        }
    }

    private void onStartDecoder(boolean bl) {
        this.notifyDecoderStartEvent(bl);
    }

    static {
        com.tencent.liteav.basic.util.f.f();
    }

    private static class a
    extends Handler {
        b a;
        f b;
        WeakReference<com.tencent.liteav.basic.b.b> c;
        boolean d;
        boolean e;
        Surface f;
        private ByteBuffer g;
        private ByteBuffer h;

        public a(Looper looper) {
            super(looper);
        }

        public void a(boolean bl, boolean bl2, Surface surface, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, f f2, com.tencent.liteav.basic.b.b b2) {
            this.e = bl;
            this.d = bl2;
            this.f = surface;
            this.g = byteBuffer;
            this.h = byteBuffer2;
            this.b = f2;
            this.c = new WeakReference<com.tencent.liteav.basic.b.b>(b2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 100: {
                    this.a((Boolean)message.obj);
                    break;
                }
                case 101: {
                    try {
                        Bundle bundle = message.getData();
                        byte[] byArray = bundle.getByteArray("nal");
                        long l2 = bundle.getLong("pts");
                        long l3 = bundle.getLong("dts");
                        int n2 = bundle.getInt("codecId");
                        this.a(byArray, l2, l3, n2);
                    }
                    catch (Exception exception) {
                        TXCLog.e(TXCVideoDecoder.TAG, "decode frame failed." + exception.getMessage());
                    }
                    break;
                }
                case 102: {
                    this.b();
                    break;
                }
                case 103: {
                    this.a(message.arg1 == 1, message.arg2 == 1);
                }
            }
        }

        public boolean a() {
            if (this.a != null) {
                return this.a.isHevc();
            }
            return false;
        }

        private void a(byte[] byArray, long l2, long l3, int n2) {
            TXSNALPacket tXSNALPacket = new TXSNALPacket();
            tXSNALPacket.nalData = byArray;
            tXSNALPacket.pts = l2;
            tXSNALPacket.dts = l3;
            tXSNALPacket.codecId = n2;
            if (this.a != null) {
                this.a.decode(tXSNALPacket);
            }
        }

        private void b() {
            if (this.a != null) {
                this.a.stop();
                this.a.setListener(null);
                this.a.setNotifyListener(null);
                this.a = null;
            }
            Looper.myLooper().quit();
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: stop decode hwdec: " + this.d);
        }

        private void a(boolean bl, boolean bl2) {
            this.d = bl;
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: restart decode hwdec: " + this.d);
            if (this.a != null) {
                this.a.stop();
                this.a.setListener(null);
                this.a.setNotifyListener(null);
                this.a = null;
            }
            this.a(bl2);
        }

        private void a(boolean bl) {
            if (this.a != null) {
                TXCLog.i(TXCVideoDecoder.TAG, "play:decode: start decode ignore hwdec: " + this.d);
                return;
            }
            this.a = this.d ? new e() : new TXCVideoFfmpegDecoder();
            this.a.setListener(this.b);
            this.a.setNotifyListener(this.c);
            this.a.config(this.f);
            this.a.start(this.g, this.h, bl, this.e);
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: start decode hwdec: " + this.d + ", hevc: " + this.e);
        }
    }
}

