/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import com.tencent.qcloud.core.network.QCloudResult;
import com.tencent.qcloud.core.network.annotation.SequenceFieldKeySorter;
import com.tencent.qcloud.core.network.exception.QCloudClientException;
import com.tencent.qcloud.core.network.response.serializer.ResponseBodySerializer;
import com.tencent.qcloud.core.network.response.serializer.ResponseHelper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Response;

public class ResponseXmlS3BodySerializer
implements ResponseBodySerializer {
    private Class cls;
    private final String S3_RESPONSE_ROOT_NODE = "s3_response_root_node";

    public ResponseXmlS3BodySerializer(Class cls) {
        this.cls = cls;
    }

    public QCloudResult serialize(Response response) throws QCloudClientException {
        if (response == null) {
            return null;
        }
        if (response.body() != null) {
            try {
                String xmlString = response.body().string();
                int index = xmlString.lastIndexOf("?>");
                if (index >= 0) {
                    if (xmlString.length() > 2) {
                        xmlString = xmlString.substring(index + 2);
                    } else {
                        throw new QCloudClientException("parse http xml body error");
                    }
                }
                xmlString = String.format(Locale.ENGLISH, "<%s>%s%s%s</%s>", "s3_response_root_node", System.getProperty("line.separator"), xmlString, System.getProperty("line.separator"), "s3_response_root_node");
                XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new SequenceFieldKeySorter())));
                xStream.processAnnotations(this.cls);
                xStream.alias("s3_response_root_node", this.cls);
                return (QCloudResult)xStream.fromXML(xmlString);
            }
            catch (IOException e) {
                throw new QCloudClientException("parse http xml body error", (Throwable)e);
            }
        }
        return ResponseHelper.noBodyResult((Class)this.cls, (Response)response);
    }
}

