/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.OptionObjectResult;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import java.util.Iterator;
import java.util.Map;

public final class OptionObjectRequest
extends CosXmlRequest {
    private String origin;
    private String accessControlMethod;
    private String accessControlHeaders;
    private String cosPath;

    public OptionObjectRequest(String bucket, String cosPath, String origin, String accessControlMethod) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.origin = origin;
        this.accessControlMethod = accessControlMethod;
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.setOrigin(origin);
        this.setAccessControlMethod(accessControlMethod);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(OptionObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.origin == null) {
            throw new CosXmlClientException("option request origin must not be null");
        }
        if (this.accessControlMethod == null) {
            throw new CosXmlClientException("option request accessControlMethod must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "OPTIONS";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        if (origin != null) {
            this.requestHeaders.put("Origin", origin);
        }
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setAccessControlMethod(String accessControlMethod) {
        if (accessControlMethod != null) {
            this.accessControlMethod = accessControlMethod.toUpperCase();
            this.requestHeaders.put("Access-Control-Request-Method", this.accessControlMethod);
        }
    }

    public String getAccessControlMethod() {
        return this.accessControlMethod;
    }

    public void setAccessControlHeaders(String accessControlHeaders) {
        this.accessControlHeaders = accessControlHeaders;
        if (accessControlHeaders != null) {
            this.requestHeaders.put("Access-Control-Request-Headers", accessControlHeaders);
        }
    }

    public String getAccessControlHeaders() {
        return this.accessControlHeaders;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }
}

