/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.tag.CompleteMultipartUpload;
import com.tencent.cos.xml.model.tag.Part;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestXmlBodySerializer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class CompleteMultiUploadRequest
extends CosXmlRequest<CompleteMultiUploadResult> {
    private CompleteMultipartUpload completeMultipartUpload;
    private String uploadId;
    private String cosPath;

    public CompleteMultiUploadRequest(String bucket, String cosPath, String uploadId, Map<Integer, String> partNumberAndETag) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.uploadId = uploadId;
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.completeMultipartUpload = new CompleteMultipartUpload();
        this.completeMultipartUpload.partList = new ArrayList<Part>();
        this.setPartNumberAndETag(partNumberAndETag);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestOriginBuilder.body((RequestBodySerializer)new RequestXmlBodySerializer((Object)this.completeMultipartUpload));
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(CompleteMultiUploadResult.class);
    }

    public CompleteMultipartUpload getCompleteMultipartUpload() {
        return this.completeMultipartUpload;
    }

    public void setPartNumberAndETag(int partNumbers, String eTag) {
        Part part = new Part();
        part.partNumber = partNumbers;
        part.eTag = eTag;
        this.completeMultipartUpload.partList.add(part);
    }

    public void setPartNumberAndETag(Map<Integer, String> partNumberAndETag) {
        if (partNumberAndETag != null) {
            for (Map.Entry<Integer, String> entry : partNumberAndETag.entrySet()) {
                Part part = new Part();
                part.partNumber = entry.getKey();
                part.eTag = entry.getValue();
                this.completeMultipartUpload.partList.add(part);
            }
        }
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("uploadID", this.uploadId);
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException("uploadID must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "POST";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }
}

