/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingResult;
import com.tencent.cos.xml.model.tag.Tag;
import com.tencent.cos.xml.model.tag.TagSet;
import com.tencent.cos.xml.model.tag.Tagging;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.action.QCloudBodyMd5Action;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestXmlBodySerializer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PutBucketTaggingRequest
extends CosXmlRequest {
    private Tagging tagging;

    public PutBucketTaggingRequest(String bucket) {
        this.bucket = bucket;
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.tagging = new Tagging();
        this.tagging.tagSet = new TagSet();
        this.tagging.tagSet.tagList = new ArrayList<Tag>();
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestActions.add(new QCloudBodyMd5Action());
        this.requestOriginBuilder.body((RequestBodySerializer)new RequestXmlBodySerializer((Object)this.tagging));
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutBucketTaggingResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("tagging", null);
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void addTags(List<Tag> tags) {
        if (tags != null) {
            this.tagging.tagSet.tagList.addAll(tags);
        }
    }

    public Tagging getTagging() {
        return this.tagging;
    }

    public void addTag(Tag tag) {
        if (tag != null) {
            this.tagging.tagSet.tagList.add(tag);
        }
    }
}

