/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.bucket.PutBucketResult;
import com.tencent.cos.xml.model.tag.ACLAccounts;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestByteArraySerializer;
import java.util.Iterator;
import java.util.Map;

public final class PutBucketRequest
extends CosXmlRequest {
    public PutBucketRequest(String bucket) {
        this.bucket = bucket;
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestOriginBuilder.body((RequestBodySerializer)new RequestByteArraySerializer(new byte[0], "text/plain"));
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutBucketResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setXCOSACL(String xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL);
        }
    }

    public void setXCOSACL(COSACL xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL.getACL());
        }
    }

    public void setXCOSGrantRead(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-read", aclAccounts.aclDesc());
        }
    }

    public void setXCOSGrantWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-write", aclAccounts.aclDesc());
        }
    }

    public void setXCOSReadWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-full-control", aclAccounts.aclDesc());
        }
    }
}

