/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import com.tencent.qcloud.core.network.QCloudServiceConfig;
import java.util.Locale;

public class CosXmlServiceConfig
extends QCloudServiceConfig {
    static CosXmlServiceConfig instance;
    final String scheme;
    final String appid;
    final String region;

    private CosXmlServiceConfig(Builder builder) {
        super((QCloudServiceConfig.Builder)builder);
        this.appid = builder.appid;
        this.region = builder.region;
        this.scheme = builder.scheme;
    }

    public static CosXmlServiceConfig getInstance() {
        return instance;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getRegion() {
        return this.region;
    }

    public static final class Builder
    extends QCloudServiceConfig.Builder<Builder> {
        private String scheme = "http";
        private String appid;
        private String region;

        public Builder() {
            this.setUserAgent("cos-xml-android-sdk-1.2.0");
        }

        public Builder isHttps() {
            this.scheme = "https";
            return this;
        }

        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            this.setHost(this.getHttpHost(appid, region));
            return this;
        }

        public CosXmlServiceConfig build() {
            return new CosXmlServiceConfig(this);
        }

        private String getHttpHost(String appid, String region) {
            if (!region.startsWith("cos.")) {
                String[] old_regions;
                boolean isOldRegion = false;
                for (String old_region : old_regions = new String[]{"cn-east", "cn-south", "cn-north", "cn-south-2", "cn-southwest", "sg"}) {
                    if (!old_region.equals(region)) continue;
                    isOldRegion = true;
                    break;
                }
                if (!isOldRegion) {
                    region = "cos." + region;
                }
            }
            return String.format(Locale.ENGLISH, "-%s.%s.myqcloud.com", appid, region);
        }
    }
}

