/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.CosXml;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.CosXmlResultListener;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketTaggingResult;
import com.tencent.cos.xml.model.bucket.GetBucketACLRequest;
import com.tencent.cos.xml.model.bucket.GetBucketACLResult;
import com.tencent.cos.xml.model.bucket.GetBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.GetBucketCORSResult;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.GetBucketLocationRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLocationResult;
import com.tencent.cos.xml.model.bucket.GetBucketRequest;
import com.tencent.cos.xml.model.bucket.GetBucketResult;
import com.tencent.cos.xml.model.bucket.GetBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.GetBucketTaggingResult;
import com.tencent.cos.xml.model.bucket.HeadBucketRequest;
import com.tencent.cos.xml.model.bucket.HeadBucketResult;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.cos.xml.model.bucket.PutBucketACLRequest;
import com.tencent.cos.xml.model.bucket.PutBucketACLResult;
import com.tencent.cos.xml.model.bucket.PutBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.PutBucketCORSResult;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.PutBucketRequest;
import com.tencent.cos.xml.model.bucket.PutBucketResult;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.AppendObjectResult;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.DeleteMultiObjectRequest;
import com.tencent.cos.xml.model.object.DeleteMultiObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.GetObjectACLRequest;
import com.tencent.cos.xml.model.object.GetObjectACLResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.OptionObjectRequest;
import com.tencent.cos.xml.model.object.OptionObjectResult;
import com.tencent.cos.xml.model.object.PutObjectACLRequest;
import com.tencent.cos.xml.model.object.PutObjectACLResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.service.GetServiceRequest;
import com.tencent.cos.xml.model.service.GetServiceResult;
import com.tencent.qcloud.core.network.QCloudHttpRequest;
import com.tencent.qcloud.core.network.QCloudRequest;
import com.tencent.qcloud.core.network.QCloudResult;
import com.tencent.qcloud.core.network.QCloudResultListener;
import com.tencent.qcloud.core.network.QCloudService;
import com.tencent.qcloud.core.network.QCloudServiceConfig;
import com.tencent.qcloud.core.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.network.exception.QCloudClientException;
import com.tencent.qcloud.core.network.exception.QCloudServiceException;

public class CosXmlService
implements CosXml {
    private QCloudService mService;

    public CosXmlService(Context context, CosXmlServiceConfig serviceConfig, QCloudCredentialProvider basicCredentialProvider) {
        this.mService = new QCloudService.Builder(context).serviceConfig((QCloudServiceConfig)serviceConfig).credentialProvider(basicCredentialProvider).build();
        CosXmlServiceConfig.instance = serviceConfig;
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetServiceResult)this.sendRequest(request);
    }

    @Override
    public void getServiceAsync(GetServiceRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (AbortMultiUploadResult)this.sendRequest(request);
    }

    @Override
    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public AppendObjectResult appendObject(AppendObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        AppendObjectResult appendObjectResult = (AppendObjectResult)this.sendRequest(request);
        this.generateAccessUrl(request, appendObjectResult);
        return appendObjectResult;
    }

    @Override
    public void appendObjectAsync(AppendObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)this.sendRequest(request);
        this.generateAccessUrl(request, completeMultiUploadResult);
        return completeMultiUploadResult;
    }

    @Override
    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteMultiObjectResult deleteMultiObject(DeleteMultiObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteMultiObjectResult)this.sendRequest(request);
    }

    @Override
    public void deleteMultiObjectAsync(DeleteMultiObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteObjectResult)this.sendRequest(request);
    }

    @Override
    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetObjectACLResult getObjectACL(GetObjectACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetObjectACLResult)this.sendRequest(request);
    }

    @Override
    public void getObjectACLAsync(GetObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetObjectResult)this.sendRequest(request);
    }

    @Override
    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (HeadObjectResult)this.sendRequest(request);
    }

    @Override
    public void headObjectAsync(HeadObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (InitMultipartUploadResult)this.sendRequest(request);
    }

    @Override
    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (ListPartsResult)this.sendRequest(request);
    }

    @Override
    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public OptionObjectResult optionObject(OptionObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (OptionObjectResult)this.sendRequest(request);
    }

    @Override
    public void optionObjectAsync(OptionObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutObjectACLResult putObjectACL(PutObjectACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutObjectACLResult)this.sendRequest(request);
    }

    @Override
    public void putObjectACLAsync(PutObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PutObjectResult putObjectResult = (PutObjectResult)this.sendRequest(request);
        this.generateAccessUrl(request, putObjectResult);
        return putObjectResult;
    }

    @Override
    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (CopyObjectResult)this.sendRequest(request);
    }

    @Override
    public void copyObjectAsync(CopyObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (UploadPartResult)this.sendRequest(request);
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteBucketCORSResult deleteBucketCORS(DeleteBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteBucketCORSResult)this.sendRequest(request);
    }

    @Override
    public void deleteBucketCORSAsync(DeleteBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteBucketLifecycleResult deleteBucketLifecycle(DeleteBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteBucketLifecycleResult)this.sendRequest(request);
    }

    @Override
    public void deleteBucketLifecycleAsync(DeleteBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteBucketResult deleteBucket(DeleteBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteBucketResult)this.sendRequest(request);
    }

    @Override
    public void deleteBucketAsync(DeleteBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public DeleteBucketTaggingResult deleteBucketTagging(DeleteBucketTaggingRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteBucketTaggingResult)this.sendRequest(request);
    }

    @Override
    public void deleteBucketTaggingAsync(DeleteBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketACLResult getBucketACL(GetBucketACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketACLResult)this.sendRequest(request);
    }

    @Override
    public void getBucketACLAsync(GetBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketCORSResult getBucketCORS(GetBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketCORSResult)this.sendRequest(request);
    }

    @Override
    public void getBucketCORSAsync(GetBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketLifecycleResult getBucketLifecycle(GetBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketLifecycleResult)this.sendRequest(request);
    }

    @Override
    public void getBucketLifecycleAsync(GetBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketLocationResult getBucketLocation(GetBucketLocationRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketLocationResult)this.sendRequest(request);
    }

    @Override
    public void getBucketLocationAsync(GetBucketLocationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketResult getBucket(GetBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketResult)this.sendRequest(request);
    }

    @Override
    public void getBucketAsync(GetBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public GetBucketTaggingResult getBucketTagging(GetBucketTaggingRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (GetBucketTaggingResult)this.sendRequest(request);
    }

    @Override
    public void getBucketTaggingAsync(GetBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (HeadBucketResult)this.sendRequest(request);
    }

    @Override
    public void headBucketAsync(HeadBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public ListMultiUploadsResult listMultiUploads(ListMultiUploadsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (ListMultiUploadsResult)this.sendRequest(request);
    }

    @Override
    public void listMultiUploadsAsync(ListMultiUploadsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutBucketACLResult putBucketACL(PutBucketACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutBucketACLResult)this.sendRequest(request);
    }

    @Override
    public void putBucketACLAsync(PutBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutBucketCORSResult putBucketCORS(PutBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutBucketCORSResult)this.sendRequest(request);
    }

    @Override
    public void putBucketCORSAsync(PutBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutBucketLifecycleResult putBucketLifecycle(PutBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutBucketLifecycleResult)this.sendRequest(request);
    }

    @Override
    public void putBucketLifecycleAsync(PutBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutBucketResult putBucket(PutBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutBucketResult)this.sendRequest(request);
    }

    @Override
    public void putBucketAsync(PutBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public PutBucketTaggingResult putBucketTagging(PutBucketTaggingRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (PutBucketTaggingResult)this.sendRequest(request);
    }

    @Override
    public void putBucketTaggingAsync(PutBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.sendRequestAsync(request, cosXmlResultListener);
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest) {
        this.mService.cancel((QCloudHttpRequest)cosXmlRequest);
    }

    @Override
    public void cancelAll() {
        this.mService.cancelAll();
    }

    @Override
    public void release() {
        this.mService.release();
    }

    private CosXmlResult sendRequest(CosXmlRequest request) throws CosXmlClientException, CosXmlServiceException {
        CosXmlResult cosXmlResult = null;
        try {
            cosXmlResult = (CosXmlResult)this.mService.execute((QCloudHttpRequest)request);
        }
        catch (QCloudClientException e) {
            throw new CosXmlClientException(e);
        }
        this.isServiceException(cosXmlResult);
        return cosXmlResult;
    }

    private void isServiceException(CosXmlResult cosXmlResult) throws CosXmlServiceException {
        int httpCode;
        if (cosXmlResult != null && ((httpCode = cosXmlResult.getHttpCode()) >= 300 || httpCode < 200)) {
            throw new CosXmlServiceException(httpCode, cosXmlResult.getHttpMessage(), cosXmlResult.error);
        }
    }

    private void sendRequestAsync(final CosXmlRequest cosXmlRequest, final CosXmlResultListener cosXmlResultListener) {
        this.mService.enqueue((QCloudHttpRequest)cosXmlRequest, new QCloudResultListener(){

            public void onSuccess(QCloudRequest request, QCloudResult result) {
                CosXmlService.this.getResultByQCloudResult(cosXmlRequest, (CosXmlResult)result, cosXmlResultListener);
            }

            public void onFailed(QCloudRequest request, QCloudClientException clientException, QCloudServiceException serviceException) {
                cosXmlResultListener.onFail(cosXmlRequest, new CosXmlClientException((Throwable)clientException), null);
            }
        });
    }

    private void getResultByQCloudResult(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult, CosXmlResultListener cosXmlResultListener) {
        if (cosXmlResult != null && cosXmlResultListener != null) {
            try {
                this.isServiceException(cosXmlResult);
                if (cosXmlRequest instanceof AppendObjectRequest || cosXmlRequest instanceof PutObjectRequest || cosXmlRequest instanceof CompleteMultiUploadRequest) {
                    this.generateAccessUrl(cosXmlRequest, cosXmlResult);
                }
                cosXmlResultListener.onSuccess(cosXmlRequest, cosXmlResult);
            }
            catch (CosXmlServiceException e) {
                cosXmlResultListener.onFail(cosXmlRequest, null, e);
            }
        }
    }

    private void generateAccessUrl(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
        if (cosXmlRequest == null || cosXmlResult == null) {
            return;
        }
        if (cosXmlResult.getHttpCode() >= 200 && cosXmlResult.getHttpCode() < 300) {
            StringBuilder accessUrl = new StringBuilder();
            CosXmlServiceConfig qCloudServiceConfig = CosXmlServiceConfig.getInstance();
            if (qCloudServiceConfig != null) {
                accessUrl.append(qCloudServiceConfig.getScheme()).append("://").append(cosXmlRequest.getBucket()).append(qCloudServiceConfig.getHttpHost()).append(cosXmlRequest.getRequestPath());
            }
            cosXmlResult.accessUrl = accessUrl.toString();
        }
    }
}

