/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import com.tencent.cos.xml.utils.StringUtils;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    public static String getMD5FromBytes(byte[] data, int offset, int len) throws Exception {
        if (data == null || len <= 0 || offset < 0) {
            throw new IllegalArgumentException("data == null | len <= 0 |offset < 0 |offset >= len");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data, offset, len);
            return StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    public static String getMD5FromString(String content) throws Exception {
        if (content == null) {
            return null;
        }
        byte[] data = content.getBytes("utf-8");
        return MD5Utils.getMD5FromBytes(data, 0, data.length);
    }

    public static String getMD5FromPath(String filePath) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            int len;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[65536];
            while ((len = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            String string = StringUtils.toHexString(messageDigest.digest());
            return string;
        }
    }
}

