/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.bucket.GetBucketResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.Map;

public class GetBucketRequest
extends CosXmlRequest {
    private String prefix = null;
    private String delimiter = null;
    private String encodingType;
    private String marker = null;
    private String maxKeys = "1000";

    public GetBucketRequest() {
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(GetBucketResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        if (this.prefix != null) {
            this.requestQueryParams.put("prefix", this.prefix);
        }
        if (this.delimiter != null) {
            this.requestQueryParams.put("delimiter", this.delimiter);
        }
        if (this.encodingType != null) {
            this.requestQueryParams.put("encoding-type", this.encodingType);
        }
        if (this.marker != null) {
            this.requestQueryParams.put("marker", this.marker);
        }
        if (this.maxKeys != null) {
            this.requestQueryParams.put("max-keys", this.maxKeys);
        }
        if (this.prefix != null) {
            this.requestQueryParams.put("prefix", this.prefix);
        }
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "GET";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = String.valueOf(delimiter);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMaxKeys(long maxKeys) {
        this.maxKeys = String.valueOf(maxKeys);
    }

    public long getMaxKeys() {
        return Long.parseLong(this.maxKeys);
    }
}

