/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJsonBodyTwoDegreeSerializer
implements ResponseBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseJsonBodyTwoDegreeSerializer.class);
    private Class cls;

    public ResponseJsonBodyTwoDegreeSerializer(Class cls) {
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        String jsonString = null;
        try (ResponseBody responseBody = response.body();){
            jsonString = responseBody.string();
        }
        QCloudLogger.debug(this.logger, jsonString);
        QCloudResult result = null;
        try {
            result = (QCloudResult)JSON.parseObject((String)this.getOneDegreeJson(jsonString), (Class)this.cls);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new QCloudException(QCloudExceptionType.HTTP_RESPONSE_JSON_PARSE_OBJECT_FAILED);
        }
        if (result == null) {
            result = ResponseSerializerHelper.noBodyResult(this.cls, response);
        }
        return result;
    }

    private String getOneDegreeJson(String jsonStr) {
        QCloudLogger.debug(this.logger, "before change : {}", jsonStr);
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        JSONObject json = new JSONObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject json2 = (JSONObject)entry.getValue();
                for (Map.Entry innerEntry : json2.entrySet()) {
                    json.put((String)innerEntry.getKey(), innerEntry.getValue());
                }
                continue;
            }
            json.put((String)entry.getKey(), entry.getValue());
        }
        QCloudLogger.debug(this.logger, "after change : {}", json.toString());
        return json.toString();
    }
}

