/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.serializer.body;

import com.alibaba.fastjson.JSON;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseJsonBodyLowestSerializer;
import com.tencent.qcloud.network.tools.QCloudJsonTools;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestJsonBodySerializer
implements RequestBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseJsonBodyLowestSerializer.class);
    private Map<String, String> keyValues = new HashMap<String, String>();

    public void bodyKeyValue(String key, String value) {
        this.keyValues.put(key, value);
    }

    public void bodyKeyValue(String key, Map<String, String> keyValues) {
        keyValues.put(key, QCloudJsonTools.Map2JsonString(keyValues));
    }

    @Override
    public RequestBody serialize() {
        String jsonBody = JSON.toJSONString(this.keyValues);
        QCloudLogger.info(this.logger, jsonBody);
        if (jsonBody == null) {
            QCloudLogger.warn(this.logger, "json body is null");
            return null;
        }
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody);
    }
}

