/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.serializer.body;

import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.common.QCloudMimeType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import com.tencent.qcloud.network.request.bodys.FileRequestBody;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFormDataSerializer
implements RequestBodySerializer {
    private Logger logger = LoggerFactory.getLogger(RequestFormDataSerializer.class);
    private Map<String, String> keyValues = new HashMap<String, String>();
    private Map<String, String> uploadFiles = new HashMap<String, String>();
    private QCloudProgressListener progressListener;

    public void bodyKeyValue(String key, String value) {
        this.keyValues.put(key, value);
    }

    public void uploadFile(String filePath, String uploadName) {
        this.uploadFiles.put(filePath, uploadName);
    }

    @Override
    public RequestBody serialize() {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MediaType.parse((String)"multipart/form-data"));
        for (Map.Entry<String, String> entry : this.keyValues.entrySet()) {
            bodyBuilder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.uploadFiles.entrySet()) {
            QCloudLogger.debug(this.logger, "file path is " + entry.getKey());
            String path = entry.getKey();
            String type = entry.getValue();
            File file = new File(path);
            if (file.exists()) {
                FileRequestBody fileRequestBody = new FileRequestBody(file, QCloudMimeType.getTypeByFileName(file.getName()));
                bodyBuilder.addFormDataPart(type, file.getName(), (RequestBody)fileRequestBody);
                fileRequestBody.setProgressListener(new BodyUploadProgressListener(){

                    @Override
                    public void onProgress(long progress, long max) {
                        if (RequestFormDataSerializer.this.progressListener != null) {
                            RequestFormDataSerializer.this.progressListener.onProgress(progress, max);
                        }
                    }
                });
                continue;
            }
            QCloudLogger.error(this.logger, "file do not exists");
        }
        return bodyBuilder.build();
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

