/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.serializer.body;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import com.tencent.qcloud.network.request.bodys.FileRequestBody;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import java.io.File;
import java.security.InvalidParameterException;
import okhttp3.RequestBody;

public class RequestFileBodySerializer
implements RequestBodySerializer {
    private String path;
    private long offset = -1L;
    private long length = -1L;
    private String mimeType;
    private QCloudProgressListener progressListener;

    public RequestFileBodySerializer(String path, String mimeType) {
        this(path, mimeType, -1L, -1L);
    }

    public RequestFileBodySerializer(String path) {
        this(path, null);
    }

    public RequestFileBodySerializer(String path, String mimeType, long offset, long length) {
        this.path = path;
        this.mimeType = mimeType;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public RequestBody serialize() {
        File file = new File(this.path);
        if (!file.exists()) {
            throw new InvalidParameterException("upload file does not exist");
        }
        if (TextUtils.isEmpty((CharSequence)this.mimeType)) {
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)this.path);
            this.mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        FileRequestBody fileRequestBody = new FileRequestBody(file, this.mimeType, this.offset, this.length);
        fileRequestBody.setProgressListener(new BodyUploadProgressListener(){

            @Override
            public void onProgress(long progress, long max) {
                if (RequestFileBodySerializer.this.progressListener != null) {
                    RequestFileBodySerializer.this.progressListener.onProgress(progress, max);
                }
            }
        });
        return fileRequestBody;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

