/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.bodys;

import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayRequestBody
extends RequestBody {
    private static final Logger logger = LoggerFactory.getLogger(ByteArrayRequestBody.class);
    private final byte[] bytes;
    private final String contentType;
    private BodyUploadProgressListener progressListener;

    public void setProgressListener(BodyUploadProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public ByteArrayRequestBody(byte[] bytes, String contentType) {
        this.bytes = bytes;
        this.contentType = contentType;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long all;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes);
        Source source = Okio.source((InputStream)byteArrayInputStream);
        long remain = all = (long)this.bytes.length;
        int bufferSize = 2048;
        int percent = 0;
        while (remain > 0L) {
            int progress;
            long maxReadSize = Math.min((long)bufferSize, remain);
            long readLength = source.read(bufferedSink.buffer(), maxReadSize);
            if (readLength != -1L && (progress = (int)Math.floor(100.0 * (double)(all - (remain -= readLength)) / (double)all)) >= percent) {
                ++percent;
                if (this.progressListener != null) {
                    this.progressListener.onProgress(all - remain, all);
                }
            }
            bufferedSink.flush();
        }
        QCloudLogger.info(logger, "file finished.");
        if (source != null) {
            source.close();
        }
    }

    public long contentLength() throws IOException {
        return this.bytes.length;
    }
}

